/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.domain;

import java.util.HashSet;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.web.jcr.rest.client.domain.NodeType;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Server;
import org.modeshape.web.jcr.rest.client.domain.Workspace;

public final class WorkspaceTest {
    private static final String NAME1 = "nt:file";
    private static final String NAME2 = "nt:resource";
    private static final Server SERVER1 = new Server("file:/tmp/temp.txt/resources", "user", "pswd");
    private static final Repository REPOSITORY1 = new Repository("nt:file", SERVER1);
    private static final Workspace WORKSPACE1 = new Workspace("nt:file", REPOSITORY1);
    private static final Workspace WORKSPACE2 = new Workspace("nt:resource", REPOSITORY1);
    private static final NodeType NODETYPE1 = new NodeType("nt:file", WORKSPACE1, null);
    private static final NodeType NODETYPE2 = new NodeType("nt:file", WORKSPACE1, new Properties());

    @Test
    public void shouldBeEqualIfHavingSameProperies() {
        Assert.assertThat((Object)NODETYPE2, (Matcher)IsEqual.equalTo((Object)new NodeType(NAME1, WORKSPACE1, new Properties())));
    }

    @Test
    public void shouldHashToSameValueIfEquals() {
        HashSet<NodeType> set = new HashSet<NodeType>();
        set.add(NODETYPE1);
        set.add(new NodeType(NAME1, WORKSPACE1, null));
        Assert.assertThat((Object)set.size(), (Matcher)IsEqual.equalTo((Object)1));
    }

    @Test(expected=AssertionError.class)
    public void shouldNotAllowNullName() {
        new NodeType(null, WORKSPACE1, new Properties());
    }

    @Test(expected=AssertionError.class)
    public void shouldNotAllowNullRepository() {
        new NodeType(NAME1, null, null);
    }

    @Test
    public void shouldNotBeEqualIfSameNameButDifferentWorkspace() {
        Assert.assertThat((Object)NODETYPE2, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)new NodeType(NAME1, WORKSPACE2, new Properties())))));
    }

    @Test
    public void shouldNotBeEqualIfSameWorkspaceButDifferentName() {
        Assert.assertThat((Object)NODETYPE2, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)new NodeType(NAME2, WORKSPACE1, new Properties())))));
    }
}

