/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.XmlValueEncoder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StreamingContentHandler
extends DefaultHandler {
    private static final boolean LOG_TO_CONSOLE = false;
    private final TextEncoder VALUE_ENCODER = new XmlValueEncoder();
    private final Collection<String> unexportableNamespaces;
    private final OutputStream os;
    private final Map<String, String> mappedPrefixes;

    public StreamingContentHandler(OutputStream os) {
        this(os, Collections.emptyList());
    }

    public StreamingContentHandler(OutputStream os, Collection<String> unexportableNamespaces) {
        this.os = os;
        this.unexportableNamespaces = unexportableNamespaces;
        this.mappedPrefixes = new HashMap<String, String>();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.emit(this.VALUE_ENCODER.encode(new String(ch, start, length)));
    }

    @Override
    public void startDocument() throws SAXException {
        this.emit("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.emit("<");
        this.emit(name);
        for (Map.Entry<String, String> mapping : this.mappedPrefixes.entrySet()) {
            this.emit(" xmlns:");
            this.emit(mapping.getKey());
            this.emit("=\"");
            this.emit(mapping.getValue());
            this.emit("\"");
        }
        this.mappedPrefixes.clear();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.emit(" ");
                this.emit(attributes.getQName(i));
                this.emit("=\"");
                this.emit(this.VALUE_ENCODER.encode(attributes.getValue(i)));
                this.emit("\"");
            }
        }
        this.emit(">");
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.emit("</");
        this.emit(name);
        this.emit(">");
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (!this.unexportableNamespaces.contains(prefix)) {
            this.mappedPrefixes.put(prefix, uri);
        }
    }

    private void emit(String text) throws SAXException {
        try {
            this.os.write(text.getBytes());
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }
}

