/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client;

import net.jcip.annotations.Immutable;

@Immutable
public final class Status {
    public static final Status OK_STATUS = new Status(Severity.OK, null, null);
    private final Throwable exception;
    private final String message;
    private final Severity severity;

    public Status(Severity severity, String message, Throwable exception) {
        this.severity = severity == null ? Severity.UNKNOWN : severity;
        this.message = message;
        this.exception = exception;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getMessage() {
        return this.message == null ? "" : this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public boolean isError() {
        return this.severity == Severity.ERROR;
    }

    public boolean isInfo() {
        return this.severity == Severity.INFO;
    }

    public boolean isOk() {
        return this.severity == Severity.OK;
    }

    public boolean isUnknown() {
        return this.severity == Severity.UNKNOWN;
    }

    public boolean isWarning() {
        return this.severity == Severity.WARNING;
    }

    public String toString() {
        StringBuilder txt = new StringBuilder("Status ");
        txt.append(this.severity.toString()).append(": ");
        txt.append(this.getMessage().length() == 0 ? "<no message>" : this.getMessage());
        txt.append(" : ");
        txt.append(this.getException() == null ? "<no error>" : this.getException());
        return txt.toString();
    }

    public static enum Severity {
        ERROR,
        INFO,
        OK,
        UNKNOWN,
        WARNING;

    }
}

