/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.http;

import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.modeshape.web.jcr.rest.client.RestClientI18n;
import org.modeshape.web.jcr.rest.client.domain.Server;
import org.modeshape.web.jcr.rest.client.json.IJsonConstants;

public final class HttpClientConnection {
    private final AbstractHttpClient httpClient;
    private final HttpRequestBase request;
    private HttpResponse response;
    private String contentType;

    public HttpClientConnection(Server server, URL url, IJsonConstants.RequestMethod method) throws Exception {
        assert (server != null);
        assert (url != null);
        assert (method != null);
        this.httpClient = new DefaultHttpClient();
        this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)new UsernamePasswordCredentials(server.getUser(), server.getPassword()));
        if (IJsonConstants.RequestMethod.GET == method) {
            this.request = new HttpGet();
        } else if (IJsonConstants.RequestMethod.DELETE == method) {
            this.request = new HttpDelete();
        } else if (IJsonConstants.RequestMethod.POST == method) {
            this.request = new HttpPost();
        } else if (IJsonConstants.RequestMethod.PUT == method) {
            this.request = new HttpPut();
        } else {
            throw new RuntimeException(RestClientI18n.unknownHttpRequestMethodMsg.text(new Object[]{method}));
        }
        this.request.setURI(url.toURI());
    }

    public void disconnect() {
        this.httpClient.getConnectionManager().shutdown();
    }

    private HttpResponse getResponse() throws Exception {
        if (this.response == null) {
            this.response = this.httpClient.execute((HttpUriRequest)this.request);
        }
        return this.response;
    }

    public int getResponseCode() throws Exception {
        return this.getResponse().getStatusLine().getStatusCode();
    }

    public String read() throws Exception {
        return EntityUtils.toString((HttpEntity)this.getResponse().getEntity());
    }

    public void write(byte[] bytes) throws Exception {
        assert (bytes != null);
        ByteArrayEntity entity = new ByteArrayEntity(bytes);
        if (this.contentType == null) {
            entity.setContentType("application/json");
        }
        if (this.request instanceof HttpEntityEnclosingRequestBase) {
            ((HttpEntityEnclosingRequestBase)this.request).setEntity((HttpEntity)entity);
        }
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.request.setHeader("Content-Type", contentType);
    }
}

