/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Server;
import org.modeshape.web.jcr.rest.client.json.JsonNode;
import org.modeshape.web.jcr.rest.client.json.JsonUtils;

public final class ServerNode
extends JsonNode {
    private static final Logger LOGGER = Logger.getLogger(ServerNode.class);
    private final Server server;

    public ServerNode(Server server) {
        super(server.getName());
        this.server = server;
    }

    @Override
    public URL getUrl() throws Exception {
        StringBuilder url = new StringBuilder(this.server.getUrl());
        if (url.lastIndexOf("/") == url.length() - 1) {
            url.delete(url.length() - 1, url.length() - 1);
        }
        return new URL(url.toString());
    }

    public URL getFindRepositoriesUrl() throws Exception {
        return new URL(this.getUrl().toString() + '/');
    }

    public Collection<Repository> getRepositories(String jsonResponse) throws Exception {
        CheckArg.isNotNull((Object)jsonResponse, (String)"jsonResponse");
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        LOGGER.trace("getRepositories:jsonResponse={0}", new Object[]{jsonResponse});
        JSONObject jsonObj = new JSONObject(jsonResponse);
        Iterator itr = jsonObj.keys();
        while (itr.hasNext()) {
            JSONObject repo;
            String encodedName = (String)itr.next();
            String name = JsonUtils.decode(encodedName);
            HashMap<String, Object> meta = new HashMap<String, Object>();
            JSONObject named = (JSONObject)jsonObj.get(encodedName);
            if (named.has("repository") && (repo = (JSONObject)named.get("repository")).has("metadata")) {
                JSONObject metadata = (JSONObject)repo.get("metadata");
                Iterator keyIter = metadata.keys();
                while (keyIter.hasNext()) {
                    String key = (String)keyIter.next();
                    String[] values = metadata.get(key);
                    if (values instanceof JSONArray) {
                        JSONArray vals = (JSONArray)values;
                        String[] stringValues = new String[vals.length()];
                        for (int i = 0; i != vals.length(); ++i) {
                            stringValues[i] = vals.getString(i);
                        }
                        values = stringValues;
                    }
                    meta.put(key, values);
                }
                LOGGER.trace("getRepositories: found metadata {0}", new Object[]{meta});
            }
            Repository repository = new Repository(name, this.server, meta);
            repositories.add(repository);
            LOGGER.trace("getRepositories: adding repository={0}", new Object[]{repository});
        }
        return repositories;
    }
}

