/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.domain;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.IoUtil;
import org.modeshape.web.jcr.rest.client.domain.NodeType;
import org.modeshape.web.jcr.rest.client.domain.PropertyDefinition;

public class PropertyDefinitionTest {
    private String declaringNodeTypeName;
    private String name;
    private int requiredType;
    private boolean isAutoCreated;
    private boolean isMandatory;
    private boolean isProtected;
    private boolean isFullTextSearchable;
    private boolean isMultiple;
    private boolean isQueryOrderable;
    private int onParentVersion;
    private List<String> defaultValues;
    private List<String> valueConstraints;
    private List<String> availableQueryOperations;
    private Map<String, NodeType> nodeTypes;
    private PropertyDefinition defn;
    private PropertyDefinition defn2;

    @Before
    public void beforeEach() {
        this.declaringNodeTypeName = "my:nodeType";
        this.nodeTypes = new HashMap<String, NodeType>();
        this.name = "my:prop";
        this.requiredType = 4;
        this.isAutoCreated = true;
        this.isMandatory = true;
        this.isProtected = true;
        this.isFullTextSearchable = true;
        this.isMultiple = true;
        this.isQueryOrderable = true;
        this.onParentVersion = 1;
        this.defaultValues = new ArrayList<String>();
        this.valueConstraints = new ArrayList<String>();
        this.availableQueryOperations = new ArrayList<String>();
    }

    @Test
    public void shouldCreateInstance() {
        this.createPropertyDefinition();
    }

    @Test
    public void shouldCreateWithNullDefaultValueList() {
        this.defaultValues = null;
        this.createPropertyDefinition();
    }

    @Test
    public void shouldCreateWithEmptyDefaultValueList() {
        this.defaultValues.clear();
        this.createPropertyDefinition();
    }

    @Test
    public void shouldCreateWithOneDefaultValue() {
        this.defaultValues.add("3");
        this.createPropertyDefinition();
    }

    @Test
    public void shouldCreateWithTwoDefaultValues() {
        this.defaultValues.add("3");
        this.defaultValues.add("5");
        this.createPropertyDefinition();
    }

    @Test
    public void shouldCreateWithThreeDefaultValues() {
        this.defaultValues.add("3");
        this.defaultValues.add("5");
        this.defaultValues.add("8");
        this.createPropertyDefinition();
    }

    @Test
    public void shouldReturnNullDeclaringNodeTypeIfNotFoundInMap() {
        this.nodeTypes.clear();
        this.defn = this.createPropertyDefinition();
        Assert.assertThat((Object)this.defn.getDeclaringNodeType(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReturnNullDeclaringNodeTypeIfNoMapIsFound() {
        this.nodeTypes = null;
        this.defn = this.createPropertyDefinition();
        Assert.assertThat((Object)this.defn.getDeclaringNodeType(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualIfSameNameAndRequiredTypeAndMultiplicity() {
        this.defn = this.createPropertyDefinition();
        this.defn2 = this.createPropertyDefinition();
        Assert.assertThat((Object)this.defn.equals((Object)this.defn2), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderNotEqualIfDifferentName() {
        this.defn = this.createPropertyDefinition();
        this.name = "other:name";
        this.defn2 = this.createPropertyDefinition();
        Assert.assertThat((Object)this.defn.equals((Object)this.defn2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualIfDifferentRequiredType() {
        this.defn = this.createPropertyDefinition();
        this.requiredType = this.requiredType == 8 ? 6 : 8;
        this.defn2 = this.createPropertyDefinition();
        Assert.assertThat((Object)this.defn.equals((Object)this.defn2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualIfDifferentMultiplicity() {
        this.defn = this.createPropertyDefinition();
        this.isMultiple = !this.isMultiple;
        this.defn2 = this.createPropertyDefinition();
        Assert.assertThat((Object)this.defn.equals((Object)this.defn2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowConversionOfDefaultValueFromDateToCompatibleTypes() throws Exception {
        this.defaultValues.add("2010-03-22T01:02:03.456Z");
        this.requiredType = 5;
        this.defn = this.createPropertyDefinition();
        Assert.assertThat((Object)this.defn.getDefaultValues()[0].getString(), (Matcher)Is.is((Object)"2010-03-22T01:02:03.456Z"));
        Assert.assertThat((Object)this.defn.getDefaultValues()[0].getDate(), (Matcher)Is.is((Object)this.dateFrom("2010-03-22T01:02:03.456Z")));
        Assert.assertThat((Object)this.defn.getDefaultValues()[0].getLong(), (Matcher)Is.is((Object)1269219723456L));
    }

    @Test
    public void shouldAllowConversionOfDefaultValueFromDateBeforeUtcToCompatibleTypes() throws Exception {
        this.defaultValues.add("2010-03-22T01:02:03.456+08:00");
        this.requiredType = 5;
        this.defn = this.createPropertyDefinition();
        Assert.assertThat((Object)this.defn.getDefaultValues()[0].getString(), (Matcher)Is.is((Object)"2010-03-22T01:02:03.456+08:00"));
        Assert.assertThat((Object)this.defn.getDefaultValues()[0].getDate(), (Matcher)Is.is((Object)this.dateFrom("2010-03-22T01:02:03.456+08:00")));
        Assert.assertThat((Object)this.defn.getDefaultValues()[0].getLong(), (Matcher)Is.is((Object)1269190923456L));
        Assert.assertThat((Object)TimeUnit.HOURS.convert(28800000L, TimeUnit.MILLISECONDS), (Matcher)Is.is((Object)8L));
    }

    @Test
    public void shouldAllowConversionOfDefaultValueFromDateAfterUtcToCompatibleTypes() throws Exception {
        this.defaultValues.add("2010-03-22T01:02:03.456-08:00");
        this.requiredType = 5;
        this.defn = this.createPropertyDefinition();
        Assert.assertThat((Object)this.defn.getDefaultValues()[0].getString(), (Matcher)Is.is((Object)"2010-03-22T01:02:03.456-08:00"));
        Assert.assertThat((Object)this.defn.getDefaultValues()[0].getDate(), (Matcher)Is.is((Object)this.dateFrom("2010-03-22T01:02:03.456-08:00")));
        Assert.assertThat((Object)this.defn.getDefaultValues()[0].getLong(), (Matcher)Is.is((Object)1269248523456L));
        Assert.assertThat((Object)TimeUnit.HOURS.convert(-28800000L, TimeUnit.MILLISECONDS), (Matcher)Is.is((Object)-8L));
    }

    @Test
    public void shouldAllowConversionOfDefaultValueFromDoubleToCompatibleTypes() throws Exception {
        this.defaultValues.add("8");
        this.requiredType = 4;
        this.defn = this.createPropertyDefinition();
        Assert.assertThat((Object)this.defn.getDefaultValues()[0].getString(), (Matcher)Is.is((Object)"8"));
        Assert.assertThat((Object)this.defn.getDefaultValues()[0].getDouble(), (Matcher)Is.is((Object)8.0));
        Assert.assertThat((Object)this.defn.getDefaultValues()[0].getLong(), (Matcher)Is.is((Object)8L));
        Assert.assertThat((Object)this.defn.getDefaultValues()[0].getDecimal(), (Matcher)Is.is((Object)new BigDecimal(8)));
        Assert.assertThat((Object)this.toString(this.defn.getDefaultValues()[0].getBinary()), (Matcher)Is.is((Object)"8"));
        Assert.assertThat((Object)this.toString(this.defn.getDefaultValues()[0].getStream()), (Matcher)Is.is((Object)"8"));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldFailToConvertDefaultValueFromDoubleToBoolean() throws Exception {
        this.defaultValues.add("8");
        this.requiredType = 4;
        this.defn = this.createPropertyDefinition();
        this.defn.getDefaultValues()[0].getBoolean();
    }

    @Test
    public void shouldConvertDefaultValueFromDoubleToDate() throws Exception {
        this.defaultValues.add("8");
        this.requiredType = 4;
        this.defn = this.createPropertyDefinition();
        this.defn.getDefaultValues()[0].getDate();
    }

    @Test(expected=ValueFormatException.class)
    public void shouldConvertDefaultValueFromNameToDate() throws Exception {
        this.defaultValues.add("jcr:name");
        this.requiredType = 7;
        this.defn = this.createPropertyDefinition();
        this.defn.getDefaultValues()[0].getDate();
    }

    @Test
    public void shouldParseDate() {
        PropertyDefinition.parseDate((String)"2010-03-22T01:02:03.456-0800");
        PropertyDefinition.parseDate((String)"2010-03-22T01:02:03.456-08:00");
        PropertyDefinition.parseDate((String)"2010-03-22T01:02:03.456+0800");
        PropertyDefinition.parseDate((String)"2010-03-22T01:02:03.456+08:00");
        PropertyDefinition.parseDate((String)"2010-03-22T01:02:03.456Z");
    }

    protected Calendar dateFrom(String dateStr) {
        return PropertyDefinition.parseDate((String)dateStr);
    }

    protected String toString(Binary binary) throws IOException, RepositoryException {
        return this.toString(binary.getStream());
    }

    protected String toString(InputStream stream) throws IOException {
        return IoUtil.read((InputStream)stream);
    }

    protected PropertyDefinition createPropertyDefinition() {
        PropertyDefinition defn = new PropertyDefinition(this.declaringNodeTypeName, this.name, this.requiredType, this.isAutoCreated, this.isMandatory, this.isProtected, this.isFullTextSearchable, this.isMultiple, this.isQueryOrderable, this.onParentVersion, this.defaultValues, this.valueConstraints, this.availableQueryOperations, this.nodeTypes);
        this.assertValidDefinition(defn);
        return defn;
    }

    protected void assertValidDefinition(PropertyDefinition defn) {
        if (this.defaultValues == null) {
            this.defaultValues = new ArrayList<String>();
        }
        if (this.valueConstraints == null) {
            this.valueConstraints = new ArrayList<String>();
        }
        if (this.availableQueryOperations == null) {
            this.availableQueryOperations = new ArrayList<String>();
        }
        Assert.assertThat((Object)defn.isAutoCreated(), (Matcher)Is.is((Object)this.isAutoCreated));
        Assert.assertThat((Object)defn.isFullTextSearchable(), (Matcher)Is.is((Object)this.isFullTextSearchable));
        Assert.assertThat((Object)defn.isMandatory(), (Matcher)Is.is((Object)this.isMandatory));
        Assert.assertThat((Object)defn.isMultiple(), (Matcher)Is.is((Object)this.isMultiple));
        Assert.assertThat((Object)defn.isProtected(), (Matcher)Is.is((Object)this.isProtected));
        Assert.assertThat((Object)defn.isQueryOrderable(), (Matcher)Is.is((Object)this.isQueryOrderable));
        Assert.assertThat((Object)defn.getName(), (Matcher)Is.is((Object)this.name));
        Assert.assertThat((Object)defn.getDeclaringNodeTypeName(), (Matcher)Is.is((Object)this.declaringNodeTypeName));
        Assert.assertThat((Object)defn.getAvailableQueryOperators(), (Matcher)Is.is((Object)this.arrayOf(this.availableQueryOperations)));
        Assert.assertThat((Object)defn.getValueConstraints(), (Matcher)Is.is((Object)this.arrayOf(this.valueConstraints)));
        Assert.assertThat((Object)this.arrayOf(defn.getDefaultValues()), (Matcher)Is.is((Object)this.arrayOf(this.defaultValues)));
        Assert.assertThat((Object)defn.isAutoCreated(), (Matcher)Is.is((Object)this.isAutoCreated));
    }

    protected String[] arrayOf(Collection<String> values) {
        return values.toArray(new String[values.size()]);
    }

    protected String[] arrayOf(Value[] values) {
        String[] result = new String[values.length];
        try {
            for (int i = 0; i != values.length; ++i) {
                result[i] = values[i].getString();
            }
        }
        catch (RepositoryException e) {
            Assert.fail((String)e.getMessage());
        }
        return result;
    }
}

