/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SelfExpandingBufferredInputStream
extends BufferedInputStream {
    private static int defaultBufferSize = 8192;

    public SelfExpandingBufferredInputStream(InputStream in) {
        super(in);
        super.mark(defaultBufferSize);
    }

    public SelfExpandingBufferredInputStream(InputStream in, int size) {
        super(in, size);
        super.mark(size);
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("ExpandoBufferredInputStream is always marked at index 0.");
    }

    public synchronized int read() throws IOException {
        if (this.pos == this.marklimit) {
            this.expand();
        }
        return super.read();
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        while (this.pos + len > this.marklimit) {
            this.expand();
        }
        return super.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        while (this.pos + b.length > this.marklimit) {
            this.expand();
        }
        return super.read(b);
    }

    private void expand() throws IOException {
        int lastPos = this.pos;
        super.reset();
        super.mark(this.marklimit * 2);
        this.pos = lastPos;
    }

    public int getBufSize() {
        return this.buf.length;
    }

    public int getCount() {
        return this.count;
    }

    public int getPos() {
        return this.pos;
    }

    public int getMarkLimit() {
        return this.marklimit;
    }

    public int getMarkPos() {
        return this.markpos;
    }
}

