/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.nodetype.NodeType;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.web.jcr.rest.client.IRestClient;
import org.modeshape.web.jcr.rest.client.Status;
import org.modeshape.web.jcr.rest.client.domain.QueryRow;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Server;
import org.modeshape.web.jcr.rest.client.domain.Workspace;
import org.modeshape.web.jcr.rest.client.json.FileNode;
import org.modeshape.web.jcr.rest.client.json.JsonRestClient;

public final class JsonRestClientTest {
    private static final String PSWD = "password";
    private static final String USER = "dnauser";
    private static final Server SERVER = new Server("http://localhost:8090/resources/test", "dnauser", "password");
    private static final String REPOSITORY_NAME = "repo";
    private static final Repository REPOSITORY1 = new Repository("repo", SERVER);
    private static final String WORKSPACE_NAME = "default";
    private static final Workspace WORKSPACE1 = new Workspace("default", REPOSITORY1);
    private static final String WORKSPACE_PATH = "/myproject/myfolder/";
    private static final String FILE_PATH = "/myproject/myfolder/document.txt";
    private static final String BINARY_FILE_PATH = "/myproject/myfolder/picture.jpg";
    private static final String DDL_FILE_PATH = "/myproject/myfolder/oracle_test_create.ddl";
    private static final String BOOKS_MODEL_PATH = "/myproject/myfolder/Books_Oracle.xmi";
    private static final String BOOKS_MODEL_PATH2 = "/myproject/myfolder/Books_Oracle2.xmi";
    private static final String WORKSPACE_UNUSUALPATH = "/myproject/My.Test - Folder/";
    private static final String FILE_UNUSUALPATH = "/myproject/My.Test - Folder/Test File_.a-().txt";
    private IRestClient restClient;
    private File textfile = null;

    @Before
    public void beforeEach() {
        this.restClient = new JsonRestClient();
    }

    @Test
    public void shouldGetRepositories() throws Exception {
        Collection repositories = this.restClient.getRepositories(SERVER);
        Assert.assertThat((Object)repositories.size(), (Matcher)IsEqual.equalTo((Object)1));
        Repository repo = (Repository)repositories.iterator().next();
        Assert.assertThat((Object)repo, (Matcher)Is.is((Object)REPOSITORY1));
        if (!repo.getMetadata().isEmpty()) {
            Map metadata = repo.getMetadata();
            Assert.assertThat(metadata.get("jcr.specification.name"), (Matcher)Is.is((Object)"Content Repository for Java Technology API"));
            Assert.assertThat(metadata.get("jcr.specification.version"), (Matcher)Is.is((Object)"2.0"));
            Assert.assertThat(metadata.get("jcr.repository.name"), (Matcher)Is.is((Object)"ModeShape"));
            Assert.assertThat(metadata.get("jcr.repository.vendor.url"), (Matcher)Is.is((Object)"http://www.modeshape.org"));
            Assert.assertThat((Object)metadata.get("jcr.repository.version").toString().startsWith("3."), (Matcher)Is.is((Object)true));
            Assert.assertThat(metadata.get("option.versioning.supported"), (Matcher)Is.is((Object)"true"));
        }
    }

    @Ignore
    @Test
    public void shouldGetNodeTypes() throws Exception {
        Map nodeTypes = this.restClient.getNodeTypes(REPOSITORY1);
        for (NodeType nt : nodeTypes.values()) {
            System.out.println("NODETYPE: " + nt.getName());
            System.out.println("   declared supertypes:             " + nt.getSupertypes());
            System.out.println("   declared property definitions:   " + nt.getDeclaredPropertyDefinitions());
            System.out.println("   declared child node definitions: " + nt.getDeclaredPropertyDefinitions());
        }
    }

    @Test
    public void shouldGetWorkspaces() throws Exception {
        Collection workspaces = this.restClient.getWorkspaces(REPOSITORY1);
        Assert.assertThat((Object)workspaces.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(workspaces.iterator().next(), (Matcher)Is.is((Object)WORKSPACE1));
    }

    @Test
    public void shouldNotUnpublishNonexistentFile() throws Exception {
        File file = new File("bogusfile");
        Status status = this.restClient.unpublish(WORKSPACE1, WORKSPACE_PATH, file);
        this.printExceptionIfStatusIsError(status);
        Assert.assertThat((String)status.getMessage(), (Object)status.isInfo(), (Matcher)Is.is((Object)true));
    }

    private void printExceptionIfStatusIsError(Status status) {
        if (status.isError()) {
            System.err.println(status.getMessage());
            status.getException().printStackTrace(System.err);
        }
    }

    @Test
    public void shouldPublishBinaryResource() throws Exception {
        URL binaryFile = this.getClass().getResource(BINARY_FILE_PATH);
        Assert.assertThat((Object)binaryFile, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        File file = new File(binaryFile.toURI());
        Status status = this.restClient.publish(WORKSPACE1, WORKSPACE_PATH, file);
        this.printExceptionIfStatusIsError(status);
        Assert.assertThat((Object)status.isOk(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((JsonRestClient)this.restClient).pathExists(WORKSPACE1, WORKSPACE_PATH, file), (Matcher)Is.is((Object)true));
        String expected = new FileNode(WORKSPACE1, WORKSPACE_PATH, file).readFile();
        String actual = ((JsonRestClient)this.restClient).getFileContents(WORKSPACE1, WORKSPACE_PATH, file);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
        this.shouldUnpublishFile(file);
    }

    private void shouldPublishTextResource() throws Exception {
        URL textFile = this.getClass().getResource(FILE_PATH);
        Assert.assertThat((Object)textFile, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.textfile = new File(textFile.toURI());
        Status status = this.restClient.publish(WORKSPACE1, WORKSPACE_PATH, this.textfile);
        this.printExceptionIfStatusIsError(status);
        Assert.assertThat((String)status.getMessage(), (Object)status.isOk(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((JsonRestClient)this.restClient).pathExists(WORKSPACE1, WORKSPACE_PATH, this.textfile), (Matcher)Is.is((Object)true));
        String expected = new FileNode(WORKSPACE1, WORKSPACE_PATH, this.textfile).readFile();
        String actual = ((JsonRestClient)this.restClient).getFileContents(WORKSPACE1, WORKSPACE_PATH, this.textfile);
        if (!expected.equals(actual)) {
            System.err.println("\nvan2expected: \n" + expected);
            System.err.println("\nvan2actual: \n" + actual);
        }
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
    }

    @Test
    @FixFor(value={"MODE-919"})
    public void shouldPublishDdlResource() throws Exception {
        URL ddlFile = this.getClass().getResource(DDL_FILE_PATH);
        Assert.assertThat((Object)ddlFile, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        File file = new File(ddlFile.toURI());
        Status status = this.restClient.publish(WORKSPACE1, WORKSPACE_PATH, file);
        this.printExceptionIfStatusIsError(status);
        Assert.assertThat((String)status.getMessage(), (Object)status.isOk(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((JsonRestClient)this.restClient).pathExists(WORKSPACE1, WORKSPACE_PATH, file), (Matcher)Is.is((Object)true));
        String expected = new FileNode(WORKSPACE1, WORKSPACE_PATH, file).readFile();
        String actual = ((JsonRestClient)this.restClient).getFileContents(WORKSPACE1, WORKSPACE_PATH, file);
        if (!expected.equals(actual)) {
            System.err.println("van1expected: \n" + expected);
            System.err.println("\nvan1actual: \n" + actual);
        }
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
        this.shouldUnpublishFile(file);
    }

    @Test
    public void shouldPublishResourcesHavingNonLettersNonNumbersInName() throws Exception {
        URL textFile = this.getClass().getResource(FILE_UNUSUALPATH);
        Assert.assertThat((Object)textFile, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        File file = new File(textFile.toURI());
        Status status = this.restClient.publish(WORKSPACE1, WORKSPACE_UNUSUALPATH, file);
        this.printExceptionIfStatusIsError(status);
        Assert.assertThat((String)status.getMessage(), (Object)status.isOk(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((JsonRestClient)this.restClient).pathExists(WORKSPACE1, WORKSPACE_UNUSUALPATH, file), (Matcher)Is.is((Object)true));
        this.shouldUnpublishFile(file);
    }

    @Test
    public void shouldUnpublish() throws Exception {
        this.shouldPublishTextResource();
        Status status = this.restClient.unpublish(WORKSPACE1, WORKSPACE_PATH, this.textfile);
        this.printExceptionIfStatusIsError(status);
        Assert.assertThat((Object)status.isOk(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((JsonRestClient)this.restClient).pathExists(WORKSPACE1, WORKSPACE_PATH, this.textfile), (Matcher)Is.is((Object)false));
    }

    protected void shouldUnpublishFile(File file) throws Exception {
        Status status = this.restClient.unpublish(WORKSPACE1, WORKSPACE_PATH, file);
        this.printExceptionIfStatusIsError(status);
        Assert.assertThat((Object)((JsonRestClient)this.restClient).pathExists(WORKSPACE1, WORKSPACE_PATH, file), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldQuery() throws Exception {
        this.shouldPublishTextResource();
        List results = this.restClient.query(WORKSPACE1, "xpath", "//myproject/myfolder/document.txt");
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)1));
        QueryRow row = (QueryRow)results.get(0);
        Assert.assertThat((Object)row.getColumnNames().size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)row.getColumnNames().contains("jcr:score"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)row.getColumnNames().contains("jcr:path"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)row.getColumnNames().contains("jcr:primaryType"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)row.getColumnType("jcr:score"), (Matcher)Is.is((Object)"DOUBLE"));
        Assert.assertThat((Object)row.getColumnType("jcr:path"), (Matcher)Is.is((Object)"STRING"));
        Assert.assertThat((Object)row.getColumnType("jcr:primaryType"), (Matcher)Is.is((Object)"STRING"));
        Assert.assertThat((Object)((String)row.getValue("jcr:path")), (Matcher)Is.is((Object)FILE_PATH));
        Assert.assertThat((Object)((String)row.getValue("jcr:primaryType")), (Matcher)Is.is((Object)"nt:file"));
        this.shouldUnpublishFile(this.textfile);
    }

    @Test
    @FixFor(value={"MODE-1130"})
    public void shouldPublishNonVersionableResourceMultipleTimes() throws Exception {
        URL modelFile = this.getClass().getResource(BOOKS_MODEL_PATH);
        Assert.assertThat((Object)modelFile, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        File file = new File(modelFile.toURI());
        Status status = this.restClient.publish(WORKSPACE1, WORKSPACE_PATH, file, false);
        Assert.assertThat((String)status.getMessage(), (Object)status.isOk(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((JsonRestClient)this.restClient).pathExists(WORKSPACE1, WORKSPACE_PATH, file), (Matcher)Is.is((Object)true));
        String expected = new FileNode(WORKSPACE1, WORKSPACE_PATH, file).readFile();
        String actual = ((JsonRestClient)this.restClient).getFileContents(WORKSPACE1, WORKSPACE_PATH, file);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
        status = this.restClient.publish(WORKSPACE1, WORKSPACE_PATH, file, false);
        Assert.assertThat((String)status.getMessage(), (Object)status.isOk(), (Matcher)Is.is((Object)true));
        this.shouldUnpublishFile(file);
    }

    @Test
    @FixFor(value={"MODE-1130"})
    public void shouldPublishMVersionableResourceMultipleTimes() throws Exception {
        URL modelFile = this.getClass().getResource(BOOKS_MODEL_PATH2);
        Assert.assertThat((Object)modelFile, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        File file = new File(modelFile.toURI());
        Status status = this.restClient.publish(WORKSPACE1, WORKSPACE_PATH, file, true);
        if (!status.isOk()) {
            System.out.println(status + "\n");
            status.getException().printStackTrace();
        }
        Assert.assertThat((String)status.getMessage(), (Object)status.isOk(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((JsonRestClient)this.restClient).pathExists(WORKSPACE1, WORKSPACE_PATH, file), (Matcher)Is.is((Object)true));
        String expected = new FileNode(WORKSPACE1, WORKSPACE_PATH, file).readFile();
        String actual = ((JsonRestClient)this.restClient).getFileContents(WORKSPACE1, WORKSPACE_PATH, file);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
        status = this.restClient.publish(WORKSPACE1, WORKSPACE_PATH, file, true);
        if (!status.isOk()) {
            System.out.println(status + "\n");
            status.getException().printStackTrace();
        }
        Assert.assertThat((String)status.getMessage(), (Object)status.isOk(), (Matcher)Is.is((Object)true));
        this.shouldUnpublishFile(file);
    }

    @Test
    @FixFor(value={"MODE-1131"})
    public void shouldQueryAndNotFailWhenNullValueAppearsInResultSet() throws Exception {
        this.shouldPublishTextResource();
        String path = WORKSPACE_PATH.substring(0, WORKSPACE_PATH.lastIndexOf("/"));
        String query = "SELECT [jcr:primaryType], [jcr:path], [jcr:title] FROM [nt:folder] WHERE [jcr:path] = '" + path + "'";
        List results = this.restClient.query(WORKSPACE1, "JCR-SQL2", query);
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)1));
        QueryRow row = (QueryRow)results.get(0);
        Assert.assertThat((Object)row.getColumnNames().size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)row.getColumnNames().contains("jcr:path"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)row.getColumnNames().contains("jcr:primaryType"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)row.getColumnNames().contains("jcr:title"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)row.getColumnType("jcr:path"), (Matcher)Is.is((Object)"STRING"));
        Assert.assertThat((Object)row.getColumnType("jcr:primaryType"), (Matcher)Is.is((Object)"STRING"));
        Assert.assertThat((Object)row.getColumnType("jcr:title"), (Matcher)Is.is((Object)"STRING"));
        Assert.assertThat((Object)((String)row.getValue("jcr:path")), (Matcher)Is.is((Object)path));
        Assert.assertThat((Object)((String)row.getValue("jcr:primaryType")), (Matcher)Is.is((Object)"nt:folder"));
        Assert.assertThat((Object)row.getValue("jcr:title"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.shouldUnpublishFile(this.textfile);
    }
}

