/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.modeshape.common.util.CheckArg;

public final class JsonUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static String decode(String text) throws UnsupportedEncodingException {
        CheckArg.isNotNull((Object)text, (String)"text");
        return URLDecoder.decode(text, DEFAULT_CHARSET);
    }

    public static String encode(String text) throws UnsupportedEncodingException {
        CheckArg.isNotNull((Object)text, (String)"text");
        StringBuilder encoded = new StringBuilder();
        for (char c : text.toCharArray()) {
            encoded.append(c == '/' ? Character.valueOf(c) : URLEncoder.encode(Character.toString(c), DEFAULT_CHARSET));
        }
        return encoded.toString();
    }

    private JsonUtils() {
    }
}

