/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.domain;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.version.OnParentVersionAction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.web.jcr.rest.client.RestClientI18n;
import org.modeshape.web.jcr.rest.client.domain.ItemDefinition;
import org.modeshape.web.jcr.rest.client.domain.NodeType;

@Immutable
public class PropertyDefinition
extends ItemDefinition
implements javax.jcr.nodetype.PropertyDefinition {
    private final Id id;
    private final List<String> queryOps;
    private final List<String> defaultValues;
    private final List<String> valueConstraints;
    private final boolean isFullTextSearchable;
    private final boolean isQueryOrderable;

    public static Calendar parseDate(String dateString) throws IllegalArgumentException {
        DateTime result = new DateTime((Object)dateString);
        return result.toCalendar(null);
    }

    public PropertyDefinition(String declaringNodeTypeName, String name, int requiredType, boolean isAutoCreated, boolean isMandatory, boolean isProtected, boolean isFullTextSearchable, boolean isMultiple, boolean isQueryOrderable, int onParentVersion, List<String> defaultValues, List<String> valueConstraints, List<String> availableQueryOperations, Map<String, NodeType> nodeTypes) {
        super(declaringNodeTypeName, isAutoCreated, isMandatory, isProtected, onParentVersion, nodeTypes);
        this.id = new Id(name, isMultiple, requiredType);
        this.isFullTextSearchable = isFullTextSearchable;
        this.isQueryOrderable = isQueryOrderable;
        this.defaultValues = defaultValues != null ? defaultValues : Collections.emptyList();
        this.valueConstraints = valueConstraints != null ? valueConstraints : Collections.emptyList();
        this.queryOps = availableQueryOperations != null ? availableQueryOperations : Collections.emptyList();
    }

    protected Id id() {
        return this.id;
    }

    public String getName() {
        return this.id.name;
    }

    public String[] getAvailableQueryOperators() {
        return PropertyDefinition.toArray(this.queryOps);
    }

    public Value[] getDefaultValues() {
        if (this.defaultValues == null || this.defaultValues.isEmpty()) {
            return new Value[0];
        }
        int numValues = this.defaultValues.size();
        int i = 0;
        Value[] result = new Value[numValues];
        for (String value : this.defaultValues) {
            result[i++] = new StringValue(value);
        }
        return result;
    }

    public int getRequiredType() {
        return this.id.requiredType;
    }

    public String[] getValueConstraints() {
        return PropertyDefinition.toArray(this.valueConstraints);
    }

    public boolean isFullTextSearchable() {
        return this.isFullTextSearchable;
    }

    public boolean isMultiple() {
        return this.id.isMultiple;
    }

    public boolean isQueryOrderable() {
        return this.isQueryOrderable;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertyDefinition) {
            PropertyDefinition that = (PropertyDefinition)obj;
            return this.id.equals(that.id);
        }
        return false;
    }

    public String toString() {
        boolean first;
        StringBuilder sb = new StringBuilder();
        sb.append(" - ");
        sb.append(this.id.name);
        sb.append(" (");
        sb.append(PropertyType.nameFromValue((int)this.id.requiredType));
        sb.append(')');
        if (this.getDefaultValues().length != 0) {
            sb.append(" = ");
            first = true;
            for (Value value : this.getDefaultValues()) {
                if (value == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(value);
            }
        }
        if (this.isAutoCreated()) {
            sb.append(" autocreated");
        }
        if (this.isMandatory()) {
            sb.append(" mandatory");
        }
        if (!this.isFullTextSearchable()) {
            sb.append(" nofulltext");
        }
        if (!this.isQueryOrderable()) {
            sb.append(" noqueryorder");
        }
        if (this.isMultiple()) {
            sb.append(" multiple");
        }
        if (this.isProtected()) {
            sb.append(" protected");
        }
        sb.append(' ').append(OnParentVersionAction.nameFromValue((int)this.getOnParentVersion()));
        if (this.getAvailableQueryOperators().length != 0) {
            sb.append(" queryops ");
            first = true;
            for (String string : this.getAvailableQueryOperators()) {
                if (string == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append('\'');
                sb.append(string);
                sb.append('\'');
            }
        }
        if (this.getValueConstraints().length != 0) {
            sb.append(" < ");
            first = true;
            for (String string : this.getValueConstraints()) {
                if (string == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(string);
            }
        }
        return sb.toString();
    }

    protected static class Id {
        protected final String name;
        protected final boolean isMultiple;
        protected final int requiredType;

        protected Id(String name, boolean isMultiple, int requiredType) {
            this.name = name;
            this.isMultiple = isMultiple;
            this.requiredType = requiredType;
            assert (this.name != null);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Id) {
                Id that = (Id)obj;
                if (this.isMultiple != that.isMultiple) {
                    return false;
                }
                if (this.requiredType != that.requiredType) {
                    return false;
                }
                return this.name.equals(that.name);
            }
            return false;
        }

        public String toString() {
            return this.name + "(" + PropertyType.nameFromValue((int)this.requiredType) + ")" + (this.isMultiple ? (char)'*' : '1');
        }
    }

    protected class StringValue
    implements Value {
        private final String value;

        protected StringValue(String value) {
            this.value = value;
            assert (this.value != null);
        }

        public boolean getBoolean() throws ValueFormatException, RepositoryException {
            if (this.value.equals(Boolean.TRUE.toString())) {
                return true;
            }
            if (this.value.equals(Boolean.FALSE.toString())) {
                return true;
            }
            String lower = this.value.toLowerCase();
            if (lower.equals(Boolean.TRUE.toString())) {
                return true;
            }
            if (lower.equals(Boolean.FALSE.toString())) {
                return true;
            }
            throw new ValueFormatException();
        }

        public Calendar getDate() throws ValueFormatException, RepositoryException {
            try {
                return PropertyDefinition.parseDate(this.value);
            }
            catch (IllegalArgumentException e) {
                String from = PropertyType.nameFromValue((int)this.getType());
                String to = PropertyType.nameFromValue((int)3);
                throw new ValueFormatException(RestClientI18n.unableToConvertValue.text(new Object[]{this.value, from, to}), (Throwable)e);
            }
        }

        public Calendar getDateInUtc() throws ValueFormatException, RepositoryException {
            try {
                DateTime result = new DateTime((Object)this.value);
                DateTimeZone utc = DateTimeZone.forID((String)"UTC");
                if (!result.getZone().equals((Object)utc)) {
                    result = result.withZone(utc);
                }
                return result.toCalendar(null);
            }
            catch (IllegalArgumentException e) {
                String from = PropertyType.nameFromValue((int)this.getType());
                String to = PropertyType.nameFromValue((int)3);
                throw new ValueFormatException(RestClientI18n.unableToConvertValue.text(new Object[]{this.value, from, to}), (Throwable)e);
            }
        }

        public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
            try {
                if (PropertyDefinition.this.getRequiredType() == 5) {
                    return new BigDecimal(this.getDateInUtc().getTime().getTime());
                }
                return new BigDecimal(this.value);
            }
            catch (NumberFormatException t) {
                String from = PropertyType.nameFromValue((int)this.getType());
                String to = PropertyType.nameFromValue((int)12);
                throw new ValueFormatException(RestClientI18n.unableToConvertValue.text(new Object[]{this.value, from, to}), (Throwable)t);
            }
        }

        public double getDouble() throws ValueFormatException, RepositoryException {
            try {
                if (PropertyDefinition.this.getRequiredType() == 5) {
                    return this.getDateInUtc().getTime().getTime();
                }
                return Double.parseDouble(this.value);
            }
            catch (NumberFormatException t) {
                String from = PropertyType.nameFromValue((int)this.getType());
                String to = PropertyType.nameFromValue((int)4);
                throw new ValueFormatException(RestClientI18n.unableToConvertValue.text(new Object[]{this.value, from, to}), (Throwable)t);
            }
        }

        public long getLong() throws ValueFormatException, RepositoryException {
            try {
                if (PropertyDefinition.this.getRequiredType() == 5) {
                    return this.getDateInUtc().getTime().getTime();
                }
                return Long.parseLong(this.value);
            }
            catch (NumberFormatException t) {
                String from = PropertyType.nameFromValue((int)this.getType());
                String to = PropertyType.nameFromValue((int)3);
                throw new ValueFormatException(RestClientI18n.unableToConvertValue.text(new Object[]{this.value, from, to}), (Throwable)t);
            }
        }

        public InputStream getStream() throws RepositoryException {
            return this.getBinary().getStream();
        }

        public String getString() {
            return this.value;
        }

        public int getType() {
            int type = PropertyDefinition.this.getRequiredType();
            return type == 0 ? 1 : type;
        }

        public Binary getBinary() {
            final byte[] bytes = this.value.getBytes();
            return new Binary(){

                public void dispose() {
                }

                public long getSize() {
                    return bytes.length;
                }

                public InputStream getStream() {
                    return new ByteArrayInputStream(bytes);
                }

                public int read(byte[] b, long position) throws IOException {
                    if (this.getSize() <= position) {
                        return -1;
                    }
                    InputStream stream = null;
                    IOException error = null;
                    try {
                        long skipped;
                        stream = this.getStream();
                        for (long skip = position; skip > 0L; skip -= skipped) {
                            skipped = stream.skip(skip);
                            if (skipped > 0L) continue;
                            int n = -1;
                            return n;
                        }
                        int n = stream.read(b);
                        return n;
                    }
                    catch (IOException e) {
                        error = e;
                        throw e;
                    }
                    finally {
                        block19: {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (RuntimeException t) {
                                    if (error == null) {
                                        throw t;
                                    }
                                }
                                catch (IOException t) {
                                    if (error != null) break block19;
                                    throw t;
                                }
                            }
                        }
                    }
                }
            };
        }

        public String toString() {
            return this.value;
        }
    }
}

