/*
 * Decompiled with CFR 0.152.
 */
package org.scannotation;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class ClasspathUrlFinder {
    public static URL[] findResourceBases(String baseResource, ClassLoader loader) {
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> urls = loader.getResources(baseResource);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                list.add(ClasspathUrlFinder.findResourceBase(url, baseResource));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list.toArray(new URL[list.size()]);
    }

    public static URL[] findResourceBases(String baseResource) {
        return ClasspathUrlFinder.findResourceBases(baseResource, Thread.currentThread().getContextClassLoader());
    }

    private static URL findResourceBase(URL url, String baseResource) {
        String urlString = url.toString();
        int idx = urlString.lastIndexOf(baseResource);
        urlString = urlString.substring(0, idx);
        URL deployUrl = null;
        try {
            deployUrl = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return deployUrl;
    }

    public static URL findResourceBase(String baseResource) {
        return ClasspathUrlFinder.findResourceBase(baseResource, Thread.currentThread().getContextClassLoader());
    }

    public static URL findResourceBase(String baseResource, ClassLoader loader) {
        URL url = loader.getResource(baseResource);
        return ClasspathUrlFinder.findResourceBase(url, baseResource);
    }

    public static URL findClassBase(Class clazz) {
        String resource = clazz.getName().replace('.', '/') + ".class";
        return ClasspathUrlFinder.findResourceBase(resource, clazz.getClassLoader());
    }

    public static URL[] findClassPaths() {
        ArrayList<URL> list = new ArrayList<URL>();
        String classpath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            File fp = new File(path);
            if (!fp.exists()) {
                throw new RuntimeException("File in java.class.path does not exist: " + fp);
            }
            try {
                list.add(fp.toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    public static URL[] findClassPaths(String ... paths) {
        ArrayList<URL> list = new ArrayList<URL>();
        String classpath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = paths[i].trim();
        }
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken().trim();
            boolean found = false;
            for (String wantedPath : paths) {
                if (!path.endsWith(File.separator + wantedPath)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            File fp = new File(path);
            if (!fp.exists()) {
                throw new RuntimeException("File in java.class.path does not exists: " + fp);
            }
            try {
                list.add(fp.toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return list.toArray(new URL[list.size()]);
    }
}

