/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.domain;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Server;

public final class RepositoryTest {
    private static final String NAME1 = "name1";
    private static final String NAME2 = "name2";
    private static final Server SERVER1 = new Server("file:/tmp/temp.txt/resources", "user", "pswd");
    private static final Server SERVER2 = new Server("http:www.redhat.com/resources", "user", "pswd");
    private static final Repository REPOSITORY1 = new Repository("name1", SERVER1);

    @Test
    public void shouldBeEqualIfHavingSameProperies() {
        Assert.assertThat((Object)REPOSITORY1, (Matcher)IsEqual.equalTo((Object)new Repository(REPOSITORY1.getName(), REPOSITORY1.getServer())));
    }

    @Test
    public void shouldHashToSameValueIfEquals() {
        HashSet<Repository> set = new HashSet<Repository>();
        set.add(REPOSITORY1);
        set.add(new Repository(REPOSITORY1.getName(), REPOSITORY1.getServer()));
        Assert.assertThat((Object)set.size(), (Matcher)IsEqual.equalTo((Object)1));
    }

    @Test(expected=AssertionError.class)
    public void shouldNotAllowNullName() {
        new Repository(null, SERVER1);
    }

    @Test(expected=AssertionError.class)
    public void shouldNotAllowNullServer() {
        new Repository(NAME1, null);
    }

    @Test
    public void shouldNotBeEqualIfSameNameButDifferentServers() {
        Assert.assertThat((Object)REPOSITORY1, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)new Repository(REPOSITORY1.getName(), SERVER2)))));
    }

    @Test
    public void shouldNotBeEqualIfSameServerButDifferentName() {
        Assert.assertThat((Object)REPOSITORY1, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)new Repository(NAME2, REPOSITORY1.getServer())))));
    }
}

