/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashSet;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.Base64;
import org.modeshape.jcr.JcrI18n;

public class JcrResourcesTest {
    private static final String REPOSITORY_NAME = "repo";
    private static final String SERVER_CONTEXT = "/resources/test";
    private static final String SERVER_URL = "http://localhost:8090/resources/test";

    @Before
    public void beforeEach() {
        String login = "dnauser";
        String password = "password";
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("dnauser", "password".toCharArray());
            }
        });
    }

    private String getResponseFor(HttpURLConnection connection) throws IOException {
        int bytesRead;
        StringBuffer buff = new StringBuffer();
        InputStream stream = connection.getInputStream();
        byte[] bytes = new byte[1024];
        while (-1 != (bytesRead = stream.read(bytes, 0, 1024))) {
            buff.append(new String(bytes, 0, bytesRead));
        }
        return buff.toString();
    }

    @Test
    public void shouldNotServeContentToUnauthorizedUser() throws Exception {
        String login = "dnauser";
        String password = "invalidpassword";
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("dnauser", "invalidpassword".toCharArray());
            }
        });
        URL postUrl = new URL("http://localhost:8090/resources/test/");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)401));
        connection.disconnect();
    }

    @Test
    public void shouldNotServeContentToUserWithoutConnectRole() throws Exception {
        String login = "unauthorizeduser";
        String password = "password";
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("unauthorizeduser", "password".toCharArray());
            }
        });
        URL postUrl = new URL("http://localhost:8090/resources/test/");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)401));
        connection.disconnect();
    }

    @Test
    public void shouldServeContentAtRoot() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        String body = this.getResponseFor(connection);
        JSONObject objFromResponse = new JSONObject(body);
        JSONObject modeRepository = (JSONObject)objFromResponse.get(REPOSITORY_NAME);
        JSONObject repository = (JSONObject)modeRepository.get("repository");
        JSONObject metadata = (JSONObject)repository.get("metadata");
        JSONObject expected = new JSONObject("{\"repo\":{\"repository\":{\"name\":\"repo\",\"resources\":{\"workspaces\":\"/resources/test/repo\"}}}}");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        if (metadata != null) {
            ((JSONObject)((JSONObject)expected.get(REPOSITORY_NAME)).get("repository")).put("metadata", (Object)metadata);
        }
        Assert.assertThat((Object)objFromResponse.toString(), (Matcher)Is.is((Object)expected.toString()));
        if (metadata != null) {
            Assert.assertThat((Object)metadata.get("jcr.specification.name"), (Matcher)Is.is((Object)JcrI18n.SPEC_NAME_DESC.text(new Object[0])));
            Assert.assertThat((Object)metadata.get("jcr.specification.version"), (Matcher)Is.is((Object)"2.0"));
            Assert.assertThat((Object)metadata.get("jcr.repository.name"), (Matcher)Is.is((Object)"ModeShape"));
            Assert.assertThat((Object)metadata.get("jcr.repository.vendor.url"), (Matcher)Is.is((Object)"http://www.modeshape.org"));
            Assert.assertThat((Object)metadata.get("jcr.repository.version").toString().startsWith("3."), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)metadata.get("option.versioning.supported"), (Matcher)Is.is((Object)"true"));
        }
        connection.disconnect();
    }

    @Test
    public void shouldServeListOfWorkspacesForValidRepository() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        String body = this.getResponseFor(connection);
        JSONObject objFromResponse = new JSONObject(body);
        JSONObject expected = new JSONObject("{\"default\":{\"workspace\":{\"name\":\"default\",\"resources\":{\"query\":\"/resources/test/repo/default/query\",\"items\":\"/resources/test/repo/default/items\"}}}}");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        Assert.assertThat((Object)objFromResponse.toString(), (Matcher)Is.is((Object)expected.toString()));
        connection.disconnect();
    }

    @Test
    public void shouldReturnErrorForInvalidWorkspace() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/XXX");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        if (connection.getResponseCode() != 404) {
            Assert.fail((String)connection.getResponseMessage());
        }
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldRetrieveRootNodeForValidRepository() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)2));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"mode:root"));
        Assert.assertThat((Object)properties.get("jcr:uuid"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        JSONArray children = body.getJSONArray("children");
        Assert.assertThat((Object)children.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)children.getString(0), (Matcher)Is.is((Object)"jcr:system"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldRetrieveRootNodeAndChildrenWhenDepthSet() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items?mode:depth=1");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)2));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"mode:root"));
        Assert.assertThat((Object)properties.get("jcr:uuid"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        JSONObject children = body.getJSONObject("children");
        Assert.assertThat((Object)children.length(), (Matcher)Is.is((Object)1));
        JSONObject system = children.getJSONObject("jcr:system");
        Assert.assertThat((Object)system.length(), (Matcher)Is.is((Object)2));
        properties = system.getJSONObject("properties");
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"mode:system"));
        JSONArray namespaces = system.getJSONArray("children");
        Assert.assertThat((Object)namespaces.length(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)namespaces.getString(0), (Matcher)Is.is((Object)"jcr:nodeTypes"));
        Assert.assertThat((Object)namespaces.getString(1), (Matcher)Is.is((Object)"jcr:versionStorage"));
        Assert.assertThat((Object)namespaces.getString(2), (Matcher)Is.is((Object)"mode:namespaces"));
        Assert.assertThat((Object)namespaces.getString(3), (Matcher)Is.is((Object)"mode:locks"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldRetrieveNodeAndChildrenWhenDepthSet() throws Exception {
        int i;
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/jcr:system?mode:depth=1");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)2));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"mode:system"));
        JSONObject children = body.getJSONObject("children");
        Assert.assertThat((Object)children.length(), (Matcher)Is.is((Object)4));
        JSONObject namespaces = children.getJSONObject("mode:namespaces");
        Assert.assertThat((Object)namespaces.length(), (Matcher)Is.is((Object)2));
        JSONObject locks = children.getJSONObject("mode:locks");
        Assert.assertThat((Object)locks.length(), (Matcher)Is.is((Object)1));
        JSONObject versionStorage = children.getJSONObject("jcr:versionStorage");
        Assert.assertThat((Object)versionStorage.length(), (Matcher)Is.is((Object)1));
        properties = namespaces.getJSONObject("properties");
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"mode:namespaces"));
        JSONArray namespace = namespaces.getJSONArray("children");
        String[] expectedNamespaces = new String[]{"mode", "jcr", "nt", "mix", "sv", "xml", "xmlns", "xsi", "xs"};
        Assert.assertThat((Object)namespace.length(), (Matcher)Is.is((Object)expectedNamespaces.length));
        HashSet<String> prefixes = new HashSet<String>(namespace.length());
        for (i = 0; i < namespace.length(); ++i) {
            prefixes.add(namespace.getString(i));
        }
        for (i = 0; i < expectedNamespaces.length; ++i) {
            Assert.assertTrue((boolean)prefixes.contains(expectedNamespaces[i]));
        }
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldRetrieveNodeTypeFromJcrSystemBranchIncludingSameNameSiblingChildren() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/jcr:system/jcr:nodeTypes/nt:base");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        connection.disconnect();
        JSONArray children = body.getJSONArray("children");
        Assert.assertThat((Object)children.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)children.getString(0), (Matcher)Is.is((Object)"jcr:primaryType"));
        Assert.assertThat((Object)children.getString(1), (Matcher)Is.is((Object)"jcr:mixinTypes"));
    }

    @Test
    public void shouldRetrieveNodeTypeSubgraphFromJcrSystemBranchIncludingSameNameSiblingChildren() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/jcr:system/jcr:nodeTypes/nt:base?mode:depth=4");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        connection.disconnect();
        JSONObject children = body.getJSONObject("children");
        JSONObject propDefn1 = children.getJSONObject("jcr:primaryType");
        JSONObject propDefn2 = children.getJSONObject("jcr:mixinTypes");
        Assert.assertThat((Object)propDefn1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)propDefn2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldNotRetrieveNonExistentNode() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/foo");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldNotRetrieveNonExistentProperty() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/jcr:system/foobar");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldRetrieveProperty() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/jcr:system/jcr:primaryType");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        String body = this.getResponseFor(connection);
        Assert.assertThat((Object)body, (Matcher)Is.is((Object)"{\"jcr:primaryType\":\"mode:system\"}"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldPostNodeToValidPathWithPrimaryType() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nodeA");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"testValue"));
        Assert.assertThat((Object)properties.get("multiValuedProperty"), (Matcher)IsInstanceOf.instanceOf(JSONArray.class));
        JSONArray values = properties.getJSONArray("multiValuedProperty");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)values.getString(1), (Matcher)Is.is((Object)"value2"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
    }

    @Test
    public void shouldPostNodeToValidPathWithoutPrimaryType() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/noPrimaryType");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
    }

    @Test
    public void shouldPostNodeToValidPathWithMixinTypes() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/withMixinType");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:mixinTypes\": \"mix:referenceable\"}}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("jcr:uuid"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        JSONArray values = properties.getJSONArray("jcr:mixinTypes");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"mix:referenceable"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/withMixinType");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("jcr:uuid"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        values = properties.getJSONArray("jcr:mixinTypes");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"mix:referenceable"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldNotPostNodeAtInvalidParentPath() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/foo/bar");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldNotPostNodeWithInvalidPrimaryType() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/invalidPrimaryType");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"invalidType\", \"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)400));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/invalidPrimaryType");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldPostNodeHierarchy() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nestedPost");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}, \"children\": { \"childNode\" : { \"properties\": {\"nestedProperty\": \"nestedValue\"}}}}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nestedPost?mode:depth=1");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)2));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"testValue"));
        Assert.assertThat((Object)properties.get("multiValuedProperty"), (Matcher)IsInstanceOf.instanceOf(JSONArray.class));
        JSONArray values = properties.getJSONArray("multiValuedProperty");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)values.getString(1), (Matcher)Is.is((Object)"value2"));
        JSONObject children = body.getJSONObject("children");
        Assert.assertThat((Object)children, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)children.length(), (Matcher)Is.is((Object)1));
        JSONObject child = children.getJSONObject("childNode");
        Assert.assertThat((Object)child, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)child.length(), (Matcher)Is.is((Object)1));
        properties = child.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("nestedProperty"), (Matcher)Is.is((Object)"nestedValue"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldFailWholeTransactionIfOneNodeIsBad() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/invalidNestedPost");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}, \"children\": { \"childNode\" : { \"properties\": {\"jcr:primaryType\": \"invalidType\"}}}}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)400));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/invalidNestedPost?mode:depth=1");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldNotDeleteNonExistentItem() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/invalidItemForDelete");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldDeleteExtantNode() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nodeForDeletion");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"testValue"));
        Assert.assertThat((Object)properties.get("multiValuedProperty"), (Matcher)IsInstanceOf.instanceOf(JSONArray.class));
        JSONArray values = properties.getJSONArray("multiValuedProperty");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)values.getString(1), (Matcher)Is.is((Object)"value2"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nodeForDeletion");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nodeForDeletion");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)204));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nodeForDeletion");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldDeleteExtantProperty() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/propertyForDeletion");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/propertyForDeletion");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"testValue"));
        Assert.assertThat((Object)properties.get("multiValuedProperty"), (Matcher)IsInstanceOf.instanceOf(JSONArray.class));
        JSONArray values = properties.getJSONArray("multiValuedProperty");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)values.getString(1), (Matcher)Is.is((Object)"value2"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/propertyForDeletion/multiValuedProperty");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("Content-Type", "application/json");
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)204));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/propertyForDeletion");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"testValue"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldNotBeAbleToPutAtInvalidPath() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nonexistantNode");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"firstProperty\": \"someValue\" }";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)404));
        connection.disconnect();
    }

    @Test
    public void shouldBeAbleToPutValueToProperty() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nodeForPutProperty");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty\": \"testValue\" }}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nodeForPutProperty/testProperty");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        payload = "{\"testProperty\":\"someOtherValue\"}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"someOtherValue"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldBeAbleToPutBinaryValueToProperty() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nodeForPutBinaryProperty");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String encodedValue = Base64.encodeBytes((byte[])"propertyValue".getBytes("UTF-8"));
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"testProperty/base64/\": \"" + encodedValue + "\" }}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        URL putUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nodeForPutBinaryProperty/testProperty");
        connection = (HttpURLConnection)putUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        String otherValue = "someOtherValue";
        payload = "{\"testProperty/base64/\":\"" + Base64.encodeBytes((byte[])otherValue.getBytes("UTF-8")) + "\"}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        String responseEncodedValue = properties.getString("testProperty/base64/");
        String decodedValue = new String(Base64.decode((String)responseEncodedValue), "UTF-8");
        Assert.assertThat((Object)decodedValue, (Matcher)Is.is((Object)otherValue));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
        connection = (HttpURLConnection)putUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        String anotherValue = "yetAnotherValue";
        payload = "{\"testProperty\":\"" + anotherValue + "\",\"otherProp\" : \"" + anotherValue + "\" }";
        connection.getOutputStream().write(payload.getBytes());
        body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        responseEncodedValue = properties.getString("testProperty/base64/");
        decodedValue = new String(Base64.decode((String)responseEncodedValue), "UTF-8");
        Assert.assertThat((Object)decodedValue, (Matcher)Is.is((Object)anotherValue));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldBeAbleToPutPropertiesToNode() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nodeForPutProperties");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\" }}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nodeForPutProperties");
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        payload = "{\"testProperty\": \"testValue\", \"multiValuedProperty\": [\"value1\", \"value2\"]}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        Assert.assertThat((Object)properties.getString("testProperty"), (Matcher)Is.is((Object)"testValue"));
        Assert.assertThat((Object)properties.get("multiValuedProperty"), (Matcher)IsInstanceOf.instanceOf(JSONArray.class));
        JSONArray values = properties.getJSONArray("multiValuedProperty");
        Assert.assertThat((Object)values, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)values.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)values.getString(0), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)values.getString(1), (Matcher)Is.is((Object)"value2"));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldBeAbleToAddAndRemoveMixinTypes() throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nodeWithNoMixins");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\" }}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        payload = "{\"jcr:mixinTypes\": \"mix:referenceable\"}";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        JSONObject properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        JSONArray mixinTypes = properties.getJSONArray("jcr:mixinTypes");
        Assert.assertThat((Object)mixinTypes, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)mixinTypes.length(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)mixinTypes.getString(0), (Matcher)Is.is((Object)"mix:referenceable"));
        Assert.assertThat((Object)properties.getString("jcr:uuid"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
        connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", "application/json");
        payload = "{\"jcr:mixinTypes\": []}";
        connection.getOutputStream().write(payload.getBytes());
        body = new JSONObject(this.getResponseFor(connection));
        Assert.assertThat((Object)body.length(), (Matcher)Is.is((Object)1));
        properties = body.getJSONObject("properties");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)properties.length(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)properties.getString("jcr:primaryType"), (Matcher)Is.is((Object)"nt:unstructured"));
        mixinTypes = properties.getJSONArray("jcr:mixinTypes");
        Assert.assertThat((Object)mixinTypes, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)mixinTypes.length(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)200));
        connection.disconnect();
    }

    @Test
    public void shouldRetrieveDataFromXPathQuery() throws Exception {
        String NODE_PATH = "/nodeForQuery";
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items/nodeForQuery");
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\" }}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
        URL queryUrl = new URL("http://localhost:8090/resources/test/repo/default/query");
        connection = (HttpURLConnection)queryUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/jcr+xpath");
        payload = "//nodeForQuery";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject queryResult = new JSONObject(this.getResponseFor(connection));
        JSONArray results = (JSONArray)queryResult.get("rows");
        Assert.assertThat((Object)results.length(), (Matcher)Is.is((Object)1));
        JSONObject result = (JSONObject)results.get(0);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((String)result.get("jcr:path")), (Matcher)Is.is((Object)"/nodeForQuery"));
        Assert.assertThat((Object)((String)result.get("jcr:primaryType")), (Matcher)Is.is((Object)"nt:unstructured"));
    }

    private void createNode(String path, int index) throws Exception {
        URL postUrl = new URL("http://localhost:8090/resources/test/repo/default/items" + path);
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = "{ \"properties\": {\"jcr:primaryType\": \"nt:unstructured\", \"foo\": \"" + index + "\" }}";
        connection.getOutputStream().write(payload.getBytes());
        Assert.assertThat((Object)connection.getResponseCode(), (Matcher)Is.is((Object)201));
        connection.disconnect();
    }

    @Test
    public void shouldRespectQueryOffsetAndLimit() throws Exception {
        String NODE_PATH = "nodeForOffsetAndLimitTest";
        this.createNode("/nodeForOffsetAndLimitTest", 1);
        this.createNode("/nodeForOffsetAndLimitTest", 2);
        this.createNode("/nodeForOffsetAndLimitTest", 3);
        this.createNode("/nodeForOffsetAndLimitTest", 4);
        URL queryUrl = new URL("http://localhost:8090/resources/test/repo/default/query?offset=1&limit=2");
        HttpURLConnection connection = (HttpURLConnection)queryUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/jcr+xpath");
        String payload = "//element(nodeForOffsetAndLimitTest) order by @foo";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject queryResult = new JSONObject(this.getResponseFor(connection));
        JSONArray results = (JSONArray)queryResult.get("rows");
        Assert.assertThat((Object)results.length(), (Matcher)Is.is((Object)2));
        JSONObject result = (JSONObject)results.get(0);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((String)result.get("jcr:path")), (Matcher)Is.is((Object)"/nodeForOffsetAndLimitTest[2]"));
        result = (JSONObject)results.get(1);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((String)result.get("jcr:path")), (Matcher)Is.is((Object)"/nodeForOffsetAndLimitTest[3]"));
    }

    @Test
    public void shouldAllowJcrSql2Query() throws Exception {
        String NODE_PATH = "nodeForJcrSql2QueryTest";
        this.createNode("/nodeForJcrSql2QueryTest", 1);
        this.createNode("/nodeForJcrSql2QueryTest/child", 1);
        this.createNode("/nodeForJcrSql2QueryTest/child", 2);
        this.createNode("/nodeForJcrSql2QueryTest/child", 3);
        this.createNode("/nodeForJcrSql2QueryTest/child", 4);
        URL queryUrl = new URL("http://localhost:8090/resources/test/repo/default/query");
        HttpURLConnection connection = (HttpURLConnection)queryUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/jcr+sql2");
        String payload = "SELECT * FROM [nt:unstructured] WHERE ISCHILDNODE('/nodeForJcrSql2QueryTest')";
        connection.getOutputStream().write(payload.getBytes());
        JSONObject queryResult = new JSONObject(this.getResponseFor(connection));
        JSONArray results = (JSONArray)queryResult.get("rows");
        Assert.assertThat((Object)results.length(), (Matcher)Is.is((Object)4));
    }
}

