/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.util.Collection;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.web.jcr.rest.spi.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class RepositoryFactory {
    public static final String PROVIDER_KEY = "org.modeshape.web.jcr.rest.REPOSITORY_PROVIDER";
    private static RepositoryProvider provider;

    private RepositoryFactory() {
    }

    static void initialize(ServletContext context) {
        CheckArg.isNotNull((Object)context, (String)"context");
        String className = context.getInitParameter(PROVIDER_KEY);
        try {
            Class<RepositoryProvider> providerClass = Class.forName(className).asSubclass(RepositoryProvider.class);
            provider = providerClass.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        provider.startup(context);
    }

    public static Session getSession(HttpServletRequest request, String repositoryName, String workspaceName) throws RepositoryException {
        return provider.getSession(request, repositoryName, workspaceName);
    }

    public static Collection<String> getJcrRepositoryNames() {
        return provider.getJcrRepositoryNames();
    }

    static void shutdown() {
        provider.shutdown();
    }
}

