/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.jcip.annotations.ThreadSafe;
import org.jboss.resteasy.spi.NotFoundException;
import org.modeshape.graph.SecurityContext;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.SecurityContextCredentials;
import org.modeshape.web.jcr.rest.ServletSecurityContext;
import org.modeshape.web.jcr.rest.spi.RepositoryProvider;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ModeShapeJcrRepositoryProvider
implements RepositoryProvider {
    public static final String CONFIG_FILE = "org.modeshape.web.jcr.rest.CONFIG_FILE";
    private JcrEngine jcrEngine;

    @Override
    public Set<String> getJcrRepositoryNames() {
        return new HashSet<String>(this.jcrEngine.getRepositoryNames());
    }

    private Repository getRepository(String repositoryName) throws RepositoryException {
        return this.jcrEngine.getRepository(repositoryName);
    }

    @Override
    public void startup(ServletContext context) {
        String configFile = context.getInitParameter(CONFIG_FILE);
        try {
            InputStream configFileInputStream = this.getClass().getResourceAsStream(configFile);
            this.jcrEngine = new JcrConfiguration().loadFrom(configFileInputStream).build();
            this.jcrEngine.start();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        catch (SAXException saxe) {
            throw new IllegalStateException(saxe);
        }
    }

    @Override
    public void shutdown() {
        this.jcrEngine.shutdown();
    }

    @Override
    public Session getSession(HttpServletRequest request, String repositoryName, String workspaceName) throws RepositoryException {
        Repository repository;
        assert (request != null);
        try {
            repository = this.getRepository(repositoryName);
        }
        catch (RepositoryException re) {
            throw new NotFoundException(re.getMessage(), (Throwable)re);
        }
        if (request.getUserPrincipal() == null) {
            return repository.login(workspaceName);
        }
        return repository.login((Credentials)new SecurityContextCredentials((SecurityContext)new ServletSecurityContext(request)), workspaceName);
    }
}

