/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.io.IOException;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.jcip.annotations.Immutable;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.modeshape.web.jcr.rest.AbstractHandler;
import org.modeshape.web.jcr.rest.ItemHandler;
import org.modeshape.web.jcr.rest.RepositoryHandler;
import org.modeshape.web.jcr.rest.ServerHandler;
import org.modeshape.web.jcr.rest.model.RepositoryEntry;
import org.modeshape.web.jcr.rest.model.WorkspaceEntry;
import org.modeshape.web.jcr.spi.NoSuchRepositoryException;

@Immutable
@Path(value="/")
public class JcrResources
extends AbstractHandler {
    private ServerHandler serverHandler = new ServerHandler();
    private RepositoryHandler repositoryHandler = new RepositoryHandler();
    private ItemHandler itemHandler = new ItemHandler();

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Map<String, RepositoryEntry> getRepositories(@Context HttpServletRequest request) {
        return this.serverHandler.getRepositories(request);
    }

    @GET
    @Path(value="/{repositoryName}")
    @Produces(value={"application/json"})
    public Map<String, WorkspaceEntry> getWorkspaces(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName) throws RepositoryException, IOException {
        return this.repositoryHandler.getWorkspaces(request, rawRepositoryName);
    }

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/items{path:.*}")
    @Produces(value={"application/json"})
    public String getItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path, @QueryParam(value="mode:depth") @DefaultValue(value="0") int depth) throws JSONException, UnauthorizedException, RepositoryException {
        return this.itemHandler.getItem(request, rawRepositoryName, rawWorkspaceName, path, depth);
    }

    @POST
    @Path(value="/{repositoryName}/{workspaceName}/items/{path:.*}")
    @Consumes(value={"application/json"})
    public Response postItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path, String requestContent) throws NotFoundException, UnauthorizedException, RepositoryException, JSONException {
        return this.itemHandler.postItem(request, rawRepositoryName, rawWorkspaceName, path, requestContent);
    }

    @DELETE
    @Path(value="/{repositoryName}/{workspaceName}/items{path:.*}")
    @Consumes(value={"application/json"})
    public void deleteItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path) throws NotFoundException, UnauthorizedException, RepositoryException {
        this.itemHandler.deleteItem(request, rawRepositoryName, rawWorkspaceName, path);
    }

    @PUT
    @Path(value="/{repositoryName}/{workspaceName}/items{path:.*}")
    @Consumes(value={"application/json"})
    public String putItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path, String requestContent) throws UnauthorizedException, JSONException, RepositoryException, IOException {
        return this.itemHandler.putItem(request, rawRepositoryName, rawWorkspaceName, path, requestContent);
    }

    @Provider
    public static class RepositoryExceptionMapper
    implements ExceptionMapper<RepositoryException> {
        public Response toResponse(RepositoryException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
    }

    @Provider
    public static class JSONExceptionMapper
    implements ExceptionMapper<JSONException> {
        public Response toResponse(JSONException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
    }

    @Provider
    public static class NoSuchRepositoryExceptionMapper
    implements ExceptionMapper<NoSuchRepositoryException> {
        public Response toResponse(NoSuchRepositoryException exception) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)exception.getMessage()).build();
        }
    }

    @Provider
    public static class NotFoundExceptionMapper
    implements ExceptionMapper<NotFoundException> {
        public Response toResponse(NotFoundException exception) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)exception.getMessage()).build();
        }
    }
}

