/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.common.text.UrlEncoder;
import org.modeshape.common.util.Base64;
import org.modeshape.web.jcr.RepositoryFactory;

abstract class AbstractHandler {
    protected static final String BASE64_ENCODING_SUFFIX = "/base64/";
    protected static final UrlEncoder URL_ENCODER = new UrlEncoder();
    public static final String EMPTY_REPOSITORY_NAME = "<default>";
    public static final String EMPTY_WORKSPACE_NAME = "<default>";

    AbstractHandler() {
    }

    protected Session getSession(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName) throws RepositoryException {
        assert (request != null);
        return RepositoryFactory.getSession((HttpServletRequest)request, (String)this.repositoryNameFor(rawRepositoryName), (String)this.workspaceNameFor(rawWorkspaceName));
    }

    private String workspaceNameFor(String rawWorkspaceName) {
        String workspaceName = URL_ENCODER.decode(rawWorkspaceName);
        if ("<default>".equals(workspaceName)) {
            workspaceName = "";
        }
        return workspaceName;
    }

    private String repositoryNameFor(String rawRepositoryName) {
        String repositoryName = URL_ENCODER.decode(rawRepositoryName);
        if ("<default>".equals(repositoryName)) {
            repositoryName = "";
        }
        return repositoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String jsonEncodedStringFor(Value value) throws RepositoryException {
        InputStream stream = value.getBinary().getStream();
        try {
            String string = Base64.encode((InputStream)stream);
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
        }
    }
}

