/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.web.jcr.rest.AbstractHandler;
import org.modeshape.web.jcr.rest.model.WorkspaceEntry;

@Immutable
class RepositoryHandler
extends AbstractHandler {
    RepositoryHandler() {
    }

    public Map<String, WorkspaceEntry> getWorkspaces(HttpServletRequest request, String rawRepositoryName) throws RepositoryException, IOException {
        assert (request != null);
        assert (rawRepositoryName != null);
        HashMap<String, WorkspaceEntry> workspaces = new HashMap<String, WorkspaceEntry>();
        Session session = this.getSession(request, rawRepositoryName, null);
        rawRepositoryName = URL_ENCODER.encode(rawRepositoryName);
        String uri = request.getRequestURI();
        uri = uri.substring(0, uri.length() - rawRepositoryName.length() - 1);
        for (String name : session.getWorkspace().getAccessibleWorkspaceNames()) {
            if (name.trim().length() == 0) {
                name = "<default>";
            }
            name = URL_ENCODER.encode(name);
            workspaces.put(name, new WorkspaceEntry(uri, rawRepositoryName, name));
        }
        return workspaces;
    }
}

