/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.net.URI;
import java.net.URLEncoder;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.web.jcr.ModeShapeJcrDeployer;
import org.modeshape.web.jcr.RepositoryFactory;
import org.modeshape.web.jcr.rest.QueryHandler;
import org.modeshape.web.jcr.spi.FactoryRepositoryProvider;

public class QueryHandlerTest {
    private final String VALID_JCR_URL = "file:src/test/resources/configRepository.xml";
    private final String REPOSITORY_NAME = "Test Repository Source";
    private final String WORKSPACE_NAME = "default";
    private final String NODE_NAME = "testNode";
    protected QueryHandler handler;
    protected ModeShapeJcrDeployer deployer;
    @Mock
    private ServletContext context;
    @Mock
    private ServletContextEvent event;
    @Mock
    private HttpServletRequest request;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.context.getInitParameter("org.modeshape.web.jcr.JCR_URL")).thenReturn((Object)"file:src/test/resources/configRepository.xml");
        Mockito.when((Object)this.context.getInitParameter("org.modeshape.web.jcr.REPOSITORY_PROVIDER")).thenReturn((Object)FactoryRepositoryProvider.class.getName());
        Mockito.when((Object)this.event.getServletContext()).thenReturn((Object)this.context);
        this.deployer = new ModeShapeJcrDeployer();
        this.deployer.contextInitialized(this.event);
        this.handler = new QueryHandler();
        Session session = this.getSession();
        Node root = session.getRootNode();
        for (int i = 0; i < 10; ++i) {
            Node newNode = root.addNode("testNode");
            newNode.setProperty("foo", (long)i);
        }
        session.save();
    }

    @After
    public void afterEach() throws Exception {
        this.deployer.contextDestroyed(this.event);
    }

    @Test
    public void shouldReturnAllResultsWhenNoOffsetOrLimitProvided() throws Exception {
        String statement = "//element(testNode) order by @foo";
        String response = this.handler.postItem(this.request, "Test Repository Source", "default", "xpath", statement, -1L, -1L, null);
        JSONObject queryResult = new JSONObject(response);
        Assert.assertThat((Object)queryResult.get("rows"), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        JSONArray results = (JSONArray)queryResult.get("rows");
        Assert.assertThat((Object)results.length(), (Matcher)Is.is((Object)10));
        for (int i = 0; i < 10; ++i) {
            JSONObject object = (JSONObject)results.get(i);
            String nodePath = (String)object.get("jcr:path");
            if (i == 0) {
                Assert.assertThat((Object)nodePath, (Matcher)Is.is((Object)"/testNode"));
                continue;
            }
            Assert.assertThat((Object)nodePath, (Matcher)Is.is((Object)("/testNode[" + (i + 1) + "]")));
        }
    }

    @Test
    public void shouldLimitResultsWhenLimitIsProvided() throws Exception {
        int LIMIT = 3;
        String statement = "//element(testNode) order by @foo";
        String response = this.handler.postItem(this.request, "Test Repository Source", "default", "xpath", statement, -1L, 3L, null);
        JSONObject queryResult = new JSONObject(response);
        Assert.assertThat((Object)queryResult.get("rows"), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        JSONArray results = (JSONArray)queryResult.get("rows");
        Assert.assertThat((Object)results.length(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            JSONObject object = (JSONObject)results.get(i);
            String nodePath = (String)object.get("jcr:path");
            if (i == 0) {
                Assert.assertThat((Object)nodePath, (Matcher)Is.is((Object)"/testNode"));
                continue;
            }
            Assert.assertThat((Object)nodePath, (Matcher)Is.is((Object)("/testNode[" + (i + 1) + "]")));
        }
    }

    @Test
    public void shouldLimitResultsFromProvidedOffset() throws Exception {
        int OFFSET = 5;
        int LIMIT = -1;
        String statement = "//element(testNode) order by @foo";
        String response = this.handler.postItem(this.request, "Test Repository Source", "default", "xpath", statement, 5L, -1L, null);
        JSONObject queryResult = new JSONObject(response);
        Assert.assertThat((Object)queryResult.get("rows"), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        JSONArray results = (JSONArray)queryResult.get("rows");
        Assert.assertThat((Object)results.length(), (Matcher)Is.is((Object)5));
        for (int i = 0; i < 5; ++i) {
            JSONObject object = (JSONObject)results.get(i);
            String nodePath = (String)object.get("jcr:path");
            Assert.assertThat((Object)nodePath, (Matcher)Is.is((Object)("/testNode[" + (i + 5 + 1) + "]")));
        }
    }

    @Test
    public void shouldFilterResultsFromProvidedOffsetAndLimit() throws Exception {
        int OFFSET = 5;
        int LIMIT = 3;
        String statement = "//element(testNode) order by @foo";
        String response = this.handler.postItem(this.request, "Test Repository Source", "default", "xpath", statement, 5L, 3L, null);
        JSONObject queryResult = new JSONObject(response);
        Assert.assertThat((Object)queryResult.get("rows"), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        JSONArray results = (JSONArray)queryResult.get("rows");
        Assert.assertThat((Object)results.length(), (Matcher)Is.is((Object)3));
        for (int i = 0; i < 3; ++i) {
            JSONObject object = (JSONObject)results.get(i);
            String nodePath = (String)object.get("jcr:path");
            Assert.assertThat((Object)nodePath, (Matcher)Is.is((Object)("/testNode[" + (i + 5 + 1) + "]")));
        }
    }

    @Test
    public void shouldReturnNoResultsForHighOffset() throws Exception {
        int OFFSET = 10;
        int LIMIT = -1;
        String statement = "//element(testNode) order by @foo";
        String response = this.handler.postItem(this.request, "Test Repository Source", "default", "xpath", statement, 10L, -1L, null);
        JSONObject queryResult = new JSONObject(response);
        Assert.assertThat((Object)queryResult.get("rows"), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        JSONArray results = (JSONArray)queryResult.get("rows");
        Assert.assertThat((Object)results.length(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnAllResultsForHighLimit() throws Exception {
        String statement = "//element(testNode) order by @foo";
        String response = this.handler.postItem(this.request, "Test Repository Source", "default", "xpath", statement, -1L, 100L, null);
        JSONObject queryResult = new JSONObject(response);
        Assert.assertThat((Object)queryResult.get("rows"), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        JSONArray results = (JSONArray)queryResult.get("rows");
        Assert.assertThat((Object)results.length(), (Matcher)Is.is((Object)10));
        for (int i = 0; i < 10; ++i) {
            JSONObject object = (JSONObject)results.get(i);
            String nodePath = (String)object.get("jcr:path");
            if (i == 0) {
                Assert.assertThat((Object)nodePath, (Matcher)Is.is((Object)"/testNode"));
                continue;
            }
            Assert.assertThat((Object)nodePath, (Matcher)Is.is((Object)("/testNode[" + (i + 1) + "]")));
        }
    }

    @Test
    public void shouldBindQueryParametersAsVariables() throws Exception {
        URI absoluteUri = this.uri("query?var1=value1&var2=value2&var3=value3&limit=100");
        UriInfoImpl uriInfo = new UriInfoImpl(absoluteUri, absoluteUri, absoluteUri.getRawPath(), absoluteUri.getRawQuery(), PathSegmentImpl.parseSegments((String)absoluteUri.getRawPath()));
        String statement = "//element(testNode) order by @foo";
        String response = this.handler.postItem(this.request, "Test Repository Source", "default", "xpath", statement, -1L, 100L, (UriInfo)uriInfo);
        JSONObject queryResult = new JSONObject(response);
        Assert.assertThat((Object)queryResult.get("rows"), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        JSONArray results = (JSONArray)queryResult.get("rows");
        Assert.assertThat((Object)results.length(), (Matcher)Is.is((Object)10));
        for (int i = 0; i < 10; ++i) {
            JSONObject object = (JSONObject)results.get(i);
            String nodePath = (String)object.get("jcr:path");
            if (i == 0) {
                Assert.assertThat((Object)nodePath, (Matcher)Is.is((Object)"/testNode"));
                continue;
            }
            Assert.assertThat((Object)nodePath, (Matcher)Is.is((Object)("/testNode[" + (i + 1) + "]")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldQueryAndNotFailWhenNullValueAppearsInResultSet() throws Exception {
        Session session = this.getSession();
        String nodeName = "publishAreaX";
        String nodePath = "/" + nodeName;
        try {
            Node publishAreaX = session.getRootNode().addNode(nodeName, "nt:unstructured");
            publishAreaX.addMixin("mode:publishArea");
            session.save();
            String statement = "SELECT [jcr:primaryType], [jcr:path], [jcr:title] FROM [mode:publishArea]";
            String response = this.handler.postItem(this.request, "Test Repository Source", "default", "JCR-SQL2", statement, -1L, 100L, null);
            JSONObject queryResult = new JSONObject(response);
            Assert.assertThat((Object)queryResult.get("rows"), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
            JSONArray results = (JSONArray)queryResult.get("rows");
            Assert.assertThat((Object)results.length(), (Matcher)Is.is((Object)1));
            JSONObject object = (JSONObject)results.get(0);
            Assert.assertThat((Object)((String)object.get("jcr:path")), (Matcher)Is.is((Object)nodePath));
            Assert.assertThat((Object)object.has("jcr:title"), (Matcher)Is.is((Object)false));
        }
        finally {
            try {
                session.getNode("/publishAreaX").remove();
            }
            catch (RepositoryException e) {}
        }
    }

    private URI uri(String relativePathExcludingRepositoryAndWorkspace) throws Exception {
        String uri = "http://www.example.com/resources/" + URLEncoder.encode("Test Repository Source", "UTF-8") + "/" + URLEncoder.encode("default", "UTF-8") + "/" + relativePathExcludingRepositoryAndWorkspace;
        return new URI(uri);
    }

    private Session getSession() throws RepositoryException {
        return RepositoryFactory.getSession((HttpServletRequest)this.request, (String)"Test Repository Source", (String)"default");
    }
}

