/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.handler.AbstractHandler;
import org.modeshape.web.jcr.rest.model.RestNodeType;

public final class RestNodeTypeHandler
extends AbstractHandler {
    private static final int HTTP_NOT_IMPLEMENTED = 501;

    public RestNodeType getNodeType(HttpServletRequest request, String repositoryName, String workspaceName, String nodeTypeName) throws RepositoryException {
        Session session = this.getSession(request, repositoryName, workspaceName);
        javax.jcr.nodetype.NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
        NodeType nodeType = nodeTypeManager.getNodeType(nodeTypeName);
        return new RestNodeType(nodeType, RestHelper.repositoryUrl(request));
    }

    public Response importCND(HttpServletRequest request, String repositoryName, String workspaceName, boolean allowUpdate, InputStream cndInputStream) throws RepositoryException {
        CheckArg.isNotNull((Object)cndInputStream, (String)"request body");
        Session session = this.getSession(request, repositoryName, workspaceName);
        javax.jcr.nodetype.NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
        if (!(nodeTypeManager instanceof NodeTypeManager)) {
            return Response.status((Response.Status)Response.Status.fromStatusCode((int)501)).build();
        }
        NodeTypeManager modeshapeTypeManager = (NodeTypeManager)nodeTypeManager;
        try {
            List<RestNodeType> registeredTypes = this.registerCND(request, allowUpdate, cndInputStream, modeshapeTypeManager);
            return this.createOkResponse(registeredTypes);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private Response createOkResponse(List<RestNodeType> registeredTypes) {
        GenericEntity<List<RestNodeType>> entity = new GenericEntity<List<RestNodeType>>(registeredTypes){};
        return Response.ok().entity((Object)entity).build();
    }

    private List<RestNodeType> registerCND(HttpServletRequest request, boolean allowUpdate, InputStream cndInputStream, NodeTypeManager modeshapeTypeManager) throws IOException, RepositoryException {
        NodeTypeIterator nodeTypeIterator = modeshapeTypeManager.registerNodeTypes(cndInputStream, allowUpdate);
        ArrayList<RestNodeType> result = new ArrayList<RestNodeType>();
        String baseUrl = RestHelper.repositoryUrl(request);
        while (nodeTypeIterator.hasNext()) {
            result.add(new RestNodeType(nodeTypeIterator.nextNodeType(), baseUrl));
        }
        return result;
    }
}

