/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.spi.NotFoundException;
import org.modeshape.web.jcr.NoSuchRepositoryException;
import org.modeshape.web.jcr.rest.model.RestException;

public final class ExceptionMappers {
    private ExceptionMappers() {
    }

    public static Response exceptionResponse(Exception e, Response.Status status) {
        return Response.status((Response.Status)status).entity((Object)new RestException(e)).build();
    }

    @Provider
    public static class IllegalArgumentExceptionMapper
    implements ExceptionMapper<IllegalArgumentException> {
        public Response toResponse(IllegalArgumentException exception) {
            return ExceptionMappers.exceptionResponse(exception, Response.Status.BAD_REQUEST);
        }
    }

    @Provider
    public static class NoSuchNodeTypeExceptionMapper
    implements ExceptionMapper<NoSuchNodeTypeException> {
        public Response toResponse(NoSuchNodeTypeException exception) {
            return ExceptionMappers.exceptionResponse((Exception)exception, Response.Status.NOT_FOUND);
        }
    }

    @Provider
    public static class LoginExceptionMapper
    implements ExceptionMapper<LoginException> {
        public Response toResponse(LoginException exception) {
            return ExceptionMappers.exceptionResponse((Exception)exception, Response.Status.UNAUTHORIZED);
        }
    }

    @Provider
    public static class RepositoryExceptionMapper
    implements ExceptionMapper<RepositoryException> {
        public Response toResponse(RepositoryException exception) {
            return ExceptionMappers.exceptionResponse((Exception)exception, Response.Status.BAD_REQUEST);
        }
    }

    @Provider
    public static class InvalidQueryExceptionMapper
    implements ExceptionMapper<InvalidQueryException> {
        public Response toResponse(InvalidQueryException exception) {
            return ExceptionMappers.exceptionResponse((Exception)exception, Response.Status.BAD_REQUEST);
        }
    }

    @Provider
    public static class JSONExceptionMapper
    implements ExceptionMapper<JSONException> {
        public Response toResponse(JSONException exception) {
            return ExceptionMappers.exceptionResponse((Exception)exception, Response.Status.BAD_REQUEST);
        }
    }

    @Provider
    public static class NoSuchRepositoryExceptionMapper
    implements ExceptionMapper<NoSuchRepositoryException> {
        public Response toResponse(NoSuchRepositoryException exception) {
            return ExceptionMappers.exceptionResponse((Exception)exception, Response.Status.NOT_FOUND);
        }
    }

    @Provider
    public static class NoSuchWorkspaceExceptionMapper
    implements ExceptionMapper<NoSuchWorkspaceException> {
        public Response toResponse(NoSuchWorkspaceException exception) {
            return ExceptionMappers.exceptionResponse((Exception)exception, Response.Status.NOT_FOUND);
        }
    }

    @Provider
    public static class PathNotFoundExceptionMapper
    implements ExceptionMapper<PathNotFoundException> {
        public Response toResponse(PathNotFoundException exception) {
            return ExceptionMappers.exceptionResponse((Exception)exception, Response.Status.NOT_FOUND);
        }
    }

    @Provider
    public static class NotFoundExceptionMapper
    implements ExceptionMapper<NotFoundException> {
        public Response toResponse(NotFoundException exception) {
            return ExceptionMappers.exceptionResponse((Exception)exception, Response.Status.NOT_FOUND);
        }
    }
}

