/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.modeshape.common.util.StringUtil;
import org.modeshape.web.jcr.rest.handler.ItemHandler;
import org.modeshape.web.jcr.rest.model.RestItem;

public final class RestNodeHandler
extends ItemHandler {
    public RestItem nodeWithId(HttpServletRequest request, String repositoryName, String workspaceName, String id, int depth) throws RepositoryException {
        Session session = this.getSession(request, repositoryName, workspaceName);
        Node node = this.nodeWithId(id, session);
        return this.createRestItem(request, depth, session, (Item)node);
    }

    public RestItem updateNodeWithId(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName, String id, String requestContent) throws JSONException, RepositoryException {
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        Node node = this.nodeWithId(id, session);
        node = this.updateNode(node, this.stringToJSONObject(requestContent));
        session.save();
        return this.createRestItem(request, 0, session, (Item)node);
    }

    private JSONObject stringToJSONObject(String requestBody) throws JSONException {
        return StringUtil.isBlank((String)requestBody) ? new JSONObject() : new JSONObject(requestBody);
    }

    public void deleteNodeWithId(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName, String id) throws NotFoundException, UnauthorizedException, RepositoryException {
        assert (rawRepositoryName != null);
        assert (rawWorkspaceName != null);
        assert (id != null);
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        Node node = this.nodeWithId(id, session);
        node.remove();
        session.save();
    }

    @Override
    protected Node nodeWithId(String id, Session session) throws RepositoryException {
        try {
            return session.getNodeByIdentifier(id);
        }
        catch (ItemNotFoundException infe) {
            throw new NotFoundException(infe.getMessage(), (Throwable)infe);
        }
    }
}

