/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.web.jcr.rest.handler.ItemHandler;
import org.modeshape.web.jcr.rest.handler.QueryHandler;
import org.modeshape.web.jcr.rest.handler.RepositoryHandler;
import org.modeshape.web.jcr.rest.handler.ServerHandler;

@Deprecated
@Immutable
@Path(value="/v1")
public class JcrResources {
    private static final String SEARCH_LANGUAGE = "Search";
    private ServerHandler serverHandler = new ServerHandler();
    private RepositoryHandler repositoryHandler = new RepositoryHandler();
    private ItemHandler itemHandler = new ItemHandler();
    private QueryHandler queryHandler = new QueryHandler();

    @GET
    @Path(value="/")
    @Produces(value={"text/plain", "application/json", "text/html"})
    public String getRepositories(@Context HttpServletRequest request) throws JSONException, RepositoryException {
        return this.serverHandler.getRepositories(request);
    }

    @GET
    @Path(value="{repositoryName}")
    @Produces(value={"text/plain", "application/json", "text/html"})
    public String getWorkspaces(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName) throws JSONException, RepositoryException {
        return this.repositoryHandler.getWorkspaces(request, rawRepositoryName);
    }

    @GET
    @Path(value="{repositoryName}/{workspaceName}/items{path:.*}")
    @Produces(value={"text/plain", "application/json", "text/html"})
    public String getItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path, @QueryParam(value="mode:depth") @DefaultValue(value="0") int deprecatedDepth, @QueryParam(value="depth") @DefaultValue(value="0") int depth) throws JSONException, NotAuthorizedException, RepositoryException {
        if (depth == 0 && deprecatedDepth != 0) {
            depth = deprecatedDepth;
        }
        return this.itemHandler.getItem(request, rawRepositoryName, rawWorkspaceName, path, depth);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/items/{path:.*}")
    @Produces(value={"text/plain", "application/json", "text/html"})
    public Response postItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path, @QueryParam(value="mode:includeNode") String fullNodeInResponse, String requestContent) throws NotFoundException, NotAuthorizedException, RepositoryException, JSONException {
        return this.itemHandler.postItem(request, rawRepositoryName, rawWorkspaceName, path, fullNodeInResponse == null || Boolean.valueOf(fullNodeInResponse) != false, requestContent);
    }

    @DELETE
    @Path(value="{repositoryName}/{workspaceName}/items{path:.*}")
    public void deleteItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path) throws NotFoundException, NotAuthorizedException, RepositoryException {
        this.itemHandler.deleteItem(request, rawRepositoryName, rawWorkspaceName, path);
    }

    @PUT
    @Path(value="{repositoryName}/{workspaceName}/items{path:.*}")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain", "application/json", "text/html"})
    public String putItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path, String requestContent) throws NotAuthorizedException, JSONException, RepositoryException, IOException {
        return this.itemHandler.putItem(request, rawRepositoryName, rawWorkspaceName, path, requestContent);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/query")
    @Consumes(value={"application/jcr+xpath"})
    @Produces(value={"text/plain", "application/json", "text/html"})
    public String postXPathQuery(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @QueryParam(value="offset") @DefaultValue(value="-1") long offset, @QueryParam(value="limit") @DefaultValue(value="-1") long limit, @Context UriInfo uriInfo, String requestContent) throws InvalidQueryException, RepositoryException, JSONException {
        return this.queryHandler.postItem(request, rawRepositoryName, rawWorkspaceName, "xpath", requestContent, offset, limit, uriInfo);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/query")
    @Consumes(value={"application/jcr+sql"})
    @Produces(value={"text/plain", "application/json", "text/html"})
    public String postJcrSqlQuery(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @QueryParam(value="offset") @DefaultValue(value="-1") long offset, @QueryParam(value="limit") @DefaultValue(value="-1") long limit, @Context UriInfo uriInfo, String requestContent) throws InvalidQueryException, RepositoryException, JSONException {
        return this.queryHandler.postItem(request, rawRepositoryName, rawWorkspaceName, "sql", requestContent, offset, limit, uriInfo);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/query")
    @Consumes(value={"application/jcr+sql2"})
    @Produces(value={"text/plain", "application/json", "text/html"})
    public String postJcrSql2Query(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @QueryParam(value="offset") @DefaultValue(value="-1") long offset, @QueryParam(value="limit") @DefaultValue(value="-1") long limit, @Context UriInfo uriInfo, String requestContent) throws InvalidQueryException, RepositoryException, JSONException {
        return this.queryHandler.postItem(request, rawRepositoryName, rawWorkspaceName, "JCR-SQL2", requestContent, offset, limit, uriInfo);
    }

    @POST
    @Path(value="{repositoryName}/{workspaceName}/query")
    @Consumes(value={"application/jcr+search"})
    @Produces(value={"text/plain", "application/json", "text/html"})
    public String postJcrSearchQuery(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @QueryParam(value="offset") @DefaultValue(value="-1") long offset, @QueryParam(value="limit") @DefaultValue(value="-1") long limit, @Context UriInfo uriInfo, String requestContent) throws RepositoryException, JSONException {
        return this.queryHandler.postItem(request, rawRepositoryName, rawWorkspaceName, SEARCH_LANGUAGE, requestContent, offset, limit, uriInfo);
    }
}

