/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.modeshape.web.jcr.rest.model.JSONAble;
import org.modeshape.web.jcr.rest.model.RestException;
import org.modeshape.web.jcr.rest.output.TextBodyWriter;

@Provider
@Produces(value={"text/html"})
public class HtmlBodyWriter
extends TextBodyWriter {
    @Override
    protected String getString(JSONAble jsonAble) throws JSONException {
        String text = super.getString(jsonAble);
        return jsonAble instanceof RestException ? this.replaceSpaces(this.replaceLineTerminators(text)) : this.htmlString(text);
    }

    @Override
    protected String getString(JSONArray array) throws JSONException {
        return this.htmlString(super.getString(array));
    }

    private String htmlString(String jsonString) {
        jsonString = this.replaceLineTerminators(jsonString);
        jsonString = this.replaceSpaces(jsonString);
        jsonString = this.createURLs(jsonString);
        return "<code>" + jsonString + "</code>";
    }

    private String createURLs(String jsonString) {
        String urlPattern = "(?:(?:https?|file)://)[^\"\\r\\n]+";
        jsonString = jsonString.replaceAll(urlPattern, "<a href=$0>$0</a>");
        return jsonString;
    }

    private String replaceSpaces(String jsonString) {
        Pattern pattern = Pattern.compile("(\\s*)");
        Matcher matcher = pattern.matcher(jsonString);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String spaces = matcher.group(1);
            StringBuilder nbspBuffer = new StringBuilder(spaces.length());
            for (int i = 0; i < spaces.length(); ++i) {
                nbspBuffer.append("&nbsp;");
            }
            matcher.appendReplacement(buffer, nbspBuffer.toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String replaceLineTerminators(String jsonString) {
        jsonString = jsonString.replaceAll("\\\\r\\\\n\\\\t", "<br/>").replaceAll("\r\n\t", "<br/>").replaceAll("\r\n", "<br/>").replaceAll("\n", "<br/>").replaceAll("\r", "<br/>").replaceAll("\t", "<br/>").replaceAll("\\\\", "");
        return jsonString;
    }
}

