/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.model.JSONAble;

public final class RestWorkspaces
implements JSONAble {
    private final List<Workspace> workspaces = new ArrayList<Workspace>();

    public Workspace addWorkspace(String name, String repositoryUrl) {
        Workspace workspace = new Workspace(name, repositoryUrl);
        this.workspaces.add(workspace);
        return workspace;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = new JSONObject();
        JSONArray workspaces = new JSONArray();
        for (Workspace workspace : this.workspaces) {
            workspaces.put((Object)workspace.toJSON());
        }
        result.put("workspaces", (Object)workspaces);
        return result;
    }

    private class Workspace
    implements JSONAble {
        private final String name;
        private final String repositoryUrl;
        private final String queryUrl;
        private final String itemsUrl;
        private final String binaryUrl;
        private final String nodeTypesUrl;

        public Workspace(String name, String repositoryUrl) {
            this.name = name;
            this.repositoryUrl = repositoryUrl;
            this.queryUrl = RestHelper.urlFrom(repositoryUrl, name, "query");
            this.itemsUrl = RestHelper.urlFrom(repositoryUrl, name, "items");
            this.binaryUrl = RestHelper.urlFrom(repositoryUrl, name, "binary");
            this.nodeTypesUrl = RestHelper.urlFrom(repositoryUrl, name, "nodetypes");
        }

        @Override
        public JSONObject toJSON() throws JSONException {
            JSONObject result = new JSONObject();
            result.put("name", (Object)this.name);
            result.put("repository", (Object)this.repositoryUrl);
            result.put("items", (Object)this.itemsUrl);
            result.put("query", (Object)this.queryUrl);
            result.put("binary", (Object)this.binaryUrl);
            result.put("nodeTypes", (Object)this.nodeTypesUrl);
            return result;
        }
    }
}

