/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import java.io.File;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.BackupOptions;
import org.modeshape.jcr.api.Problem;
import org.modeshape.jcr.api.Problems;
import org.modeshape.jcr.api.RepositoryManager;
import org.modeshape.jcr.api.RestoreOptions;
import org.modeshape.jcr.api.Workspace;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.handler.AbstractHandler;
import org.modeshape.web.jcr.rest.model.JSONAble;
import org.modeshape.web.jcr.rest.model.RestException;
import org.modeshape.web.jcr.rest.model.RestWorkspaces;

public final class RestRepositoryHandler
extends AbstractHandler {
    private static final String BACKUP_LOCATION_INIT_PARAM = "backupLocation";
    private static final String JBOSS_DOMAIN_DATA_DIR = "jboss.domain.data.dir";
    private static final String JBOSS_SERVER_DATA_DIR = "jboss.server.data.dir";
    private static final String USER_HOME = "user.home";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("ddMMyyyy_HHmmss");

    public RestWorkspaces getWorkspaces(HttpServletRequest request, String repositoryName) throws RepositoryException {
        assert (request != null);
        assert (repositoryName != null);
        RestWorkspaces workspaces = new RestWorkspaces();
        Session session = this.getSession(request, repositoryName, null);
        for (String workspaceName : session.getWorkspace().getAccessibleWorkspaceNames()) {
            String repositoryUrl = RestHelper.urlFrom(request, new String[0]);
            workspaces.addWorkspace(workspaceName, repositoryUrl);
        }
        return workspaces;
    }

    public Response backupRepository(ServletContext context, HttpServletRequest request, String repositoryName, BackupOptions options) throws RepositoryException {
        String backupURL;
        File backupLocation = this.resolveBackupLocation(context);
        Session session = this.getSession(request, repositoryName, null);
        String repositoryVersion = session.getRepository().getDescriptorValue("jcr.repository.version").getString().replaceAll("\\.", "");
        final String backupName = "modeshape_" + repositoryVersion + "_" + repositoryName + "_backup_" + DATE_FORMAT.format(new Date());
        File backup = new File(backupLocation, backupName);
        if (!backup.mkdirs()) {
            throw new RuntimeException("Cannot create backup folder: " + backup);
        }
        this.logger.debug("Backing up repository '{0}' to '{1}', using '{2}'", new Object[]{repositoryName, backup, options});
        RepositoryManager repositoryManager = ((Workspace)session.getWorkspace()).getRepositoryManager();
        repositoryManager.backupRepository(backup, options);
        try {
            backupURL = backup.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        JSONAble responseContent = new JSONAble(){

            @Override
            public JSONObject toJSON() throws JSONException {
                JSONObject object = new JSONObject();
                object.put("name", (Object)backupName);
                object.put("url", (Object)backupURL);
                return object;
            }
        };
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)responseContent).build();
    }

    public Response restoreRepository(ServletContext context, HttpServletRequest request, String repositoryName, String backupName, RestoreOptions options) throws RepositoryException {
        if (StringUtil.isBlank((String)backupName)) {
            throw new IllegalArgumentException("The name of the backup cannot be null");
        }
        File backup = this.resolveBackup(context, backupName);
        this.logger.debug("Restoring repository '{0}' from backup '{1}' using '{2}'", new Object[]{repositoryName, backup, options});
        Session session = this.getSession(request, repositoryName, null);
        RepositoryManager repositoryManager = ((Workspace)session.getWorkspace()).getRepositoryManager();
        Problems problems = repositoryManager.restoreRepository(backup, options);
        if (!problems.hasProblems()) {
            return Response.ok().build();
        }
        ArrayList<RestException> response = new ArrayList<RestException>(problems.size());
        for (Problem problem : problems) {
            RestException exception = problem.getThrowable() != null ? new RestException(problem.getMessage(), problem.getThrowable()) : new RestException(problem.getMessage());
            response.add(exception);
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(response).build();
    }

    private File resolveBackup(ServletContext context, String backupName) {
        String backupRoot = context.getInitParameter(BACKUP_LOCATION_INIT_PARAM);
        if (!StringUtil.isBlank((String)backupRoot)) {
            if (this.isValidDir(backupRoot + "/" + backupName)) {
                return new File(backupRoot + "/" + backupName);
            }
            if (this.isValidDir((backupRoot = System.getProperty(backupRoot)) + "/" + backupName)) {
                return new File(backupRoot + "/" + backupName);
            }
        }
        if (this.isValidDir((backupRoot = System.getProperty(JBOSS_DOMAIN_DATA_DIR)) + "/" + backupName)) {
            return new File(backupRoot + "/" + backupName);
        }
        backupRoot = System.getProperty(JBOSS_SERVER_DATA_DIR);
        if (this.isValidDir(backupRoot + "/" + backupName)) {
            return new File(backupRoot + "/" + backupName);
        }
        backupRoot = System.getProperty(USER_HOME);
        if (this.isValidDir(backupRoot + "/" + backupName)) {
            return new File(backupRoot + "/" + backupName);
        }
        throw new IllegalArgumentException("Cannot locate backup '" + backupName + "' anywhere on the server in the following locations:" + BACKUP_LOCATION_INIT_PARAM + " context param, " + JBOSS_DOMAIN_DATA_DIR + ", " + JBOSS_SERVER_DATA_DIR + ", " + USER_HOME);
    }

    private File resolveBackupLocation(ServletContext context) {
        String backupLocation = context.getInitParameter(BACKUP_LOCATION_INIT_PARAM);
        if (!StringUtil.isBlank((String)backupLocation)) {
            if (this.isValidDir(backupLocation)) {
                return new File(backupLocation);
            }
            if (this.isValidDir(backupLocation = System.getProperty(backupLocation))) {
                return new File(backupLocation);
            }
        }
        if (this.isValidDir(backupLocation = System.getProperty(JBOSS_DOMAIN_DATA_DIR))) {
            return new File(backupLocation);
        }
        backupLocation = System.getProperty(JBOSS_SERVER_DATA_DIR);
        if (this.isValidDir(backupLocation)) {
            return new File(backupLocation);
        }
        backupLocation = System.getProperty(USER_HOME);
        if (this.isValidDir(backupLocation)) {
            return new File(backupLocation);
        }
        throw new IllegalArgumentException("None of the following locations are writable folders on the server: backupLocation context param, jboss.domain.data.dir, jboss.server.data.dir, user.home");
    }

    private boolean isValidDir(String dir) {
        if (StringUtil.isBlank((String)dir)) {
            return false;
        }
        File dirFile = new File(dir);
        return dirFile.exists() && dirFile.canWrite() && dirFile.isDirectory();
    }
}

