/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import com.googlecode.sardine.DavResource;
import com.googlecode.sardine.Sardine;
import com.googlecode.sardine.SardineFactory;
import com.googlecode.sardine.util.SardineException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.util.StringUtil;
import org.modeshape.webdav.WebdavStoreClientTest;

public class ModeShapeWebdavStoreClientTest
extends WebdavStoreClientTest {
    private static final String REPOSITORY_NAME = "webdav_repo";
    private static final String SERVER_CONTEXT = "http://localhost:8090/webdav-jcr";

    protected Sardine initializeWebDavClient() throws SardineException {
        return SardineFactory.begin((String)"dnauser", (String)"password");
    }

    @Test
    public void shouldConnectToRepository() throws Exception {
        String uri = this.getJcrServerUrl(null);
        Assert.assertTrue((boolean)this.sardine.exists(uri));
        Assert.assertNotNull((Object)this.sardine.getResources(uri));
    }

    @Test
    public void shouldConnectToRepositoryAndWorkspace() throws Exception {
        String uri = this.getJcrServerUrl(this.getDefaultWorkspaceName());
        Assert.assertTrue((boolean)this.sardine.exists(uri));
        Assert.assertNotNull((Object)this.sardine.getResources(uri));
    }

    @Test
    public void shouldNotFindInvalidRepository() throws Exception {
        String uri = this.getServerContext() + "/missing_repo";
        Assert.assertFalse((boolean)this.sardine.exists(uri));
    }

    @Test
    public void shouldNotFindInvalidWorkspace() throws Exception {
        String uri = this.getJcrServerUrl("missingWS");
        Assert.assertFalse((boolean)this.sardine.exists(uri));
    }

    @Test
    @FixFor(value={"MODE-1542"})
    public void shouldCreateLargeFile() throws Exception {
        int binarySize = 0x6400000;
        byte[] binaryData = new byte[binarySize];
        new Random().nextBytes(binaryData);
        String folderUri = this.resourceUri("testDirectory" + UUID.randomUUID().toString());
        this.sardine.createDirectory(folderUri);
        String fileUri = folderUri + "/testFile" + UUID.randomUUID().toString();
        this.sardine.put(fileUri, (InputStream)new ByteArrayInputStream(binaryData), "application/octet-stream");
        Assert.assertTrue((boolean)this.sardine.exists(fileUri));
        DavResource file = this.getResourceAtURI(fileUri);
        Assert.assertEquals((long)binarySize, (long)file.getContentLength().intValue());
    }

    protected String getDefaultWorkspaceName() {
        return "default";
    }

    protected String getServerContext() {
        return SERVER_CONTEXT;
    }

    protected String getRepositoryName() {
        return REPOSITORY_NAME;
    }

    protected String resourceUri(String resourceName) {
        String rootUrl = this.getJcrServerUrl(this.getDefaultWorkspaceName());
        return !StringUtil.isBlank((String)resourceName) ? rootUrl + "/" + resourceName : rootUrl;
    }

    private String getJcrServerUrl(String workspaceName) {
        String serverContext = this.getServerContext();
        Assert.assertNotNull((Object)serverContext);
        String repositoryName = this.getRepositoryName();
        Assert.assertNotNull((Object)repositoryName);
        String baseUrl = serverContext + "/" + repositoryName;
        return workspaceName != null ? baseUrl + "/" + workspaceName : baseUrl;
    }
}

