/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import com.googlecode.sardine.DavResource;
import com.googlecode.sardine.Sardine;
import com.googlecode.sardine.SardineFactory;
import com.googlecode.sardine.util.SardineException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.util.StringUtil;
import org.modeshape.webdav.WebdavStoreClientTest;

public class ModeShapeWebdavStoreClientTest
extends WebdavStoreClientTest {
    private static final String REPOSITORY_NAME = "webdav_repo";
    private static final String SERVER_CONTEXT = "http://localhost:8090/webdav-jcr";

    protected Sardine initializeWebDavClient() throws SardineException {
        return SardineFactory.begin((String)"dnauser", (String)"password");
    }

    @Test
    public void shouldConnectToRepository() throws Exception {
        String uri = this.getJcrServerUrl(null);
        Assert.assertTrue((boolean)this.sardine.exists(uri));
        Assert.assertNotNull((Object)this.sardine.getResources(uri));
    }

    @Test
    public void shouldConnectToRepositoryAndWorkspace() throws Exception {
        String uri = this.getJcrServerUrl(this.getDefaultWorkspaceName());
        Assert.assertTrue((boolean)this.sardine.exists(uri));
        Assert.assertNotNull((Object)this.sardine.getResources(uri));
    }

    @Test
    public void shouldNotFindInvalidRepository() throws Exception {
        String uri = this.getServerContext() + "/missing_repo";
        Assert.assertFalse((boolean)this.sardine.exists(uri));
    }

    @Test
    public void shouldNotFindInvalidWorkspace() throws Exception {
        String uri = this.getJcrServerUrl("missingWS");
        Assert.assertFalse((boolean)this.sardine.exists(uri));
    }

    @Test
    @FixFor(value={"MODE-1542"})
    public void shouldCreateLargeFile() throws Exception {
        int binarySize = 0x6400000;
        byte[] binaryData = new byte[binarySize];
        new Random().nextBytes(binaryData);
        String folderUri = this.resourceUri(this.testFolder());
        this.sardine.createDirectory(folderUri);
        String fileUri = this.testFile(folderUri);
        this.sardine.put(fileUri, (InputStream)new ByteArrayInputStream(binaryData), "application/octet-stream");
        Assert.assertTrue((boolean)this.sardine.exists(fileUri));
        DavResource file = this.getResourceAtURI(fileUri);
        Assert.assertEquals((long)binarySize, (long)file.getContentLength().intValue());
    }

    private String testFile(String folderUri) {
        return folderUri + "/testFile" + UUID.randomUUID().toString();
    }

    @Test
    @FixFor(value={"MODE-984"})
    public void shouldRetrieveFolderCustomProperties() throws Exception {
        String folderUri = this.resourceUri(this.testFolder());
        this.sardine.createDirectory(folderUri);
        DavResource resource = (DavResource)this.sardine.getResources(folderUri).get(0);
        Map customProperties = resource.getCustomProps();
        Assert.assertTrue((!customProperties.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"nt:folder", customProperties.get("primaryType"));
        Assert.assertNotNull(customProperties.get("created"));
        Assert.assertNotNull(customProperties.get("createdBy"));
    }

    @Test
    @FixFor(value={"MODE-984"})
    public void shouldRetrieveFileCustomProperties() throws Exception {
        String folderUri = this.resourceUri(this.testFolder());
        this.sardine.createDirectory(folderUri);
        byte[] binaryData = new byte[1024];
        new Random().nextBytes(binaryData);
        String fileUri = this.testFile(folderUri);
        this.sardine.put(fileUri, (InputStream)new ByteArrayInputStream(binaryData), "application/octet-stream");
        DavResource resource = (DavResource)this.sardine.getResources(fileUri).get(0);
        Map customProperties = resource.getCustomProps();
        Assert.assertTrue((!customProperties.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"nt:file", customProperties.get("primaryType"));
        Assert.assertNotNull(customProperties.get("created"));
        Assert.assertNotNull(customProperties.get("createdBy"));
    }

    @FixFor(value={"MODE-984"})
    public void shouldSetCustomPropertiesOnFile() throws Exception {
        String folderUri = this.resourceUri(this.testFolder());
        this.sardine.createDirectory(folderUri);
        byte[] binaryData = new byte[1024];
        new Random().nextBytes(binaryData);
        String fileUri = this.testFile(folderUri);
        this.sardine.put(fileUri, (InputStream)new ByteArrayInputStream(binaryData), "application/octet-stream");
        HashMap<String, String> customProps = new HashMap<String, String>();
        customProps.put("myProp", "myValue");
        this.sardine.setCustomProps(fileUri, customProps, null);
        DavResource resource = (DavResource)this.sardine.getResources(fileUri).get(0);
        Map customProperties = resource.getCustomProps();
        Assert.assertTrue((!customProperties.isEmpty() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)customProperties.containsKey("myProp"));
    }

    public void shouldSetCustomPropertiesOnFolder() throws Exception {
        String folderUri = this.resourceUri(this.testFolder());
        this.sardine.createDirectory(folderUri);
        HashMap<String, String> customProps = new HashMap<String, String>();
        customProps.put("myProp", "myValue");
        this.sardine.setCustomProps(folderUri, customProps, null);
        DavResource resource = (DavResource)this.sardine.getResources(folderUri).get(0);
        Map customProperties = resource.getCustomProps();
        Assert.assertTrue((!customProperties.isEmpty() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)customProperties.containsKey("myProp"));
    }

    @Test
    @FixFor(value={"MODE-2010"})
    public void shouldIgnoreMultiValuedProperties() throws Exception {
        String nodeUri = this.resourceUri("node");
        DavResource resource = (DavResource)this.sardine.getResources(nodeUri).get(0);
        Map customProperties = resource.getCustomProps();
        Assert.assertTrue((!customProperties.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"value", customProperties.get("single-value-prop"));
    }

    private String testFolder() {
        return "testDirectory" + UUID.randomUUID().toString();
    }

    protected String getDefaultWorkspaceName() {
        return "default";
    }

    protected String getServerContext() {
        return SERVER_CONTEXT;
    }

    protected String getRepositoryName() {
        return REPOSITORY_NAME;
    }

    protected String resourceUri(String resourceName) {
        String rootUrl = this.getJcrServerUrl(this.getDefaultWorkspaceName());
        return !StringUtil.isBlank((String)resourceName) ? rootUrl + "/" + resourceName : rootUrl;
    }

    private String getJcrServerUrl(String workspaceName) {
        String serverContext = this.getServerContext();
        Assert.assertNotNull((Object)serverContext);
        String repositoryName = this.getRepositoryName();
        Assert.assertNotNull((Object)repositoryName);
        String baseUrl = serverContext + "/" + repositoryName;
        return workspaceName != null ? baseUrl + "/" + workspaceName : baseUrl;
    }
}

