/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import org.mvel2.MVEL;
import org.mvel2.tests.core.AbstractTest;

public class LiteralParsingTests
extends AbstractTest {
    public void testClassLiteral() {
        LiteralParsingTests.assertEquals(String.class, (Object)this.test("java.lang.String"));
    }

    public void testAndOpLiteral() {
        LiteralParsingTests.assertEquals((Object)true, (Object)this.test("true && true"));
    }

    public void testLiteralUnionWithComparison() {
        LiteralParsingTests.assertEquals((Object)Boolean.TRUE, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"1 == 1 && ('Hello'.toUpperCase() ~= '[A-Z]{0,5}')")));
    }

    public void testHexCharacter() {
        LiteralParsingTests.assertEquals((Object)10, (Object)MVEL.eval((String)"0x0A"));
    }

    public void testOctalEscapes() {
        LiteralParsingTests.assertEquals((Object)"\u00e4", (Object)MVEL.eval((String)"'\\344'"));
    }

    public void testOctalEscapes2() {
        LiteralParsingTests.assertEquals((Object)"\u0007", (Object)MVEL.eval((String)"'\\7'"));
    }

    public void testOctalEscapes3() {
        LiteralParsingTests.assertEquals((Object)"?7", (Object)MVEL.eval((String)"'\\777'"));
    }

    public void testUniHex1() {
        LiteralParsingTests.assertEquals((Object)"\uffff::", (Object)MVEL.eval((String)"'\\uFFFF::'"));
    }

    public void testNumLiterals() {
        LiteralParsingTests.assertEquals((Object)Float.valueOf(10.0f), (Object)MVEL.eval((String)"1e1f"));
    }

    public void testNumLiterals2() {
        LiteralParsingTests.assertEquals((Object)Float.valueOf(2.0f), (Object)MVEL.eval((String)"2.f"));
    }

    public void testNumLiterals3() {
        LiteralParsingTests.assertEquals((Object)Float.valueOf(0.3f), (Object)MVEL.eval((String)".3f"));
    }

    public void testNumLiterals4() {
        LiteralParsingTests.assertEquals((Object)Float.valueOf(3.14f), (Object)MVEL.eval((String)"3.14f"));
    }

    public void testNumLiterals5() {
        LiteralParsingTests.assertEquals((Object)10.0, (Object)MVEL.eval((String)"1e1"));
    }

    public void testNumLiterals6() {
        LiteralParsingTests.assertEquals((Object)2.0, (Object)MVEL.eval((String)"2."));
    }

    public void testNumLiterals7() {
        LiteralParsingTests.assertEquals((Object)0.3, (Object)MVEL.eval((String)".3"));
    }

    public void testNumLiterals8() {
        LiteralParsingTests.assertEquals((Object)1.0E-9, (Object)MVEL.eval((String)"1e-9d"));
    }

    public void testNumLiterals9() {
        LiteralParsingTests.assertEquals((Object)4614256656552045848L, (Object)MVEL.eval((String)"0x400921FB54442D18L"));
    }
}

