/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.fuzz;

import org.mvel2.MVEL;
import org.mvel2.util.ParseTools;

public class IdentifierFuzzer {
    public static void main(String[] args) {
        try {
            for (int i = 0; i < 1000000; ++i) {
                MVEL.compileExpression((char[])IdentifierFuzzer.getIndentifierSample());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("**Done**");
    }

    private static char[] getIndentifierSample() {
        char candidate;
        int idLength = (int)(10.0 * Math.random()) + 2;
        char[] sample = new char[idLength + 5];
        boolean ok = false;
        while (!ok) {
            candidate = (char)(128.0 * Math.random());
            if (!Character.isJavaIdentifierStart(candidate)) continue;
            sample[0] = candidate;
            ok = true;
        }
        for (int i = 1; i < idLength; ++i) {
            ok = false;
            while (!ok) {
                candidate = (char)(128.0 * Math.random());
                if (!Character.isJavaIdentifierPart(candidate)) continue;
                sample[i] = candidate;
                ok = true;
            }
        }
        if (ParseTools.isReservedWord((String)new String(sample, 0, idLength).trim())) {
            return IdentifierFuzzer.getIndentifierSample();
        }
        sample[idLength] = 32;
        sample[idLength + 1] = 61;
        sample[idLength + 2] = 32;
        sample[idLength + 3] = 49;
        sample[idLength + 4] = 59;
        return sample;
    }
}

