/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http;

import org.noear.solon.Utils;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.net.http.HttpTimeout;
import org.noear.solon.net.http.HttpUtils;
import org.noear.solon.net.http.LoadBalanceUtils;

public class HttpUtilsBuilder {
    private String baseUri;
    private String group;
    private String service;
    private MultiMap<String> headers = new MultiMap();
    private HttpTimeout timeout;

    public HttpUtilsBuilder service(String service) {
        this.service = service;
        return this;
    }

    public HttpUtilsBuilder service(String group, String service) {
        this.group = group;
        this.service = service;
        return this;
    }

    public HttpUtilsBuilder baseUri(String baseUri) {
        this.baseUri = baseUri;
        return this;
    }

    public HttpUtilsBuilder headerAdd(String key, String value) {
        this.headers.add(key, (Object)value);
        return this;
    }

    public HttpUtilsBuilder headerSet(String key, String value) {
        this.headers.put(key, (Object)value);
        return this;
    }

    public HttpUtilsBuilder timeout(int timeoutSeconds) {
        return this.timeout(HttpTimeout.of(timeoutSeconds));
    }

    public HttpUtilsBuilder timeout(int connectTimeoutSeconds, int writeTimeoutSeconds, int readTimeoutSeconds) {
        return this.timeout(HttpTimeout.of(connectTimeoutSeconds, writeTimeoutSeconds, readTimeoutSeconds));
    }

    public HttpUtilsBuilder timeout(HttpTimeout timeout) {
        this.timeout = timeout;
        return this;
    }

    public HttpUtils build(String url) {
        if (Utils.isNotEmpty((String)this.service)) {
            this.baseUri = LoadBalanceUtils.getServer(this.group, this.service);
        }
        if (Utils.isNotEmpty((String)this.baseUri)) {
            return HttpUtils.http(this.baseUri + url).headers((Iterable<KeyValues<String>>)this.headers).timeout(this.timeout);
        }
        return HttpUtils.http(url).headers((Iterable<KeyValues<String>>)this.headers).timeout(this.timeout);
    }
}

