/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.weed.WeedConfig;
import org.noear.weed.dialect.DbClickHouseDialect;
import org.noear.weed.dialect.DbDb2Dialect;
import org.noear.weed.dialect.DbDialect;
import org.noear.weed.dialect.DbH2Dialect;
import org.noear.weed.dialect.DbMySQLDialect;
import org.noear.weed.dialect.DbOracleDialect;
import org.noear.weed.dialect.DbPhoenixDialect;
import org.noear.weed.dialect.DbPostgreSQLDialect;
import org.noear.weed.dialect.DbPrestoDialect;
import org.noear.weed.dialect.DbSQLServerDialect;
import org.noear.weed.dialect.DbSQLiteDialect;
import org.noear.weed.wrap.ColumnWrap;
import org.noear.weed.wrap.DbType;
import org.noear.weed.wrap.TableWrap;

public class DbContextMetaData
implements Closeable {
    private String schema;
    private String catalog;
    private String productName;
    private String productVersion;
    private String url;
    private transient Map<String, TableWrap> tableAll = new HashMap<String, TableWrap>();
    private transient DbType type = DbType.Unknown;
    private transient DbDialect dialect;
    private transient DataSource dataSource;

    public String getUrl() {
        return this.url;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public Connection getConnection() throws SQLException {
        return WeedConfig.connectionFactory.getConnection(this.getDataSource());
    }

    public Connection getMetaConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    public String getSchema() {
        return this.schema;
    }

    protected void setSchema(String schema) {
        this.schema = schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public DbType getType() {
        this.init();
        return this.type;
    }

    public DbDialect getDialect() {
        this.init();
        return this.dialect;
    }

    public void setDialect(DbDialect adapter) {
        this.init();
        this.dialect = adapter;
    }

    public Collection<TableWrap> getTableAll() {
        this.init();
        return this.tableAll.values();
    }

    public TableWrap getTable(String tableName) {
        this.init();
        for (Map.Entry<String, TableWrap> kv : this.tableAll.entrySet()) {
            if (!tableName.equalsIgnoreCase(kv.getKey())) continue;
            return kv.getValue();
        }
        return null;
    }

    public String getTablePk1(String tableName) {
        TableWrap tw = this.getTable(tableName);
        return tw == null ? null : tw.getPk1();
    }

    public synchronized void refresh() {
        this.initDo();
    }

    public synchronized void init() {
        if (this.dialect != null) {
            return;
        }
        this.initDo();
    }

    private void initPrintln(String x) {
        if (this.schema == null) {
            System.out.println("[Weed] Init: " + x);
        } else {
            System.out.println("[Weed] Init: " + x + " - " + this.schema);
        }
    }

    private void initDo() {
        this.initPrintln("Init metadata");
        Connection conn = null;
        try {
            this.initPrintln("Start testing database connectivity...");
            conn = this.getMetaConnection();
            DatabaseMetaData md = conn.getMetaData();
            this.url = md.getURL();
            this.productName = md.getDatabaseProductName();
            this.productVersion = md.getDatabaseProductVersion();
            if (this.dialect == null) {
                this.setDatabaseType(this.url);
                this.setSchema(conn);
            }
            this.initPrintln("The connection is successful");
            this.setTables(md);
        }
        catch (Throwable ex) {
            this.initPrintln("The connection error");
            ex.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void setDatabaseType(String jdbcUrl) {
        if (jdbcUrl != null) {
            String pn = jdbcUrl.toLowerCase().replace(" ", "");
            if (pn.startsWith("jdbc:mysql:")) {
                this.type = DbType.MySQL;
                this.dialect = new DbMySQLDialect();
            } else if (pn.startsWith("jdbc:mariadb:")) {
                this.type = DbType.MariaDB;
                this.dialect = new DbMySQLDialect();
            } else if (pn.startsWith("jdbc:sqlserver:")) {
                this.type = DbType.SQLServer;
                this.dialect = new DbSQLServerDialect();
            } else if (pn.startsWith("jdbc:oracle:")) {
                this.type = DbType.Oracle;
                this.dialect = new DbOracleDialect();
            } else if (pn.startsWith("jdbc:postgresql:")) {
                this.type = DbType.PostgreSQL;
                this.dialect = new DbPostgreSQLDialect();
            } else if (pn.startsWith("jdbc:db2:")) {
                this.type = DbType.DB2;
                this.dialect = new DbDb2Dialect();
            } else if (pn.startsWith("jdbc:sqlite:")) {
                this.type = DbType.SQLite;
                this.dialect = new DbSQLiteDialect();
            } else if (pn.startsWith("jdbc:h2:")) {
                this.type = DbType.H2;
                this.dialect = new DbH2Dialect();
            } else if (pn.startsWith("jdbc:phoenix:")) {
                this.type = DbType.Phoenix;
                this.dialect = new DbPhoenixDialect();
            } else if (pn.startsWith("jdbc:clickhouse:")) {
                this.type = DbType.ClickHouse;
                this.dialect = new DbClickHouseDialect();
            } else if (pn.startsWith("jdbc:presto:")) {
                this.type = DbType.Presto;
                this.dialect = new DbPrestoDialect();
            } else {
                this.dialect = new DbMySQLDialect();
            }
        } else {
            this.type = DbType.MySQL;
            this.dialect = new DbMySQLDialect();
        }
    }

    private void setSchema(Connection conn) throws SQLException {
        try {
            this.catalog = conn.getCatalog();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this.schema != null) {
            return;
        }
        try {
            this.schema = conn.getSchema();
            if (this.schema == null) {
                this.schema = this.catalog;
            }
        }
        catch (Throwable e) {
            switch (this.type) {
                case PostgreSQL: {
                    this.schema = "public";
                    break;
                }
                case H2: {
                    this.schema = "PUBLIC";
                    break;
                }
                case SQLServer: {
                    this.schema = "dbo";
                }
                case Oracle: {
                    this.schema = conn.getMetaData().getUserName();
                }
            }
        }
    }

    private void setTables(DatabaseMetaData md) throws SQLException {
        TableWrap tWrap;
        ResultSet rs = null;
        rs = this.getDialect().getTables(md, this.catalog, this.schema);
        while (rs.next()) {
            String name = rs.getString("TABLE_NAME");
            String remarks = rs.getString("REMARKS");
            tWrap = new TableWrap(name, remarks);
            this.tableAll.put(name, tWrap);
        }
        rs.close();
        for (String key : this.tableAll.keySet()) {
            tWrap = this.tableAll.get(key);
            rs = md.getColumns(this.catalog, this.schema, key, "%");
            while (rs.next()) {
                int digit = 0;
                Object o = rs.getObject("DECIMAL_DIGITS");
                if (o != null) {
                    digit = ((Number)o).intValue();
                }
                ColumnWrap cw = new ColumnWrap(rs.getString("COLUMN_NAME"), rs.getInt("DATA_TYPE"), rs.getInt("COLUMN_SIZE"), digit, rs.getString("IS_NULLABLE"), rs.getString("REMARKS"));
                tWrap.addColumn(cw);
            }
            rs.close();
            rs = md.getPrimaryKeys(this.catalog, this.schema, key);
            while (rs.next()) {
                String idName = rs.getString("COLUMN_NAME");
                tWrap.addPk(idName);
            }
            rs.close();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.dataSource != null && this.dataSource instanceof Closeable) {
            ((Closeable)((Object)this.dataSource)).close();
        }
    }
}

