/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.wrap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.noear.weed.DataItem;
import org.noear.weed.WeedConfig;
import org.noear.weed.annotation.Table;
import org.noear.weed.ext.Act2;
import org.noear.weed.utils.ThrowableUtils;
import org.noear.weed.wrap.FieldWrap;

public class ClassWrap {
    private static Map<Class<?>, ClassWrap> _cache = new ConcurrentHashMap();
    public final Class<?> clazz;
    public final List<FieldWrap> fieldWraps;
    public final String tableName;
    private final Map<String, FieldWrap> _fieldWrapMap = new HashMap<String, FieldWrap>();
    private boolean _recordable;
    private Constructor _recordConstructor;
    private Parameter[] _recordParams;

    public static ClassWrap get(Class<?> clz) {
        ClassWrap clzWrap = _cache.get(clz);
        if (clzWrap == null) {
            clzWrap = new ClassWrap(clz);
            _cache.put(clz, clzWrap);
        }
        return clzWrap;
    }

    protected ClassWrap(Class<?> clz) {
        this.clazz = clz;
        this.fieldWraps = new ArrayList<FieldWrap>();
        this._recordable = true;
        this.scanAllFields(clz, this._fieldWrapMap::containsKey, (k, fw) -> {
            this.fieldWraps.add((FieldWrap)fw);
            this._fieldWrapMap.put(k.toLowerCase(), (FieldWrap)fw);
        });
        Table ann = clz.getAnnotation(Table.class);
        this.tableName = ann != null ? ann.value() : WeedConfig.namingStrategy.classToTableName(clz);
        if (this.fieldWraps.size() == 0) {
            this._recordable = false;
        }
        if (this._recordable) {
            this._recordConstructor = clz.getConstructors()[0];
            this._recordParams = this._recordConstructor.getParameters();
        }
    }

    public boolean recordable() {
        return this._recordable;
    }

    public Constructor recordConstructor() {
        return this._recordConstructor;
    }

    public Parameter[] recordParams() {
        return this._recordParams;
    }

    private void scanAllFields(Class<?> clz, Predicate<String> checker, BiConsumer<String, FieldWrap> consumer) {
        if (clz == null) {
            return;
        }
        for (Field f : clz.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) || checker.test(f.getName())) continue;
            FieldWrap fw = new FieldWrap(clz, f, Modifier.isFinal(mod));
            this._recordable &= Modifier.isFinal(mod);
            consumer.accept(f.getName(), fw);
        }
        Class<?> sup = clz.getSuperclass();
        if (sup != Object.class) {
            this.scanAllFields(sup, checker, consumer);
        }
    }

    public FieldWrap getFieldWrap(String name) {
        return this._fieldWrapMap.get(name.toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassWrap classWrap = (ClassWrap)o;
        return Objects.equals(this.clazz, classWrap.clazz);
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public <T> T newInstance() {
        try {
            return (T)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T> T toEntity(DataItem data) {
        try {
            if (this.recordable()) {
                Parameter[] argsP = this.recordParams();
                Object[] argsV = new Object[this.recordParams().length];
                for (int i = 0; i < argsP.length; ++i) {
                    Parameter p = argsP[i];
                    if (data.exists(p.getName())) {
                        Object val = data.get(p.getName());
                        if (val != null) {
                            val = WeedConfig.typeConverter.convert(val, p.getType());
                        }
                        argsV[i] = val;
                        continue;
                    }
                    argsV[i] = null;
                }
                Object item = this.recordConstructor().newInstance(argsV);
                return item;
            }
            Object item = this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (FieldWrap fw : this.fieldWraps) {
                if (!data.exists(fw.name)) continue;
                fw.setValue(item, data.get(fw.name));
            }
            return (T)item;
        }
        catch (Throwable ex) {
            ex = ThrowableUtils.throwableUnwrap(ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public void fromEntity(Object obj, Act2<String, Object> setter) {
        try {
            for (FieldWrap fw : this.fieldWraps) {
                if (fw.exclude) continue;
                setter.run(fw.name, fw.getValue(obj));
            }
        }
        catch (Throwable ex) {
            ex = ThrowableUtils.throwableUnwrap(ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }
}

