/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;

@JsonIgnoreType
public class RelocatedDependencyReport
extends DataTable<Row> {
    public RelocatedDependencyReport(Recipe recipe) {
        super(recipe, "Relocated dependencies", "A list of dependencies in use that have relocated.");
    }

    public static final class Row {
        @Column(displayName="Dependency group id", description="The Group ID of the dependency in use.")
        private final String dependencyGroupId;
        @Column(displayName="Dependency artifact id", description="The Artifact ID of the dependency in use.")
        private final @Nullable String dependencyArtifactId;
        @Column(displayName="Relocated dependency group id", description="The Group ID of the relocated dependency.")
        private final String relocatedGroupId;
        @Column(displayName="Relocated ependency artifact id", description="The Artifact ID of the relocated dependency.")
        private final @Nullable String relocatedArtifactId;
        @Column(displayName="Context", description="Context for the relocation, if any.")
        private final @Nullable String context;

        @ConstructorProperties(value={"dependencyGroupId", "dependencyArtifactId", "relocatedGroupId", "relocatedArtifactId", "context"})
        @Generated
        public Row(String dependencyGroupId, @Nullable String dependencyArtifactId, String relocatedGroupId, @Nullable String relocatedArtifactId, @Nullable String context) {
            this.dependencyGroupId = dependencyGroupId;
            this.dependencyArtifactId = dependencyArtifactId;
            this.relocatedGroupId = relocatedGroupId;
            this.relocatedArtifactId = relocatedArtifactId;
            this.context = context;
        }

        @Generated
        public String getDependencyGroupId() {
            return this.dependencyGroupId;
        }

        @Generated
        public @Nullable String getDependencyArtifactId() {
            return this.dependencyArtifactId;
        }

        @Generated
        public String getRelocatedGroupId() {
            return this.relocatedGroupId;
        }

        @Generated
        public @Nullable String getRelocatedArtifactId() {
            return this.relocatedArtifactId;
        }

        @Generated
        public @Nullable String getContext() {
            return this.context;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$dependencyGroupId = this.getDependencyGroupId();
            String other$dependencyGroupId = other.getDependencyGroupId();
            if (this$dependencyGroupId == null ? other$dependencyGroupId != null : !this$dependencyGroupId.equals(other$dependencyGroupId)) {
                return false;
            }
            String this$dependencyArtifactId = this.getDependencyArtifactId();
            String other$dependencyArtifactId = other.getDependencyArtifactId();
            if (this$dependencyArtifactId == null ? other$dependencyArtifactId != null : !this$dependencyArtifactId.equals(other$dependencyArtifactId)) {
                return false;
            }
            String this$relocatedGroupId = this.getRelocatedGroupId();
            String other$relocatedGroupId = other.getRelocatedGroupId();
            if (this$relocatedGroupId == null ? other$relocatedGroupId != null : !this$relocatedGroupId.equals(other$relocatedGroupId)) {
                return false;
            }
            String this$relocatedArtifactId = this.getRelocatedArtifactId();
            String other$relocatedArtifactId = other.getRelocatedArtifactId();
            if (this$relocatedArtifactId == null ? other$relocatedArtifactId != null : !this$relocatedArtifactId.equals(other$relocatedArtifactId)) {
                return false;
            }
            String this$context = this.getContext();
            String other$context = other.getContext();
            return !(this$context == null ? other$context != null : !this$context.equals(other$context));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dependencyGroupId = this.getDependencyGroupId();
            result = result * 59 + ($dependencyGroupId == null ? 43 : $dependencyGroupId.hashCode());
            String $dependencyArtifactId = this.getDependencyArtifactId();
            result = result * 59 + ($dependencyArtifactId == null ? 43 : $dependencyArtifactId.hashCode());
            String $relocatedGroupId = this.getRelocatedGroupId();
            result = result * 59 + ($relocatedGroupId == null ? 43 : $relocatedGroupId.hashCode());
            String $relocatedArtifactId = this.getRelocatedArtifactId();
            result = result * 59 + ($relocatedArtifactId == null ? 43 : $relocatedArtifactId.hashCode());
            String $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : $context.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RelocatedDependencyReport.Row(dependencyGroupId=" + this.getDependencyGroupId() + ", dependencyArtifactId=" + this.getDependencyArtifactId() + ", relocatedGroupId=" + this.getRelocatedGroupId() + ", relocatedArtifactId=" + this.getRelocatedArtifactId() + ", context=" + this.getContext() + ")";
        }
    }
}

