/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.isolated;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PatternTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.tree.YieldTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaParsingException;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.isolated.ReloadableJava17JavadocVisitor;
import org.openrewrite.java.isolated.ReloadableJava17ModifierResults;
import org.openrewrite.java.isolated.ReloadableJava17TypeMapping;
import org.openrewrite.java.marker.CompactConstructor;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.JavaVarKeyword;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.java.tree.VariableDeclarator;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;

public class ReloadableJava17ParserVisitor
extends TreePathScanner<J, Space> {
    private static final int SURR_FIRST = 55296;
    private static final int SURR_LAST = 57343;
    private static final Map<String, Modifier> MODIFIER_BY_KEYWORD = Stream.of(Modifier.values()).collect(Collectors.toUnmodifiableMap(Modifier::toString, Function.identity()));
    private final Path sourcePath;
    private final @Nullable FileAttributes fileAttributes;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private final Collection<NamedStyles> styles;
    private final ExecutionContext ctx;
    private final Context context;
    private final ReloadableJava17TypeMapping typeMapping;
    private EndPosTable endPosTable;
    private DocCommentTable docCommentTable;
    private int cursor = 0;
    private static final Pattern whitespaceSuffixPattern = Pattern.compile("\\s*[^\\s]+(\\s*)");
    private final Function<com.sun.source.tree.Tree, Space> semiDelim = __ -> {
        Space prefix = this.whitespace();
        this.skip(";");
        return prefix;
    };
    private final Function<com.sun.source.tree.Tree, Space> commaDelim = __ -> {
        Space prefix = this.whitespace();
        this.skip(",");
        return prefix;
    };
    private final Function<com.sun.source.tree.Tree, Space> noDelim = __ -> Space.EMPTY;

    public ReloadableJava17ParserVisitor(Path sourcePath, @Nullable FileAttributes fileAttributes, EncodingDetectingInputStream source, Collection<NamedStyles> styles, JavaTypeCache typeCache, ExecutionContext ctx, Context context) {
        this.sourcePath = sourcePath;
        this.fileAttributes = fileAttributes;
        this.source = source.readFully();
        this.charset = source.getCharset();
        this.charsetBomMarked = source.isCharsetBomMarked();
        this.styles = styles;
        this.ctx = ctx;
        this.context = context;
        this.typeMapping = new ReloadableJava17TypeMapping(typeCache);
    }

    @Override
    public J visitAnnotation(AnnotationTree node, Space fmt) {
        this.skip("@");
        NameTree name = (NameTree)this.convert(node.getAnnotationType());
        JContainer args = null;
        if (!node.getArguments().isEmpty()) {
            ExpressionTree arg;
            Space argsPrefix = this.sourceBefore("(");
            java.util.List expressions = node.getArguments().size() == 1 ? ((arg = node.getArguments().get(0)) instanceof JCTree.JCAssign ? (this.endPos(arg) < 0 ? Collections.singletonList(this.convert(((JCTree.JCAssign)arg).rhs, t -> this.sourceBefore(")"))) : Collections.singletonList(this.convert(arg, t -> this.sourceBefore(")")))) : Collections.singletonList(this.convert(arg, t -> this.sourceBefore(")")))) : this.convertAll(node.getArguments(), this.commaDelim, t -> this.sourceBefore(")"));
            args = JContainer.build((Space)argsPrefix, expressions, (Markers)Markers.EMPTY);
        } else {
            int saveCursor = this.cursor;
            Space prefix = this.whitespace();
            if (this.source.charAt(this.cursor) == '(') {
                this.skip("(");
                args = JContainer.build((Space)prefix, Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY);
            } else {
                this.cursor = saveCursor;
            }
        }
        return new J.Annotation(Tree.randomId(), fmt, Markers.EMPTY, name, args);
    }

    @Override
    public J visitArrayAccess(ArrayAccessTree node, Space fmt) {
        return new J.ArrayAccess(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.convert(node.getExpression()), new J.ArrayDimension(Tree.randomId(), this.sourceBefore("["), Markers.EMPTY, this.convert(node.getIndex(), t -> this.sourceBefore("]"))), this.typeMapping.type(node));
    }

    @Override
    public J visitArrayType(ArrayTypeTree node, Space fmt) {
        return this.arrayTypeTree(node, new HashMap<Integer, JCTree.JCAnnotation>()).withPrefix(fmt);
    }

    @Override
    public J visitAssert(AssertTree node, Space fmt) {
        this.skip("assert");
        JCTree.JCAssert jcAssert = (JCTree.JCAssert)node;
        return new J.Assert(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.convert(jcAssert.cond), jcAssert.detail == null ? null : this.padLeft(this.sourceBefore(":"), (Expression)this.convert(jcAssert.detail)));
    }

    @Override
    public J visitAssignment(AssignmentTree node, Space fmt) {
        return new J.Assignment(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.convert(node.getVariable()), this.padLeft(this.sourceBefore("="), (Expression)this.convert(node.getExpression())), this.typeMapping.type(node));
    }

    @Override
    public J visitErroneous(ErroneousTree node, Space fmt) {
        String erroneousNode = this.source.substring(((JCTree)((Object)node)).getStartPosition(), ((JCTree)((Object)node)).getEndPosition(this.endPosTable));
        return new J.Erroneous(Tree.randomId(), fmt, Markers.EMPTY, erroneousNode);
    }

    @Override
    public J visitBinary(BinaryTree node, Space fmt) {
        Expression left = (Expression)this.convert(node.getLeftOperand());
        Space opPrefix = this.whitespace();
        return new J.Binary(Tree.randomId(), fmt, Markers.EMPTY, left, this.padLeft(opPrefix, switch (((JCTree.JCBinary)node).getTag()) {
            case JCTree.Tag.PLUS -> {
                this.skip("+");
                yield J.Binary.Type.Addition;
            }
            case JCTree.Tag.MINUS -> {
                this.skip("-");
                yield J.Binary.Type.Subtraction;
            }
            case JCTree.Tag.DIV -> {
                this.skip("/");
                yield J.Binary.Type.Division;
            }
            case JCTree.Tag.MUL -> {
                this.skip("*");
                yield J.Binary.Type.Multiplication;
            }
            case JCTree.Tag.MOD -> {
                this.skip("%");
                yield J.Binary.Type.Modulo;
            }
            case JCTree.Tag.AND -> {
                this.skip("&&");
                yield J.Binary.Type.And;
            }
            case JCTree.Tag.OR -> {
                this.skip("||");
                yield J.Binary.Type.Or;
            }
            case JCTree.Tag.BITAND -> {
                this.skip("&");
                yield J.Binary.Type.BitAnd;
            }
            case JCTree.Tag.BITOR -> {
                this.skip("|");
                yield J.Binary.Type.BitOr;
            }
            case JCTree.Tag.BITXOR -> {
                this.skip("^");
                yield J.Binary.Type.BitXor;
            }
            case JCTree.Tag.SL -> {
                this.skip("<<");
                yield J.Binary.Type.LeftShift;
            }
            case JCTree.Tag.SR -> {
                this.skip(">>");
                yield J.Binary.Type.RightShift;
            }
            case JCTree.Tag.USR -> {
                this.skip(">>>");
                yield J.Binary.Type.UnsignedRightShift;
            }
            case JCTree.Tag.LT -> {
                this.skip("<");
                yield J.Binary.Type.LessThan;
            }
            case JCTree.Tag.GT -> {
                this.skip(">");
                yield J.Binary.Type.GreaterThan;
            }
            case JCTree.Tag.LE -> {
                this.skip("<=");
                yield J.Binary.Type.LessThanOrEqual;
            }
            case JCTree.Tag.GE -> {
                this.skip(">=");
                yield J.Binary.Type.GreaterThanOrEqual;
            }
            case JCTree.Tag.EQ -> {
                this.skip("==");
                yield J.Binary.Type.Equal;
            }
            case JCTree.Tag.NE -> {
                this.skip("!=");
                yield J.Binary.Type.NotEqual;
            }
            default -> throw new IllegalArgumentException("Unexpected binary tag " + String.valueOf((Object)((JCTree.JCBinary)node).getTag()));
        }), (Expression)this.convert(node.getRightOperand()), this.typeMapping.type(node));
    }

    @Override
    public J visitBlock(BlockTree node, Space fmt) {
        JRightPadded stat;
        if ((((JCTree.JCBlock)node).flags & 8L) != 0L) {
            this.skip("static");
            stat = new JRightPadded((Object)true, this.sourceBefore("{"), Markers.EMPTY);
        } else {
            this.skip("{");
            stat = new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY);
        }
        ArrayList<StatementTree> statementTrees = new ArrayList<StatementTree>(node.getStatements().size());
        for (StatementTree statementTree : node.getStatements()) {
            if (this.endPos(statementTree) <= 0) continue;
            statementTrees.add(statementTree);
        }
        return new J.Block(Tree.randomId(), fmt, Markers.EMPTY, stat, this.convertStatements(statementTrees), this.sourceBefore("}"));
    }

    @Override
    public J visitBreak(BreakTree node, Space fmt) {
        this.skip("break");
        J.Identifier label = node.getLabel() == null ? null : new J.Identifier(Tree.randomId(), this.sourceBefore(node.getLabel().toString()), Markers.EMPTY, Collections.emptyList(), node.getLabel().toString(), null, null);
        return new J.Break(Tree.randomId(), fmt, Markers.EMPTY, label);
    }

    @Override
    public J visitCase(CaseTree node, Space fmt) {
        J.Case.Type type = node.getCaseKind() == CaseTree.CaseKind.RULE ? J.Case.Type.Rule : J.Case.Type.Statement;
        return new J.Case(Tree.randomId(), fmt, Markers.EMPTY, type, null, JContainer.build((Space)(node.getExpressions().isEmpty() ? Space.EMPTY : this.sourceBefore("case")), node.getExpressions().isEmpty() ? java.util.List.of(JRightPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), this.skip("default"), null, null))) : this.convertAll(node.getExpressions(), this.commaDelim, t -> Space.EMPTY), (Markers)Markers.EMPTY), null, null, JContainer.build((Space)this.sourceBefore(type == J.Case.Type.Rule ? "->" : ":"), this.convertStatements(node.getStatements()), (Markers)Markers.EMPTY), type == J.Case.Type.Rule ? this.padRight(this.convert(node.getBody()), this.statementDelim(node.getBody())) : null);
    }

    @Override
    public J visitYield(YieldTree node, Space fmt) {
        boolean implicit;
        boolean bl = implicit = !this.source.startsWith("yield", this.cursor);
        if (!implicit) {
            this.skip("yield");
        }
        return new J.Yield(Tree.randomId(), fmt, Markers.EMPTY, implicit, (Expression)this.convert(node.getValue()));
    }

    @Override
    public J visitCatch(CatchTree node, Space fmt) {
        this.skip("catch");
        Space paramPrefix = this.sourceBefore("(");
        J.VariableDeclarations paramDecl = (J.VariableDeclarations)this.convert(node.getParameter());
        J.ControlParentheses param = new J.ControlParentheses(Tree.randomId(), paramPrefix, Markers.EMPTY, this.padRight(paramDecl, this.sourceBefore(")")));
        return new J.Try.Catch(Tree.randomId(), fmt, Markers.EMPTY, param, (J.Block)this.convert(node.getBlock()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public J visitClass(ClassTree node, Space fmt) {
        void var15_20;
        Map<Integer, JCTree.JCAnnotation> annotationPosTable = this.mapAnnotations(node.getModifiers().getAnnotations(), new HashMap<Integer, JCTree.JCAnnotation>(node.getModifiers().getAnnotations().size()));
        ReloadableJava17ModifierResults modifierResults = this.sortedModifiersAndAnnotations(node.getModifiers(), annotationPosTable);
        java.util.List<J.Annotation> kindAnnotations = this.collectAnnotations(annotationPosTable);
        J.ClassDeclaration.Kind kind = this.hasFlag(node.getModifiers(), 16384L) ? new J.ClassDeclaration.Kind(Tree.randomId(), this.sourceBefore("enum"), Markers.EMPTY, kindAnnotations, J.ClassDeclaration.Kind.Type.Enum) : (this.hasFlag(node.getModifiers(), 8192L) ? new J.ClassDeclaration.Kind(Tree.randomId(), this.sourceBefore("@interface"), Markers.EMPTY, kindAnnotations, J.ClassDeclaration.Kind.Type.Annotation) : (this.hasFlag(node.getModifiers(), 512L) ? new J.ClassDeclaration.Kind(Tree.randomId(), this.sourceBefore("interface"), Markers.EMPTY, kindAnnotations, J.ClassDeclaration.Kind.Type.Interface) : (this.hasFlag(node.getModifiers(), 0x2000000000000000L) ? new J.ClassDeclaration.Kind(Tree.randomId(), this.sourceBefore("record"), Markers.EMPTY, kindAnnotations, J.ClassDeclaration.Kind.Type.Record) : new J.ClassDeclaration.Kind(Tree.randomId(), this.sourceBefore("class"), Markers.EMPTY, kindAnnotations, J.ClassDeclaration.Kind.Type.Class))));
        J.Identifier name = new J.Identifier(Tree.randomId(), this.sourceBefore(node.getSimpleName().toString()), Markers.EMPTY, Collections.emptyList(), ((JCTree.JCClassDecl)node).getSimpleName().toString(), this.typeMapping.type(node), null);
        JContainer typeParams = node.getTypeParameters().isEmpty() ? null : JContainer.build((Space)this.sourceBefore("<"), this.convertAll(node.getTypeParameters(), this.commaDelim, t -> this.sourceBefore(">")), (Markers)Markers.EMPTY);
        JContainer primaryConstructor = null;
        if (kind.getType() == J.ClassDeclaration.Kind.Type.Record) {
            HashMap<String, java.util.List<J.Annotation>> recordParams = new HashMap<String, java.util.List<J.Annotation>>();
            Space prefix = this.sourceBefore("(");
            HashMap<Name, Map<Integer, JCTree.JCAnnotation>> recordAnnotationPosTable = new HashMap<Name, Map<Integer, JCTree.JCAnnotation>>();
            ArrayList<JRightPadded> varDecls = new ArrayList<JRightPadded>();
            for (com.sun.source.tree.Tree tree : node.getMembers()) {
                VariableTree variableTree;
                JCTree.JCMethodDecl jCMethodDecl;
                if (tree instanceof JCTree.JCMethodDecl && this.hasFlag((jCMethodDecl = (JCTree.JCMethodDecl)tree).getModifiers(), 0x2000000000000000L) && "<init>".equals(jCMethodDecl.getName().toString())) {
                    for (JCTree.JCVariableDecl jCVariableDecl : jCMethodDecl.getParameters()) {
                        recordAnnotationPosTable.put(jCVariableDecl.getName(), this.mapAnnotations(jCVariableDecl.getModifiers().getAnnotations(), new HashMap<Integer, JCTree.JCAnnotation>()));
                    }
                }
                if (!(tree instanceof VariableTree) || !this.hasFlag((variableTree = (VariableTree)tree).getModifiers(), 0x2000000000000000L)) continue;
                Space varDeclPrefix = this.whitespace();
                java.util.List<J.Annotation> list = this.collectAnnotations(this.mapAnnotations(variableTree.getModifiers().getAnnotations(), recordAnnotationPosTable.getOrDefault(variableTree.getName(), new HashMap())));
                Space typeExpressionPrefix = this.whitespace();
                JRightPadded varDecl2 = this.convert(variableTree, this.commaDelim).map(elem -> elem.withPrefix(varDeclPrefix).withTypeExpression((TypeTree)elem.getTypeExpression().withPrefix(typeExpressionPrefix)));
                recordParams.put(variableTree.getName().toString(), list);
                varDecls.add(varDecl2);
            }
            if (varDecls.isEmpty()) {
                primaryConstructor = JContainer.build((Space)prefix, Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY);
            } else {
                this.skip(")");
                primaryConstructor = JContainer.build((Space)prefix, (java.util.List)ListUtils.map(varDecls, varDecl -> varDecl.withElement((Object)((J.VariableDeclarations)varDecl.getElement()).withLeadingAnnotations((java.util.List)recordParams.get(((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)varDecl.getElement()).getVariables().get(0)).getSimpleName())))), (Markers)Markers.EMPTY);
            }
        }
        JLeftPadded<TypeTree> extendings = node.getExtendsClause() == null ? null : this.padLeft(this.sourceBefore("extends"), (TypeTree)this.convert(node.getExtendsClause()));
        JContainer implementings = null;
        if (node.getImplementsClause() != null && !node.getImplementsClause().isEmpty()) {
            Space implementsPrefix = this.sourceBefore(kind.getType() == J.ClassDeclaration.Kind.Type.Interface ? "extends" : "implements");
            implementings = JContainer.build((Space)implementsPrefix, this.convertAll(node.getImplementsClause(), this.commaDelim, this.noDelim), (Markers)Markers.EMPTY);
        }
        JContainer permitting = null;
        if (node.getPermitsClause() != null && !node.getPermitsClause().isEmpty()) {
            permitting = JContainer.build((Space)this.sourceBefore("permits"), this.convertAll(node.getPermitsClause(), this.commaDelim, this.noDelim), (Markers)Markers.EMPTY);
        }
        Space bodyPrefix = this.sourceBefore("{");
        ArrayList<com.sun.source.tree.Tree> jcEnums = new ArrayList<com.sun.source.tree.Tree>(node.getMembers().size());
        for (com.sun.source.tree.Tree tree : node.getMembers()) {
            if (!(tree instanceof JCTree.JCVariableDecl) || !this.hasFlag(((JCTree.JCVariableDecl)tree).getModifiers(), 16384L)) continue;
            jcEnums.add(tree);
        }
        Object var15_17 = null;
        if (!jcEnums.isEmpty()) {
            com.sun.source.tree.Tree tree = (com.sun.source.tree.Tree)jcEnums.get(jcEnums.size() - 1);
            java.util.List enumValues = this.convertAll(jcEnums, this.commaDelim, t -> {
                if (t != lastConstant) {
                    return this.whitespace();
                }
                int savedCursor = this.cursor;
                Space suffix = this.whitespace();
                if (this.source.charAt(this.cursor) == ',' || this.source.charAt(this.cursor) == ';') {
                    return suffix;
                }
                this.cursor = savedCursor;
                return Space.EMPTY;
            }, t -> {
                if (t == lastConstant && this.skip(",") != null) {
                    int savedCursor = this.cursor;
                    Space suffix = this.whitespace();
                    if (this.source.charAt(this.cursor) == ';') {
                        return Markers.build(Collections.singletonList(new TrailingComma(Tree.randomId(), suffix)));
                    }
                    this.cursor = savedCursor;
                    return Markers.build(Collections.singletonList(new TrailingComma(Tree.randomId(), Space.EMPTY)));
                }
                return Markers.EMPTY;
            });
            JRightPadded<J.EnumValueSet> jRightPadded = this.padRight(new J.EnumValueSet(Tree.randomId(), Space.EMPTY, Markers.EMPTY, enumValues, this.skip(";") != null), Space.EMPTY);
        } else if (kind.getType() == J.ClassDeclaration.Kind.Type.Enum) {
            int n = this.positionOfNext(";", null);
            int nextClosingBracePosition = this.positionOfNext("}", null);
            if (n >= 0 && n < nextClosingBracePosition) {
                JRightPadded<J.EnumValueSet> jRightPadded = this.padRight(new J.EnumValueSet(Tree.randomId(), this.sourceBefore(";"), Markers.EMPTY, Collections.emptyList(), true), Space.EMPTY);
            }
        }
        ArrayList<com.sun.source.tree.Tree> arrayList = new ArrayList<com.sun.source.tree.Tree>(node.getMembers().size());
        for (com.sun.source.tree.Tree tree : node.getMembers()) {
            JCTree.JCVariableDecl vt;
            JCTree.JCMethodDecl md;
            if (ReloadableJava17ParserVisitor.isLombokGenerated(tree) || tree instanceof JCTree.JCMethodDecl && (this.hasFlag((md = (JCTree.JCMethodDecl)tree).getModifiers(), 0x1000000000L) || this.hasFlag(md.getModifiers(), 0x2000000000000000L)) || tree instanceof JCTree.JCVariableDecl && (this.hasFlag((vt = (JCTree.JCVariableDecl)tree).getModifiers(), 16384L) || this.hasFlag(vt.getModifiers(), 0x2000000000000000L))) continue;
            arrayList.add(tree);
        }
        ArrayList<JRightPadded<Statement>> members = new ArrayList<JRightPadded<Statement>>(arrayList.size() + (var15_20 == null ? 0 : 1));
        if (var15_20 != null) {
            members.add((JRightPadded<Statement>)var15_20);
        }
        members.addAll(this.convertStatements(arrayList));
        this.addPossibleEmptyStatementsBeforeClosingBrace(members);
        J.Block block = new J.Block(Tree.randomId(), bodyPrefix, Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), members, this.sourceBefore("}"));
        return new J.ClassDeclaration(Tree.randomId(), fmt, Markers.EMPTY, modifierResults.getLeadingAnnotations(), modifierResults.getModifiers(), kind, name, typeParams, primaryConstructor, extendings, implementings, permitting, block, (JavaType.FullyQualified)this.typeMapping.type(node));
    }

    @Override
    public J visitCompilationUnit(CompilationUnitTree node, Space fmt) {
        JCTree.JCCompilationUnit cu = (JCTree.JCCompilationUnit)node;
        if (node.getTypeDecls().isEmpty() || cu.getPackageName() != null || !node.getImports().isEmpty()) {
            fmt = Space.format((String)this.source, (int)0, (int)cu.getStartPosition());
            this.cursor(cu.getStartPosition());
        }
        this.endPosTable = cu.endPositions;
        this.docCommentTable = cu.docComments;
        Map<Integer, JCTree.JCAnnotation> annotationPosTable = this.mapAnnotations(node.getPackageAnnotations(), new HashMap<Integer, JCTree.JCAnnotation>(node.getPackageAnnotations().size()));
        java.util.List<J.Annotation> packageAnnotations = this.collectAnnotations(annotationPosTable);
        J.Package packageDecl = null;
        if (cu.getPackageName() != null) {
            Space packagePrefix = this.sourceBefore("package");
            packageDecl = new J.Package(Tree.randomId(), packagePrefix, Markers.EMPTY, (Expression)this.convert(cu.getPackageName()), packageAnnotations);
        }
        return new J.CompilationUnit(Tree.randomId(), fmt, Markers.build(this.styles), this.sourcePath, this.fileAttributes, this.charset.name(), this.charsetBomMarked, null, packageDecl == null ? null : this.padRight(packageDecl, this.sourceBefore(";")), this.convertAll(node.getImports(), this::statementDelim, this::statementDelim), this.convertAll(node.getTypeDecls().stream().filter(JCTree.JCClassDecl.class::isInstance).collect(Collectors.toList())), Space.format((String)this.source, (int)this.cursor, (int)this.source.length()));
    }

    @Override
    public J visitCompoundAssignment(CompoundAssignmentTree node, Space fmt) {
        Expression left = (Expression)this.convert(((JCTree.JCAssignOp)node).lhs);
        Space opPrefix = this.whitespace();
        return new J.AssignmentOperation(Tree.randomId(), fmt, Markers.EMPTY, left, this.padLeft(opPrefix, switch (((JCTree.JCAssignOp)node).getTag()) {
            case JCTree.Tag.PLUS_ASG -> {
                this.skip("+=");
                yield J.AssignmentOperation.Type.Addition;
            }
            case JCTree.Tag.MINUS_ASG -> {
                this.skip("-=");
                yield J.AssignmentOperation.Type.Subtraction;
            }
            case JCTree.Tag.DIV_ASG -> {
                this.skip("/=");
                yield J.AssignmentOperation.Type.Division;
            }
            case JCTree.Tag.MUL_ASG -> {
                this.skip("*=");
                yield J.AssignmentOperation.Type.Multiplication;
            }
            case JCTree.Tag.MOD_ASG -> {
                this.skip("%=");
                yield J.AssignmentOperation.Type.Modulo;
            }
            case JCTree.Tag.BITAND_ASG -> {
                this.skip("&=");
                yield J.AssignmentOperation.Type.BitAnd;
            }
            case JCTree.Tag.BITOR_ASG -> {
                this.skip("|=");
                yield J.AssignmentOperation.Type.BitOr;
            }
            case JCTree.Tag.BITXOR_ASG -> {
                this.skip("^=");
                yield J.AssignmentOperation.Type.BitXor;
            }
            case JCTree.Tag.SL_ASG -> {
                this.skip("<<=");
                yield J.AssignmentOperation.Type.LeftShift;
            }
            case JCTree.Tag.SR_ASG -> {
                this.skip(">>=");
                yield J.AssignmentOperation.Type.RightShift;
            }
            case JCTree.Tag.USR_ASG -> {
                this.skip(">>>=");
                yield J.AssignmentOperation.Type.UnsignedRightShift;
            }
            default -> throw new IllegalArgumentException("Unexpected compound assignment tag " + String.valueOf((Object)((JCTree.JCAssignOp)node).getTag()));
        }), (Expression)this.convert(((JCTree.JCAssignOp)node).rhs), this.typeMapping.type(node));
    }

    @Override
    public J visitConditionalExpression(ConditionalExpressionTree node, Space fmt) {
        return new J.Ternary(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.convert(node.getCondition()), this.padLeft(this.sourceBefore("?"), (Expression)this.convert(node.getTrueExpression())), this.padLeft(this.sourceBefore(":"), (Expression)this.convert(node.getFalseExpression())), this.typeMapping.type(node));
    }

    @Override
    public J visitContinue(ContinueTree node, Space fmt) {
        this.skip("continue");
        javax.lang.model.element.Name label = node.getLabel();
        return new J.Continue(Tree.randomId(), fmt, Markers.EMPTY, label == null ? null : new J.Identifier(Tree.randomId(), this.sourceBefore(label.toString()), Markers.EMPTY, Collections.emptyList(), label.toString(), null, null));
    }

    @Override
    public J visitDoWhileLoop(DoWhileLoopTree node, Space fmt) {
        this.skip("do");
        return new J.DoWhileLoop(Tree.randomId(), fmt, Markers.EMPTY, this.convert(node.getStatement(), this::statementDelim), this.padLeft(this.sourceBefore("while"), (J.ControlParentheses)this.convert(node.getCondition())));
    }

    @Override
    public J visitEmptyStatement(EmptyStatementTree node, Space fmt) {
        return new J.Empty(Tree.randomId(), fmt, Markers.EMPTY);
    }

    @Override
    public J visitEnhancedForLoop(EnhancedForLoopTree node, Space fmt) {
        this.skip("for");
        return new J.ForEachLoop(Tree.randomId(), fmt, Markers.EMPTY, new J.ForEachLoop.Control(Tree.randomId(), this.sourceBefore("("), Markers.EMPTY, this.convert(node.getVariable(), t -> this.sourceBefore(":")), this.convert(node.getExpression(), t -> this.sourceBefore(")"))), this.convert(node.getStatement(), this::statementDelim));
    }

    private J visitEnumVariable(VariableTree node, Space fmt) {
        java.util.List<Object> annotations = Collections.emptyList();
        Space nameSpace = Space.EMPTY;
        if (!node.getModifiers().getAnnotations().isEmpty()) {
            annotations = this.convertAll(node.getModifiers().getAnnotations());
            nameSpace = this.sourceBefore(node.getName().toString());
        } else {
            this.skip(node.getName().toString());
        }
        J.Identifier name = new J.Identifier(Tree.randomId(), nameSpace, Markers.EMPTY, Collections.emptyList(), node.getName().toString(), this.typeMapping.type(node), null);
        J.NewClass initializer = null;
        if (this.source.charAt(this.endPos(node) - 1) == ')' || this.source.charAt(this.endPos(node) - 1) == '}') {
            initializer = (J.NewClass)this.convert(node.getInitializer());
        }
        return new J.EnumValue(Tree.randomId(), fmt, Markers.EMPTY, annotations, name, initializer);
    }

    @Override
    public J visitForLoop(ForLoopTree node, Space fmt) {
        java.util.List<Object> update;
        this.skip("for");
        Space ctrlPrefix = this.sourceBefore("(");
        java.util.List<JRightPadded<Statement>> init = node.getInitializer().isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(";"), Markers.EMPTY), Space.EMPTY)) : this.convertStatements(node.getInitializer(), t -> this.positionOfNext(",", Character.valueOf(';')) == -1 ? this.semiDelim.apply((com.sun.source.tree.Tree)t) : this.commaDelim.apply((com.sun.source.tree.Tree)t));
        Object condition = this.convert(node.getCondition(), this.semiDelim);
        if (condition == null) {
            condition = this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(";"), Markers.EMPTY), Space.EMPTY);
        }
        if (node.getUpdate().isEmpty()) {
            update = Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY));
        } else {
            java.util.List<? extends ExpressionStatementTree> nodeUpdate = node.getUpdate();
            update = new ArrayList(nodeUpdate.size());
            for (int i = 0; i < nodeUpdate.size(); ++i) {
                ExpressionStatementTree tree = nodeUpdate.get(i);
                update.add(this.convert(tree, i == nodeUpdate.size() - 1 ? t -> this.sourceBefore(")") : this.commaDelim));
            }
        }
        return new J.ForLoop(Tree.randomId(), fmt, Markers.EMPTY, new J.ForLoop.Control(Tree.randomId(), ctrlPrefix, Markers.EMPTY, init, condition, update), this.convert(node.getStatement(), this::statementDelim));
    }

    @Override
    public J visitIdentifier(IdentifierTree node, Space fmt) {
        String name = node.getName().toString();
        this.cursor += name.length();
        JCTree.JCIdent ident = (JCTree.JCIdent)node;
        JavaType type = ident.sym != null && ident.sym.isConstructor() ? null : this.typeMapping.type(ident);
        return new J.Identifier(Tree.randomId(), fmt, Markers.EMPTY, Collections.emptyList(), name, type, this.typeMapping.variableType(ident.sym));
    }

    @Override
    public J visitIf(IfTree node, Space fmt) {
        this.skip("if");
        return new J.If(Tree.randomId(), fmt, Markers.EMPTY, (J.ControlParentheses)this.convert(node.getCondition()), this.convert(node.getThenStatement(), this::statementDelim), node.getElseStatement() instanceof JCTree.JCStatement ? new J.If.Else(Tree.randomId(), this.sourceBefore("else"), Markers.EMPTY, this.convert(node.getElseStatement(), this::statementDelim)) : null);
    }

    @Override
    public J visitImport(ImportTree node, Space fmt) {
        this.skip("import");
        return new J.Import(Tree.randomId(), fmt, Markers.EMPTY, new JLeftPadded(node.isStatic() ? this.sourceBefore("static") : Space.EMPTY, (Object)node.isStatic(), Markers.EMPTY), (J.FieldAccess)this.convert(node.getQualifiedIdentifier()), null);
    }

    @Override
    public J visitInstanceOf(InstanceOfTree node, Space fmt) {
        J.Identifier pattern = null;
        J.Modifier modifier = null;
        JavaType type = this.typeMapping.type(node);
        JRightPadded expression = this.convert(node.getExpression(), t -> this.sourceBefore("instanceof"));
        PatternTree patternTree = node.getPattern();
        if (patternTree instanceof JCTree.JCBindingPattern) {
            JCTree.JCBindingPattern b = (JCTree.JCBindingPattern)patternTree;
            if (b.var.mods.flags == 16L) {
                modifier = new J.Modifier(Tree.randomId(), this.sourceBefore("final"), Markers.EMPTY, null, J.Modifier.Type.Final, Collections.emptyList());
            }
        }
        Object clazz = this.convert(node.getType());
        PatternTree patternTree2 = node.getPattern();
        if (patternTree2 instanceof JCTree.JCBindingPattern) {
            JCTree.JCBindingPattern b = (JCTree.JCBindingPattern)patternTree2;
            pattern = new J.Identifier(Tree.randomId(), this.sourceBefore(b.getVariable().getName().toString()), Markers.EMPTY, Collections.emptyList(), b.getVariable().getName().toString(), type, this.typeMapping.variableType(b.var.sym));
        }
        return new J.InstanceOf(Tree.randomId(), fmt, Markers.EMPTY, expression, clazz, pattern, type, modifier);
    }

    @Override
    public J visitIntersectionType(IntersectionTypeTree node, Space fmt) {
        JContainer bounds = node.getBounds().isEmpty() ? null : JContainer.build((Space)Space.EMPTY, this.convertAll(node.getBounds(), t -> this.sourceBefore("&"), this.noDelim), (Markers)Markers.EMPTY);
        return new J.IntersectionType(Tree.randomId(), fmt, Markers.EMPTY, bounds);
    }

    @Override
    public J visitLabeledStatement(LabeledStatementTree node, Space fmt) {
        this.skip(node.getLabel().toString());
        return new J.Label(Tree.randomId(), fmt, Markers.EMPTY, this.padRight(new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), node.getLabel().toString(), null, null), this.sourceBefore(":")), (Statement)this.convert(node.getStatement()));
    }

    @Override
    public J visitLambdaExpression(LambdaExpressionTree node, Space fmt) {
        Object body;
        boolean parenthesized = this.source.charAt(this.cursor) == '(';
        this.skip("(");
        java.util.List<Object> paramList = parenthesized && node.getParameters().isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)) : this.convertAll(node.getParameters(), this.commaDelim, t -> parenthesized ? this.sourceBefore(")") : Space.EMPTY);
        J.Lambda.Parameters params = new J.Lambda.Parameters(Tree.randomId(), Space.EMPTY, Markers.EMPTY, parenthesized, paramList);
        Space arrow = this.sourceBefore("->");
        if (node.getBody() instanceof JCTree.JCBlock) {
            Space prefix = this.sourceBefore("{");
            --this.cursor;
            body = this.convert(node.getBody());
            body = body.withPrefix(prefix);
        } else {
            body = this.convert(node.getBody());
        }
        return new J.Lambda(Tree.randomId(), fmt, Markers.EMPTY, params, arrow, body, this.typeMapping.type(node));
    }

    @Override
    public J visitLiteral(LiteralTree node, Space fmt) {
        int endPos = this.endPos(node);
        Object value = node.getValue();
        if (endPos == -1) {
            if (this.typeMapping.primitive(((JCTree.JCLiteral)node).typetag) == JavaType.Primitive.String) {
                int quote = this.source.startsWith("\"\"\"", this.cursor) ? 3 : 1;
                int elementLength = quote == 3 ? this.source.indexOf("\"\"\"", this.cursor + quote) - this.cursor - quote : value.toString().length();
                endPos = this.cursor + quote + elementLength + quote;
            } else {
                endPos = StringUtils.indexOf((String)this.source, (int)this.cursor, ch -> Character.isWhitespace(ch.charValue()) || ",;)]}+-*/%=!<>&|^?:.".indexOf(ch.charValue()) != -1);
            }
        }
        this.cursor(endPos);
        String valueSource = this.source.substring(((JCTree.JCLiteral)node).getStartPosition(), endPos);
        JavaType.Primitive type = this.typeMapping.primitive(((JCTree.JCLiteral)node).typetag);
        if (value instanceof Character) {
            char c = ((Character)value).charValue();
            if (c >= '\ud800' && c <= '\udfff') {
                return new J.Literal(Tree.randomId(), fmt, Markers.EMPTY, null, "''", Collections.singletonList(new J.Literal.UnicodeEscape(1, valueSource.substring(3, valueSource.length() - 1))), type);
            }
        } else if (JavaType.Primitive.String == type) {
            StringBuilder valueSourceWithoutSurrogates = new StringBuilder();
            ArrayList<J.Literal.UnicodeEscape> unicodeEscapes = null;
            int i = 0;
            for (int j = 0; j < valueSource.length(); ++j) {
                String codePoint;
                int codePointNumeric;
                char c = valueSource.charAt(j);
                if (c == '\\' && j < valueSource.length() - 1 && (j == 0 || valueSource.charAt(j - 1) != '\\') && valueSource.charAt(j + 1) == 'u' && j < valueSource.length() - 5 && (codePointNumeric = Integer.parseInt(codePoint = valueSource.substring(j + 2, j + 6), 16)) >= 55296 && codePointNumeric <= 57343) {
                    if (unicodeEscapes == null) {
                        unicodeEscapes = new ArrayList<J.Literal.UnicodeEscape>(1);
                    }
                    unicodeEscapes.add(new J.Literal.UnicodeEscape(i, codePoint));
                    j += 5;
                    continue;
                }
                valueSourceWithoutSurrogates.append(c);
                ++i;
            }
            return new J.Literal(Tree.randomId(), fmt, Markers.EMPTY, unicodeEscapes == null ? value : valueSourceWithoutSurrogates.toString(), valueSourceWithoutSurrogates.toString(), unicodeEscapes, type);
        }
        return new J.Literal(Tree.randomId(), fmt, Markers.EMPTY, value, valueSource, null, type);
    }

    @Override
    public J visitMemberReference(MemberReferenceTree node, Space fmt) {
        JCTree.JCMemberReference ref = (JCTree.JCMemberReference)node;
        String referenceName = switch (ref.getMode()) {
            case MemberReferenceTree.ReferenceMode.NEW -> "new";
            default -> node.getName().toString();
        };
        JavaType.Method methodReferenceType = null;
        if (ref.sym instanceof Symbol.MethodSymbol) {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)ref.sym;
            methodReferenceType = this.typeMapping.methodInvocationType(methodSymbol.type, methodSymbol);
        }
        JavaType.Variable fieldReferenceType = null;
        if (ref.sym instanceof Symbol.VarSymbol) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)ref.sym;
            fieldReferenceType = this.typeMapping.variableType(varSymbol);
        }
        return new J.MemberReference(Tree.randomId(), fmt, Markers.EMPTY, this.padRight((Expression)this.convert(ref.expr), this.sourceBefore("::")), this.convertTypeParameters(node.getTypeArguments()), this.padLeft(this.whitespace(), new J.Identifier(Tree.randomId(), this.sourceBefore(referenceName), Markers.EMPTY, Collections.emptyList(), referenceName, null, null)), this.typeMapping.type(node), methodReferenceType, fieldReferenceType);
    }

    @Override
    public J visitMemberSelect(MemberSelectTree node, Space fmt) {
        JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)node;
        JavaType type = this.typeMapping.type(node);
        return new J.FieldAccess(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.convert(fieldAccess.selected), this.padLeft(this.sourceBefore("."), new J.Identifier(Tree.randomId(), this.sourceBefore(fieldAccess.name.toString()), Markers.EMPTY, Collections.emptyList(), fieldAccess.name.toString(), type, this.typeMapping.variableType(fieldAccess.sym))), type);
    }

    @Override
    public J visitMethodInvocation(MethodInvocationTree node, Space fmt) {
        JavaType.Method methodType;
        J.Identifier name;
        JCTree.JCExpression jcSelect = ((JCTree.JCMethodInvocation)node).getMethodSelect();
        JRightPadded select = null;
        if (jcSelect instanceof JCTree.JCFieldAccess) {
            select = this.convert(((JCTree.JCFieldAccess)jcSelect).selected, t -> this.sourceBefore("."));
        } else if (!(jcSelect instanceof JCTree.JCIdent)) {
            throw new IllegalStateException("Unexpected method select type " + jcSelect.getClass().getSimpleName());
        }
        JContainer typeParams = null;
        if (!node.getTypeArguments().isEmpty()) {
            typeParams = JContainer.build((Space)this.sourceBefore("<"), this.convertAll(node.getTypeArguments(), this.commaDelim, t -> this.sourceBefore(">")), (Markers)Markers.EMPTY);
        }
        if (jcSelect instanceof JCTree.JCFieldAccess) {
            String selectName = ((JCTree.JCFieldAccess)jcSelect).name.toString();
            name = new J.Identifier(Tree.randomId(), this.sourceBefore(selectName), Markers.EMPTY, Collections.emptyList(), selectName, null, null);
        } else {
            name = (J.Identifier)this.convert(jcSelect);
        }
        JContainer args = JContainer.build((Space)this.sourceBefore("("), node.getArguments().isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)) : this.convertAll(node.getArguments(), this.commaDelim, t -> this.sourceBefore(")")), (Markers)Markers.EMPTY);
        if (name.getType() instanceof JavaType.Method) {
            methodType = (JavaType.Method)name.getType();
        } else {
            Symbol methodSymbol = jcSelect instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)jcSelect).sym : ((JCTree.JCIdent)jcSelect).sym;
            methodType = this.typeMapping.methodInvocationType(jcSelect.type, methodSymbol);
        }
        return new J.MethodInvocation(Tree.randomId(), fmt, Markers.EMPTY, select, typeParams, name, args, methodType);
    }

    @Override
    public J visitMethod(MethodTree node, Space fmt) {
        J.MethodDeclaration.IdentifierWithAnnotations name;
        J.TypeParameters typeParams;
        JCTree.JCMethodDecl jcMethod = (JCTree.JCMethodDecl)node;
        Map<Integer, JCTree.JCAnnotation> annotationPosTable = this.mapAnnotations(node.getModifiers().getAnnotations(), new HashMap<Integer, JCTree.JCAnnotation>(node.getModifiers().getAnnotations().size()));
        ReloadableJava17ModifierResults modifierResults = this.sortedModifiersAndAnnotations(node.getModifiers(), annotationPosTable);
        if (node.getTypeParameters().isEmpty()) {
            typeParams = null;
        } else {
            java.util.List<J.Annotation> typeParamsAnnotations = this.collectAnnotations(annotationPosTable);
            typeParams = new J.TypeParameters(Tree.randomId(), this.sourceBefore("<"), Markers.EMPTY, typeParamsAnnotations, this.convertAll(node.getTypeParameters(), this.commaDelim, t -> this.sourceBefore(">")));
        }
        java.util.List<J.Annotation> returnTypeAnnotations = this.collectAnnotations(annotationPosTable);
        TypeTree returnType = (TypeTree)this.convert(node.getReturnType());
        if (returnType != null && !returnTypeAnnotations.isEmpty()) {
            returnType = new J.AnnotatedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, returnTypeAnnotations, returnType);
        }
        Symbol.MethodSymbol nodeSym = jcMethod.sym;
        if ("<init>".equals(node.getName().toString())) {
            String owner = null;
            if (nodeSym == null) {
                for (com.sun.source.tree.Tree tree : this.getCurrentPath()) {
                    if (!(tree instanceof JCTree.JCClassDecl)) continue;
                    owner = ((JCTree.JCClassDecl)tree).getSimpleName().toString();
                    break;
                }
                if (owner == null) {
                    throw new IllegalStateException("Should have been able to locate an owner");
                }
            } else {
                owner = jcMethod.sym.owner.name.toString();
            }
            name = new J.MethodDeclaration.IdentifierWithAnnotations(new J.Identifier(Tree.randomId(), this.sourceBefore(owner), Markers.EMPTY, Collections.emptyList(), owner, null, null), returnType == null ? returnTypeAnnotations : Collections.emptyList());
        } else {
            name = new J.MethodDeclaration.IdentifierWithAnnotations(new J.Identifier(Tree.randomId(), this.sourceBefore(node.getName().toString(), null), Markers.EMPTY, Collections.emptyList(), node.getName().toString(), null, null), returnType == null ? returnTypeAnnotations : Collections.emptyList());
        }
        boolean isCompactConstructor = nodeSym != null && (nodeSym.flags() & 0x8000000000000L) != 0L;
        JContainer params = JContainer.empty();
        if (!isCompactConstructor) {
            Space paramFmt = this.sourceBefore("(");
            params = !node.getParameters().isEmpty() ? JContainer.build((Space)paramFmt, this.convertAll(node.getParameters(), this.commaDelim, t -> this.sourceBefore(")")), (Markers)Markers.EMPTY) : JContainer.build((Space)paramFmt, Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY);
        }
        JContainer throws_ = node.getThrows().isEmpty() ? null : JContainer.build((Space)this.sourceBefore("throws"), this.convertAll(node.getThrows(), this.commaDelim, this.noDelim), (Markers)Markers.EMPTY);
        J.Block body = (J.Block)this.convert(node.getBody());
        JLeftPadded<Expression> defaultValue = node.getDefaultValue() == null ? null : this.padLeft(this.sourceBefore("default"), (Expression)this.convert(node.getDefaultValue()));
        J.MethodDeclaration md = new J.MethodDeclaration(Tree.randomId(), fmt, Markers.EMPTY, modifierResults.getLeadingAnnotations(), modifierResults.getModifiers(), typeParams, returnType, name, params, throws_, body, defaultValue, this.typeMapping.methodDeclarationType(jcMethod.sym, null));
        return isCompactConstructor ? md.withMarkers(md.getMarkers().addIfAbsent((Marker)new CompactConstructor(Tree.randomId()))) : md;
    }

    @Override
    public J visitNewArray(NewArrayTree node, Space fmt) {
        int beginBracket;
        TypeTree typeExpr;
        this.skip("new");
        JCTree.JCExpression jcVarType = ((JCTree.JCNewArray)node).elemtype;
        if (jcVarType instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCExpression elementType = ((JCTree.JCArrayTypeTree)jcVarType).elemtype;
            while (elementType instanceof JCTree.JCArrayTypeTree) {
                elementType = ((JCTree.JCArrayTypeTree)elementType).elemtype;
            }
            typeExpr = (TypeTree)this.convert(elementType);
        } else {
            typeExpr = (TypeTree)this.convert(jcVarType);
        }
        java.util.List<? extends ExpressionTree> nodeDimensions = node.getDimensions();
        ArrayList<J.ArrayDimension> dimensions = new ArrayList<J.ArrayDimension>(nodeDimensions.size());
        for (ExpressionTree expressionTree : nodeDimensions) {
            dimensions.add(new J.ArrayDimension(Tree.randomId(), this.sourceBefore("["), Markers.EMPTY, this.convert(expressionTree, t -> this.sourceBefore("]"))));
        }
        while (this.source.charAt(beginBracket = StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source)) == '[') {
            int n = StringUtils.indexOfNextNonWhitespace((int)(beginBracket + 1), (String)this.source);
            dimensions.add(new J.ArrayDimension(Tree.randomId(), Space.format((String)this.source, (int)this.cursor, (int)beginBracket), Markers.EMPTY, this.padRight(new J.Empty(Tree.randomId(), Space.format((String)this.source, (int)(beginBracket + 1), (int)n), Markers.EMPTY), Space.EMPTY)));
            this.cursor = n + 1;
        }
        JContainer initializer = node.getInitializers() == null ? null : JContainer.build((Space)this.sourceBefore("{"), node.getInitializers().isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore("}"), Markers.EMPTY), Space.EMPTY)) : this.convertAll(node.getInitializers(), this.commaDelim, t -> this.whitespace(), t -> {
            if (t == node.getInitializers().get(node.getInitializers().size() - 1) && this.source.charAt(this.cursor) == ',') {
                ++this.cursor;
                return Markers.build(Collections.singletonList(new TrailingComma(Tree.randomId(), this.whitespace())));
            }
            return Markers.EMPTY;
        }), (Markers)Markers.EMPTY);
        this.skip("}");
        return new J.NewArray(Tree.randomId(), fmt, Markers.EMPTY, typeExpr, dimensions, initializer, this.typeMapping.type(node));
    }

    @Override
    public J visitNewClass(NewClassTree node, Space fmt) {
        TypeTree clazz;
        JRightPadded encl = node.getEnclosingExpression() == null ? null : this.convert(node.getEnclosingExpression(), t -> this.sourceBefore("."));
        Space whitespaceBeforeNew = Space.EMPTY;
        com.sun.source.tree.Tree parent = this.getCurrentPath().getParentPath().getLeaf();
        if (!(parent instanceof JCTree.JCVariableDecl) || (((JCTree.JCVariableDecl)parent).mods.flags & 0x4000L) == 0L) {
            whitespaceBeforeNew = this.sourceBefore("new");
        }
        TypeTree typeTree = clazz = this.endPos(node.getIdentifier()) >= 0 ? (TypeTree)this.convert(node.getIdentifier()) : null;
        JContainer args = this.positionOfNext("(", Character.valueOf('{')) > -1 ? JContainer.build((Space)this.sourceBefore("("), node.getArguments().isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)) : this.convertAll(node.getArguments(), this.commaDelim, t -> this.sourceBefore(")")), (Markers)Markers.EMPTY) : JContainer.empty().withMarkers(Markers.build(Collections.singletonList(new OmitParentheses(Tree.randomId()))));
        J.Block body = null;
        if (node.getClassBody() != null) {
            Space bodyPrefix = this.sourceBefore("{");
            ArrayList<com.sun.source.tree.Tree> members = new ArrayList<com.sun.source.tree.Tree>(node.getClassBody().getMembers().size());
            for (com.sun.source.tree.Tree tree : node.getClassBody().getMembers()) {
                if (tree instanceof JCTree.JCMethodDecl && (((JCTree.JCMethodDecl)tree).getModifiers().flags & 0x1000000000L) != 0L) continue;
                members.add(tree);
            }
            java.util.List<JRightPadded<Statement>> converted = this.convertStatements(members);
            this.addPossibleEmptyStatementsBeforeClosingBrace(converted);
            body = new J.Block(Tree.randomId(), bodyPrefix, Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), converted, this.sourceBefore("}"));
        }
        JCTree.JCNewClass jcNewClass = (JCTree.JCNewClass)node;
        JavaType.Method constructorType = this.typeMapping.methodInvocationType(jcNewClass.constructorType, jcNewClass.constructor);
        if (constructorType != null && jcNewClass.clazz.type.isParameterized() && node.getClassBody() == null) {
            constructorType = constructorType.withReturnType(this.typeMapping.type(jcNewClass.clazz.type));
        }
        return new J.NewClass(Tree.randomId(), fmt, Markers.EMPTY, encl, whitespaceBeforeNew, clazz, args, body, constructorType);
    }

    @Override
    public J visitParameterizedType(ParameterizedTypeTree node, Space fmt) {
        return new J.ParameterizedType(Tree.randomId(), fmt, Markers.EMPTY, (NameTree)this.convert(node.getType()), this.convertTypeParameters(node.getTypeArguments()), this.typeMapping.type(node));
    }

    @Override
    public J visitParenthesized(ParenthesizedTree node, Space fmt) {
        this.skip("(");
        com.sun.source.tree.Tree parent = this.getCurrentPath().getParentPath().getLeaf();
        switch (parent.getKind()) {
            case CATCH: 
            case DO_WHILE_LOOP: 
            case IF: 
            case SWITCH: 
            case SWITCH_EXPRESSION: 
            case SYNCHRONIZED: 
            case TYPE_CAST: 
            case WHILE_LOOP: {
                return new J.ControlParentheses(Tree.randomId(), fmt, Markers.EMPTY, this.convert(node.getExpression(), t -> this.sourceBefore(")")));
            }
        }
        return new J.Parentheses(Tree.randomId(), fmt, Markers.EMPTY, this.convert(node.getExpression(), t -> this.sourceBefore(")")));
    }

    @Override
    public J visitPrimitiveType(PrimitiveTypeTree node, Space fmt) {
        this.cursor(this.endPos(node));
        return new J.Primitive(Tree.randomId(), fmt, Markers.EMPTY, switch (node.getPrimitiveTypeKind()) {
            case TypeKind.BOOLEAN -> JavaType.Primitive.Boolean;
            case TypeKind.BYTE -> JavaType.Primitive.Byte;
            case TypeKind.CHAR -> JavaType.Primitive.Char;
            case TypeKind.DOUBLE -> JavaType.Primitive.Double;
            case TypeKind.FLOAT -> JavaType.Primitive.Float;
            case TypeKind.INT -> JavaType.Primitive.Int;
            case TypeKind.LONG -> JavaType.Primitive.Long;
            case TypeKind.SHORT -> JavaType.Primitive.Short;
            case TypeKind.VOID -> JavaType.Primitive.Void;
            default -> throw new IllegalArgumentException("Unknown primitive type " + String.valueOf((Object)node.getPrimitiveTypeKind()));
        });
    }

    @Override
    public J visitReturn(ReturnTree node, Space fmt) {
        this.skip("return");
        Expression expression = (Expression)this.convert(node.getExpression());
        return new J.Return(Tree.randomId(), fmt, Markers.EMPTY, expression);
    }

    @Override
    public J visitSwitch(SwitchTree node, Space fmt) {
        this.skip("switch");
        return new J.Switch(Tree.randomId(), fmt, Markers.EMPTY, (J.ControlParentheses)this.convert(node.getExpression()), new J.Block(Tree.randomId(), this.sourceBefore("{"), Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), this.convertAll(node.getCases(), this.noDelim, this.noDelim), this.sourceBefore("}")));
    }

    @Override
    public J visitSwitchExpression(SwitchExpressionTree node, Space fmt) {
        this.skip("switch");
        return new J.SwitchExpression(Tree.randomId(), fmt, Markers.EMPTY, (J.ControlParentheses)this.convert(node.getExpression()), new J.Block(Tree.randomId(), this.sourceBefore("{"), Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), this.convertAll(node.getCases(), this.noDelim, this.noDelim), this.sourceBefore("}")), this.typeMapping.type(node));
    }

    @Override
    public J visitSynchronized(SynchronizedTree node, Space fmt) {
        this.skip("synchronized");
        return new J.Synchronized(Tree.randomId(), fmt, Markers.EMPTY, (J.ControlParentheses)this.convert(node.getExpression()), (J.Block)this.convert(node.getBlock()));
    }

    @Override
    public J visitThrow(ThrowTree node, Space fmt) {
        this.skip("throw");
        return new J.Throw(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.convert(node.getExpression()));
    }

    @Override
    public J visitTry(TryTree node, Space fmt) {
        JContainer resources;
        this.skip("try");
        if (node.getResources().isEmpty()) {
            resources = null;
        } else {
            Space before = this.sourceBefore("(");
            ArrayList<JRightPadded<J.Try.Resource>> resourceList = new ArrayList<JRightPadded<J.Try.Resource>>(node.getResources().size());
            for (int i = 0; i < node.getResources().size(); ++i) {
                com.sun.source.tree.Tree resource = node.getResources().get(i);
                Object resourceVar = this.convert(resource);
                boolean semicolonPresent = true;
                if (i == node.getResources().size() - 1) {
                    semicolonPresent = this.positionOfNext(";", Character.valueOf(')')) > 0;
                }
                Space resourcePrefix = resourceVar.getPrefix();
                resourceVar = resourceVar.withPrefix(Space.EMPTY);
                if (semicolonPresent && resourceVar instanceof J.VariableDeclarations) {
                    J.VariableDeclarations resourceVarDecl = (J.VariableDeclarations)resourceVar;
                    resourceVar = resourceVarDecl.getPadding().withVariables(Space.formatLastSuffix((java.util.List)resourceVarDecl.getPadding().getVariables(), (Space)this.sourceBefore(";")));
                }
                J.Try.Resource tryResource = new J.Try.Resource(Tree.randomId(), resourcePrefix, Markers.EMPTY, (TypedTree)resourceVar.withPrefix(Space.EMPTY), semicolonPresent);
                this.skip(";");
                resourceList.add(this.padRight(tryResource, i == node.getResources().size() - 1 ? this.sourceBefore(")") : Space.EMPTY));
            }
            resources = JContainer.build((Space)before, resourceList, (Markers)Markers.EMPTY);
        }
        J.Block block = (J.Block)this.convert(node.getBlock());
        java.util.List catches = this.convertAll(node.getCatches());
        JLeftPadded<J.Block> finally_ = node.getFinallyBlock() == null ? null : this.padLeft(this.sourceBefore("finally"), (J.Block)this.convert(node.getFinallyBlock()));
        return new J.Try(Tree.randomId(), fmt, Markers.EMPTY, resources, block, catches, finally_);
    }

    @Override
    public J visitTypeCast(TypeCastTree node, Space fmt) {
        return new J.TypeCast(Tree.randomId(), fmt, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), this.sourceBefore("("), Markers.EMPTY, this.convert(node.getType(), t -> this.sourceBefore(")"))), (Expression)this.convert(node.getExpression()));
    }

    @Override
    public J visitAnnotatedType(AnnotatedTypeTree node, Space fmt) {
        JCTree.JCArrayTypeTree arrayTypeTree;
        Map<Integer, JCTree.JCAnnotation> annotationPosTable = this.mapAnnotations(node.getAnnotations(), new HashMap<Integer, JCTree.JCAnnotation>(node.getAnnotations().size()));
        com.sun.source.tree.Tree tree = node.getUnderlyingType();
        if (tree instanceof JCTree.JCArrayTypeTree && (tree = (arrayTypeTree = (JCTree.JCArrayTypeTree)tree).getType()) instanceof JCTree.JCAnnotatedType) {
            JCTree.JCAnnotatedType annotatedType = (JCTree.JCAnnotatedType)tree;
            annotationPosTable.putAll(this.mapAnnotations(annotatedType.getAnnotations(), new HashMap<Integer, JCTree.JCAnnotation>()));
        }
        java.util.List<J.Annotation> leadingAnnotations = this.leadingAnnotations(annotationPosTable);
        if (!annotationPosTable.isEmpty()) {
            if (node.getUnderlyingType() instanceof JCTree.JCFieldAccess) {
                return new J.AnnotatedType(Tree.randomId(), fmt, Markers.EMPTY, leadingAnnotations, this.annotatedTypeTree(node.getUnderlyingType(), annotationPosTable));
            }
            if (node.getUnderlyingType() instanceof JCTree.JCArrayTypeTree) {
                return new J.AnnotatedType(Tree.randomId(), fmt, Markers.EMPTY, leadingAnnotations, this.arrayTypeTree(node, annotationPosTable));
            }
        }
        return new J.AnnotatedType(Tree.randomId(), fmt, Markers.EMPTY, leadingAnnotations, (TypeTree)this.convert(node.getUnderlyingType()));
    }

    private Map<Integer, JCTree.JCAnnotation> mapAnnotations(java.util.List<? extends AnnotationTree> annotations, Map<Integer, JCTree.JCAnnotation> annotationPosTable) {
        for (AnnotationTree annotationTree : annotations) {
            JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)annotationTree;
            annotationPosTable.put(annotation.pos, annotation);
        }
        return annotationPosTable;
    }

    private java.util.List<J.Annotation> leadingAnnotations(Map<Integer, JCTree.JCAnnotation> annotationPosTable) {
        ArrayList annotations = new ArrayList(annotationPosTable.size());
        int saveCursor = this.cursor;
        this.whitespace();
        while (annotationPosTable.containsKey(this.cursor)) {
            JCTree.JCAnnotation jcAnnotation = annotationPosTable.get(this.cursor);
            annotationPosTable.remove(this.cursor);
            this.cursor = saveCursor;
            J.Annotation ann = (J.Annotation)this.convert(jcAnnotation);
            annotations.add(ann);
            saveCursor = this.cursor;
            this.whitespace();
        }
        this.cursor = saveCursor;
        return annotations.isEmpty() ? Collections.emptyList() : annotations;
    }

    private TypeTree annotatedTypeTree(com.sun.source.tree.Tree node, Map<Integer, JCTree.JCAnnotation> annotationPosTable) {
        if (node instanceof JCTree.JCFieldAccess) {
            Space prefix = this.whitespace();
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)node;
            JavaType type = this.typeMapping.type(node);
            Expression select = (Expression)this.annotatedTypeTree(fieldAccess.selected, annotationPosTable);
            Space dotPrefix = this.sourceBefore(".");
            java.util.List<J.Annotation> annotations = this.leadingAnnotations(annotationPosTable);
            return new J.FieldAccess(Tree.randomId(), prefix, Markers.EMPTY, select, this.padLeft(dotPrefix, new J.Identifier(Tree.randomId(), this.sourceBefore(fieldAccess.name.toString()), Markers.EMPTY, annotations, fieldAccess.name.toString(), type, this.typeMapping.variableType(fieldAccess.sym))), type);
        }
        return (TypeTree)this.convert(node);
    }

    private TypeTree arrayTypeTree(com.sun.source.tree.Tree tree, Map<Integer, JCTree.JCAnnotation> annotationPosTable) {
        com.sun.source.tree.Tree typeIdent = tree;
        int count = 0;
        JCTree.JCArrayTypeTree arrayTypeTree = null;
        while (typeIdent instanceof JCTree.JCAnnotatedType || typeIdent instanceof JCTree.JCArrayTypeTree) {
            if (typeIdent instanceof JCTree.JCAnnotatedType) {
                typeIdent = ((JCTree.JCAnnotatedType)typeIdent).getUnderlyingType();
            }
            if (!(typeIdent instanceof JCTree.JCArrayTypeTree)) continue;
            if (count == 0) {
                arrayTypeTree = (JCTree.JCArrayTypeTree)typeIdent;
            }
            ++count;
            typeIdent = ((JCTree.JCArrayTypeTree)typeIdent).getType();
        }
        Space prefix = this.whitespace();
        TypeTree elemType = (TypeTree)this.convert(typeIdent);
        java.util.List<J.Annotation> annotations = this.leadingAnnotations(annotationPosTable);
        JLeftPadded<Space> dimension = this.padLeft(this.sourceBefore("["), this.sourceBefore("]"));
        assert (arrayTypeTree != null);
        return new J.ArrayType(Tree.randomId(), prefix, Markers.EMPTY, count == 1 ? elemType : this.mapDimensions(elemType, arrayTypeTree.getType(), annotationPosTable), annotations, dimension, this.typeMapping.type(tree));
    }

    private TypeTree mapDimensions(TypeTree baseType, com.sun.source.tree.Tree tree, Map<Integer, JCTree.JCAnnotation> annotationPosTable) {
        com.sun.source.tree.Tree typeIdent = tree;
        if (typeIdent instanceof JCTree.JCAnnotatedType) {
            this.mapAnnotations(((JCTree.JCAnnotatedType)typeIdent).getAnnotations(), annotationPosTable);
            typeIdent = ((JCTree.JCAnnotatedType)typeIdent).getUnderlyingType();
        }
        if (typeIdent instanceof JCTree.JCArrayTypeTree) {
            java.util.List<J.Annotation> annotations = this.leadingAnnotations(annotationPosTable);
            int saveCursor = this.cursor;
            this.whitespace();
            if (this.source.startsWith("[", this.cursor)) {
                this.cursor = saveCursor;
                JLeftPadded<Space> dimension = this.padLeft(this.sourceBefore("["), this.sourceBefore("]"));
                return new J.ArrayType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.mapDimensions(baseType, ((JCTree.JCArrayTypeTree)typeIdent).elemtype, annotationPosTable), annotations, dimension, this.typeMapping.type(tree));
            }
            this.cursor = saveCursor;
        }
        return baseType;
    }

    @Override
    public J visitTypeParameter(TypeParameterTree node, Space fmt) {
        java.util.List annotations = this.convertAll(node.getAnnotations());
        Expression name = (Expression)this.buildName(node.getName().toString()).withPrefix(this.sourceBefore(node.getName().toString()));
        JContainer bounds = node.getBounds().isEmpty() ? null : JContainer.build((Space)this.sourceBefore("extends"), this.convertAll(node.getBounds(), t -> this.sourceBefore("&"), this.noDelim), (Markers)Markers.EMPTY);
        return new J.TypeParameter(Tree.randomId(), fmt, Markers.EMPTY, annotations, Collections.emptyList(), name, bounds);
    }

    private <T extends TypeTree & Expression> T buildName(String fullyQualifiedName) {
        String[] parts = fullyQualifiedName.split("\\.");
        Object fullName = "";
        J.Identifier expr = null;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == 0) {
                fullName = part;
                expr = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), part, null, null);
                continue;
            }
            fullName = (String)fullName + "." + part;
            int endOfPrefix = StringUtils.indexOfNextNonWhitespace((int)0, (String)part);
            Space identFmt = endOfPrefix > 0 ? Space.format((String)part, (int)0, (int)endOfPrefix) : Space.EMPTY;
            Matcher whitespaceSuffix = whitespaceSuffixPattern.matcher(part);
            whitespaceSuffix.matches();
            Space namePrefix = i == parts.length - 1 ? Space.EMPTY : Space.format((String)whitespaceSuffix.group(1));
            expr = new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)expr, this.padLeft(namePrefix, new J.Identifier(Tree.randomId(), identFmt, Markers.EMPTY, Collections.emptyList(), part.trim(), null, null)), (JavaType)(Character.isUpperCase(part.charAt(0)) || i == parts.length - 1 ? JavaType.ShallowClass.build((String)fullName) : null));
        }
        return (T)((TypeTree)expr);
    }

    @Override
    public J visitUnionType(UnionTypeTree node, Space fmt) {
        return new J.MultiCatch(Tree.randomId(), fmt, Markers.EMPTY, this.convertAll(node.getTypeAlternatives(), t -> this.sourceBefore("|"), this.noDelim));
    }

    @Override
    public J visitUnary(UnaryTree node, Space fmt) {
        Expression expr;
        JLeftPadded<J.Unary.Type> op;
        JCTree.JCUnary unary = (JCTree.JCUnary)node;
        JCTree.Tag tag = unary.getTag();
        switch (tag) {
            case POS: {
                this.skip("+");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.Positive);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case NEG: {
                this.skip("-");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.Negative);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case PREDEC: {
                this.skip("--");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.PreDecrement);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case PREINC: {
                this.skip("++");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.PreIncrement);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case POSTDEC: {
                expr = (Expression)this.convert(unary.arg);
                op = this.padLeft(this.sourceBefore("--"), J.Unary.Type.PostDecrement);
                break;
            }
            case POSTINC: {
                expr = (Expression)this.convert(unary.arg);
                op = this.padLeft(this.sourceBefore("++"), J.Unary.Type.PostIncrement);
                break;
            }
            case COMPL: {
                this.skip("~");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.Complement);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case NOT: {
                this.skip("!");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.Not);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected unary tag " + String.valueOf((Object)tag));
            }
        }
        return new J.Unary(Tree.randomId(), fmt, Markers.EMPTY, op, expr, this.typeMapping.type(node));
    }

    @Override
    public J visitVariable(VariableTree node, Space fmt) {
        JCTree.JCVariableDecl jcVariableDecl = (JCTree.JCVariableDecl)node;
        if ("<error>".equals(jcVariableDecl.getName().toString())) {
            int endPos;
            int startPos = jcVariableDecl.getStartPosition();
            if (startPos == (endPos = jcVariableDecl.getEndPosition(this.endPosTable))) {
                endPos = startPos + 1;
            }
            String erroneousNode = this.source.substring(startPos, endPos);
            return new J.Erroneous(Tree.randomId(), fmt, Markers.EMPTY, erroneousNode);
        }
        return this.hasFlag(node.getModifiers(), 16384L) ? this.visitEnumVariable(node, fmt) : this.visitVariables(Collections.singletonList(node), fmt);
    }

    private J.VariableDeclarations visitVariables(java.util.List<VariableTree> nodes, Space fmt) {
        int varargStart;
        TypeTree typeExpr;
        JCTree.JCVariableDecl node = (JCTree.JCVariableDecl)nodes.get(0);
        JCTree.JCExpression vartype = node.vartype;
        Map<Integer, JCTree.JCAnnotation> annotationPosTable = this.mapAnnotations(node.getModifiers().getAnnotations(), new HashMap<Integer, JCTree.JCAnnotation>(((List)node.getModifiers().getAnnotations()).size()));
        ReloadableJava17ModifierResults modifierResults = this.sortedModifiersAndAnnotations(node.getModifiers(), annotationPosTable);
        java.util.List<J.Annotation> typeExprAnnotations = this.collectAnnotations(annotationPosTable);
        if (vartype == null) {
            typeExpr = null;
        } else if (this.endPos(vartype) < 0) {
            if ((node.sym.flags() & 0x200000000L) > 0L) {
                typeExpr = null;
            } else {
                Space space = this.whitespace();
                boolean lombokVal = this.source.startsWith("val", this.cursor);
                this.cursor += 3;
                typeExpr = new J.Identifier(Tree.randomId(), space, Markers.build(Collections.singletonList(JavaVarKeyword.build())), Collections.emptyList(), lombokVal ? "val" : "var", this.typeMapping.type(vartype), null);
            }
        } else if (vartype instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCExpression elementType = vartype;
            while (elementType instanceof JCTree.JCArrayTypeTree || elementType instanceof JCTree.JCAnnotatedType) {
                if (elementType instanceof JCTree.JCAnnotatedType) {
                    elementType = ((JCTree.JCAnnotatedType)elementType).underlyingType;
                }
                if (!(elementType instanceof JCTree.JCArrayTypeTree)) continue;
                elementType = ((JCTree.JCArrayTypeTree)elementType).elemtype;
            }
            int idx = StringUtils.indexOfNextNonWhitespace((int)elementType.getEndPosition(this.endPosTable), (String)this.source);
            typeExpr = idx != -1 && (this.source.charAt(idx) == '[' || this.source.charAt(idx) == '@') ? (TypeTree)this.convert(vartype) : (TypeTree)this.convert(elementType);
        } else {
            typeExpr = (TypeTree)this.convert(vartype);
        }
        if (typeExpr == null && node.declaredUsingVar()) {
            typeExpr = new J.Identifier(Tree.randomId(), this.sourceBefore("var"), Markers.build(Collections.singletonList(JavaVarKeyword.build())), Collections.emptyList(), "var", this.typeMapping.type(vartype), null);
        }
        if (typeExpr != null && !typeExprAnnotations.isEmpty()) {
            Space prefix = typeExprAnnotations.get(0).getPrefix();
            typeExpr = new J.AnnotatedType(Tree.randomId(), prefix, Markers.EMPTY, ListUtils.mapFirst(typeExprAnnotations, a -> a.withPrefix(Space.EMPTY)), typeExpr);
        }
        Space varargs = null;
        if (typeExpr != null && typeExpr.getMarkers().findFirst(JavaVarKeyword.class).isEmpty() && this.source.startsWith("...", varargStart = StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source))) {
            varargs = Space.format((String)this.source, (int)this.cursor, (int)varargStart);
            this.cursor = varargStart + 3;
        }
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> vars = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            JCTree.JCVariableDecl n = (JCTree.JCVariableDecl)nodes.get(i);
            Space namedVarPrefix = this.sourceBefore(n.getName().toString());
            JavaType type = this.typeMapping.type(n);
            J.Identifier name = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), n.getName().toString(), type instanceof JavaType.Variable ? ((JavaType.Variable)type).getType() : type, type instanceof JavaType.Variable ? (JavaType.Variable)type : null);
            java.util.List<JLeftPadded<Space>> dimensionsAfterName = this.arrayDimensions();
            vars.add(this.padRight(new J.VariableDeclarations.NamedVariable(Tree.randomId(), namedVarPrefix, Markers.EMPTY, (VariableDeclarator)name, dimensionsAfterName, n.init != null ? this.padLeft(this.sourceBefore("="), (Expression)this.convert(n.init)) : null, (JavaType.Variable)this.typeMapping.type(n)), i == nodes.size() - 1 ? Space.EMPTY : this.sourceBefore(",")));
        }
        return new J.VariableDeclarations(Tree.randomId(), fmt, Markers.EMPTY, modifierResults.getLeadingAnnotations(), modifierResults.getModifiers(), typeExpr, varargs, vars);
    }

    private java.util.List<JLeftPadded<Space>> arrayDimensions() {
        int beginBracket;
        ArrayList<JLeftPadded<Space>> dims = null;
        while (this.source.charAt(beginBracket = StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source)) == '[') {
            int endBracket = StringUtils.indexOfNextNonWhitespace((int)(beginBracket + 1), (String)this.source);
            if (dims == null) {
                dims = new ArrayList<JLeftPadded<Space>>(2);
            }
            dims.add(this.padLeft(Space.format((String)this.source, (int)this.cursor, (int)beginBracket), Space.format((String)this.source, (int)(beginBracket + 1), (int)endBracket)));
            this.cursor = endBracket + 1;
        }
        return dims == null ? Collections.emptyList() : dims;
    }

    @Override
    public J visitWhileLoop(WhileLoopTree node, Space fmt) {
        this.skip("while");
        return new J.WhileLoop(Tree.randomId(), fmt, Markers.EMPTY, (J.ControlParentheses)this.convert(node.getCondition()), this.convert(node.getStatement(), this::statementDelim));
    }

    @Override
    public J visitWildcard(WildcardTree node, Space fmt) {
        this.skip("?");
        JCTree.JCWildcard wildcard = (JCTree.JCWildcard)node;
        return new J.Wildcard(Tree.randomId(), fmt, Markers.EMPTY, switch (wildcard.kind.kind) {
            case BoundKind.EXTENDS -> this.padLeft(this.sourceBefore("extends"), J.Wildcard.Bound.Extends);
            case BoundKind.SUPER -> this.padLeft(this.sourceBefore("super"), J.Wildcard.Bound.Super);
            default -> null;
        }, (NameTree)this.convert(wildcard.inner));
    }

    @Contract(value="null -> null; !null -> !null")
    private <J2 extends J> @Nullable J2 convert(@Nullable com.sun.source.tree.Tree t) {
        if (t == null) {
            return null;
        }
        try {
            String prefix = this.isEnum(t) ? "" : this.source.substring(this.cursor, StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source));
            this.cursor += prefix.length();
            J j = (J)this.scan(t, this.formatWithCommentTree(prefix, (JCTree)t, this.docCommentTable.getCommentTree((JCTree)t)));
            return (J2)j;
        }
        catch (Throwable ex) {
            this.reportJavaParsingException(ex);
            throw ex;
        }
    }

    private boolean isEnum(com.sun.source.tree.Tree t) {
        if (t instanceof JCTree.JCNewClass) {
            JCTree.JCNewClass newClass = (JCTree.JCNewClass)t;
            return newClass.type != null && newClass.type.tsym != null && this.hasFlag(newClass.type.tsym.flags(), 16384L);
        }
        return false;
    }

    private void reportJavaParsingException(Throwable ex) {
        StringBuilder message = new StringBuilder("Failed to convert for the following cursor stack:");
        message.append("--- BEGIN PATH ---\n");
        java.util.List paths = StreamSupport.stream(this.getCurrentPath().spliterator(), false).toList();
        int i = paths.size();
        while (i-- > 0) {
            JCTree tree = (JCTree)paths.get(i);
            if (tree instanceof JCTree.JCCompilationUnit) {
                message.append("JCCompilationUnit(sourceFile = ").append(((JCTree.JCCompilationUnit)tree).sourcefile.getName()).append(")\n");
                continue;
            }
            if (tree instanceof JCTree.JCClassDecl) {
                message.append("JCClassDecl(name = ").append(((JCTree.JCClassDecl)tree).name).append(", line = ").append(this.lineNumber(tree)).append(")\n");
                continue;
            }
            if (tree instanceof JCTree.JCVariableDecl) {
                message.append("JCVariableDecl(name = ").append(((JCTree.JCVariableDecl)tree).name).append(", line = ").append(this.lineNumber(tree)).append(")\n");
                continue;
            }
            message.append(tree.getClass().getSimpleName()).append("(line = ").append(this.lineNumber(tree)).append(")\n");
        }
        message.append("--- END PATH ---\n");
        this.ctx.getOnError().accept(new JavaParsingException(message.toString(), ex));
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    private <J2 extends J> @Nullable JRightPadded<J2> convert(@Nullable com.sun.source.tree.Tree t, Function<com.sun.source.tree.Tree, Space> suffix) {
        return this.convert(t, suffix, j -> Markers.EMPTY);
    }

    @Contract(value="null, _, _ -> null; !null, _, _ -> !null")
    private <J2 extends J> @Nullable JRightPadded<J2> convert(@Nullable com.sun.source.tree.Tree t, Function<com.sun.source.tree.Tree, Space> suffix, Function<com.sun.source.tree.Tree, Markers> markers) {
        if (t == null) {
            return null;
        }
        J2 j = this.convert(t);
        JRightPadded rightPadded = j == null ? null : new JRightPadded(j, suffix.apply(t), markers.apply(t));
        int idx = ReloadableJava17ParserVisitor.findFirstNonWhitespaceChar(rightPadded.getAfter().getWhitespace());
        if (idx >= 0) {
            rightPadded = JRightPadded.build((Object)this.getErroneous(java.util.List.of(rightPadded)));
        }
        if (this.endPos(t) == this.cursor && rightPadded.getElement() instanceof J.Erroneous) {
            this.cursor += ((J.Erroneous)rightPadded.getElement()).getText().length();
        } else {
            this.cursor(Math.max(this.endPos(t), this.cursor));
        }
        return rightPadded;
    }

    private <J2 extends J> J.Erroneous getErroneous(java.util.List<JRightPadded<J2>> converted) {
        PrintOutputCapture p = new PrintOutputCapture((Object)0);
        new JavaPrinter().visitContainer(JContainer.build((Space)Space.EMPTY, converted, (Markers)Markers.EMPTY), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, (Object)p);
        return new J.Erroneous(Tree.randomId(), Space.EMPTY, Markers.EMPTY, p.getOut());
    }

    private static int findFirstNonWhitespaceChar(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private long lineNumber(com.sun.source.tree.Tree tree) {
        return this.source.substring(0, ((JCTree)tree).getStartPosition()).chars().filter(c -> c == 10).count() + 1L;
    }

    private <J2 extends J> java.util.List<J2> convertAll(java.util.List<? extends com.sun.source.tree.Tree> trees) {
        ArrayList<J2> converted = new ArrayList<J2>(trees.size());
        for (com.sun.source.tree.Tree tree : trees) {
            converted.add(this.convert(tree));
        }
        return converted;
    }

    private <J2 extends J> java.util.List<JRightPadded<J2>> convertAll(java.util.List<? extends com.sun.source.tree.Tree> trees, Function<com.sun.source.tree.Tree, Space> innerSuffix, Function<com.sun.source.tree.Tree, Space> suffix) {
        return this.convertAll(trees, innerSuffix, suffix, t -> Markers.EMPTY);
    }

    private <J2 extends J> java.util.List<JRightPadded<J2>> convertAll(java.util.List<? extends com.sun.source.tree.Tree> trees, Function<com.sun.source.tree.Tree, Space> innerSuffix, Function<com.sun.source.tree.Tree, Space> suffix, Function<com.sun.source.tree.Tree, Markers> markers) {
        int size = trees.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<JRightPadded<J2>> converted = new ArrayList<JRightPadded<J2>>(size);
        for (int i = 0; i < size; ++i) {
            converted.add(this.convert(trees.get(i), i == size - 1 ? suffix : innerSuffix, markers));
        }
        return converted;
    }

    private @Nullable JContainer<Expression> convertTypeParameters(@Nullable java.util.List<? extends com.sun.source.tree.Tree> typeArguments) {
        if (typeArguments == null) {
            return null;
        }
        Space typeArgPrefix = this.sourceBefore("<");
        java.util.List<Object> params = typeArguments.isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(">"), Markers.EMPTY), Space.EMPTY)) : this.convertAll(typeArguments, this.commaDelim, t -> this.sourceBefore(">"));
        return JContainer.build((Space)typeArgPrefix, params, (Markers)Markers.EMPTY);
    }

    private Space statementDelim(@Nullable com.sun.source.tree.Tree t) {
        switch (t.getKind()) {
            case DO_WHILE_LOOP: 
            case CONTINUE: 
            case RETURN: 
            case BREAK: 
            case ASSERT: 
            case ASSIGNMENT: 
            case IMPORT: 
            case METHOD_INVOCATION: 
            case NEW_CLASS: 
            case THROW: {
                return this.sourceBefore(";");
            }
            case EXPRESSION_STATEMENT: {
                ExpressionTree expTree = ((ExpressionStatementTree)t).getExpression();
                if (expTree instanceof ErroneousTree) {
                    return Space.build((String)this.source.substring(((JCTree)((Object)expTree)).getEndPosition(this.endPosTable), ((JCTree)t).getEndPosition(this.endPosTable)), Collections.emptyList());
                }
                return this.sourceBefore(";");
            }
            case VARIABLE: {
                JCTree.JCVariableDecl varTree = (JCTree.JCVariableDecl)t;
                if ("<error>".contentEquals(varTree.getName())) {
                    int end;
                    int start = varTree.vartype.getEndPosition(this.endPosTable);
                    String whitespace = this.source.substring(start, end = varTree.getEndPosition(this.endPosTable));
                    if (whitespace.contains("\n")) {
                        return Space.EMPTY;
                    }
                    return Space.build((String)this.source.substring(start, end), Collections.emptyList());
                }
                return this.sourceBefore(";");
            }
            case YIELD: {
                return this.sourceBefore(";");
            }
            case LABELED_STATEMENT: {
                return this.statementDelim(((JCTree.JCLabeledStatement)t).getStatement());
            }
            case METHOD: {
                JCTree.JCMethodDecl m = (JCTree.JCMethodDecl)t;
                if (m.body == null || m.defaultValue != null) {
                    return this.sourceBefore(";");
                }
                return this.sourceBefore("");
            }
        }
        return t instanceof JCTree.JCAssignOp || t instanceof JCTree.JCUnary ? this.sourceBefore(";") : Space.EMPTY;
    }

    private java.util.List<JRightPadded<Statement>> convertStatements(@Nullable java.util.List<? extends com.sun.source.tree.Tree> trees) {
        return this.convertStatements(trees, this::statementDelim);
    }

    private java.util.List<JRightPadded<Statement>> convertStatements(@Nullable java.util.List<? extends com.sun.source.tree.Tree> trees, Function<com.sun.source.tree.Tree, Space> suffix) {
        if (trees == null || trees.isEmpty()) {
            return new ArrayList<JRightPadded<Statement>>();
        }
        LinkedHashMap<Integer, java.util.List> treesGroupedByStartPosition = new LinkedHashMap<Integer, java.util.List>();
        for (com.sun.source.tree.Tree tree : trees) {
            if (!(tree instanceof JCTree.JCVariableDecl) && ReloadableJava17ParserVisitor.isLombokGenerated(tree)) continue;
            treesGroupedByStartPosition.computeIfAbsent(((JCTree)tree).getStartPosition(), k -> new ArrayList(1)).add(tree);
        }
        ArrayList<JRightPadded<Statement>> converted = new ArrayList<JRightPadded<Statement>>(treesGroupedByStartPosition.size());
        for (java.util.List treeGroup : treesGroupedByStartPosition.values()) {
            if (treeGroup.size() == 1) {
                com.sun.source.tree.Tree t = (com.sun.source.tree.Tree)treeGroup.get(0);
                int startPosition = ((JCTree)t).getStartPosition();
                if (this.cursor > startPosition) continue;
                if (!(t instanceof JCTree.JCSkip)) {
                    while (this.cursor < startPosition) {
                        int semicolonIndex;
                        int nonWhitespaceIndex = StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source);
                        int n = semicolonIndex = this.source.charAt(nonWhitespaceIndex) == ';' ? nonWhitespaceIndex : -1;
                        if (semicolonIndex <= -1) break;
                        Space prefix = Space.format((String)this.source, (int)this.cursor, (int)semicolonIndex);
                        converted.add((JRightPadded<Statement>)new JRightPadded((Object)new J.Empty(Tree.randomId(), prefix, Markers.EMPTY), Space.EMPTY, Markers.EMPTY));
                        this.cursor = semicolonIndex + 1;
                    }
                }
                converted.add(this.convert((com.sun.source.tree.Tree)treeGroup.get(0), suffix));
                continue;
            }
            String prefix = this.source.substring(this.cursor, Math.max(((JCTree)treeGroup.get(0)).getStartPosition(), this.cursor));
            this.cursor += prefix.length();
            com.sun.source.tree.Tree last = (com.sun.source.tree.Tree)treeGroup.get(treeGroup.size() - 1);
            J.VariableDeclarations vars = this.visitVariables(treeGroup, Space.format((String)prefix));
            JRightPadded<J.VariableDeclarations> paddedVars = this.padRight(vars, this.semiDelim.apply(last));
            this.cursor(Math.max(this.endPos(last), this.cursor));
            converted.add(paddedVars);
        }
        return converted;
    }

    private static boolean isLombokGenerated(com.sun.source.tree.Tree t) {
        com.sun.source.tree.Tree tree = t instanceof JCTree.JCAnnotation ? ((JCTree.JCAnnotation)t).getAnnotationType() : t;
        Symbol sym = ReloadableJava17ParserVisitor.extractSymbol(tree);
        if (sym == null) {
            return false;
        }
        return ReloadableJava17ParserVisitor.isLombokAnnotationType(sym.getQualifiedName().toString()) || sym.getDeclarationAttributes().stream().map(a -> a.type.toString()).anyMatch(ReloadableJava17ParserVisitor::isLombokAnnotationType);
    }

    private static boolean isLombokAnnotationType(String name) {
        return "lombok.val".equals(name) || "lombok.var".equals(name) || "lombok.Generated".equals(name);
    }

    private static @Nullable Symbol extractSymbol(com.sun.source.tree.Tree tree) {
        if (tree instanceof JCTree.JCIdent) {
            return ((JCTree.JCIdent)tree).sym;
        }
        if (tree instanceof JCTree.JCMethodDecl) {
            return ((JCTree.JCMethodDecl)tree).sym;
        }
        if (tree instanceof JCTree.JCClassDecl) {
            return ((JCTree.JCClassDecl)tree).sym;
        }
        if (tree instanceof JCTree.JCVariableDecl) {
            return ((JCTree.JCVariableDecl)tree).sym;
        }
        return null;
    }

    private int endPos(com.sun.source.tree.Tree t) {
        return ((JCTree)t).getEndPosition(this.endPosTable);
    }

    private Space sourceBefore(String untilDelim) {
        return this.sourceBefore(untilDelim, null);
    }

    private Space sourceBefore(String untilDelim, @Nullable Character stop) {
        int delimIndex = this.positionOfNext(untilDelim, stop);
        if (delimIndex < 0) {
            return Space.EMPTY;
        }
        if (delimIndex == this.cursor) {
            this.cursor += untilDelim.length();
            return Space.EMPTY;
        }
        Space space = Space.format((String)this.source, (int)this.cursor, (int)delimIndex);
        this.cursor = delimIndex + untilDelim.length();
        return space;
    }

    private <T> JRightPadded<T> padRight(T tree, Space right) {
        return new JRightPadded(tree, right, Markers.EMPTY);
    }

    private <T> JLeftPadded<T> padLeft(Space left, T tree) {
        return new JLeftPadded(left, tree, Markers.EMPTY);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int positionOfNext(String untilDelim, @Nullable Character stop) {
        int delimIndex;
        boolean inMultiLineComment = false;
        boolean inSingleLineComment = false;
        block8: for (delimIndex = this.cursor; delimIndex < this.source.length() - untilDelim.length() + 1; ++delimIndex) {
            if (inSingleLineComment) {
                if (this.source.charAt(delimIndex) != '\n') continue;
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() - untilDelim.length() > delimIndex + 1) {
                char c1 = this.source.charAt(delimIndex);
                char c2 = this.source.charAt(delimIndex + 1);
                block0 : switch (c1) {
                    case '/': {
                        switch (c2) {
                            case '/': {
                                inSingleLineComment = !inMultiLineComment;
                                ++delimIndex;
                                break block0;
                            }
                            case '*': {
                                inMultiLineComment = true;
                                ++delimIndex;
                                break block0;
                            }
                        }
                        break;
                    }
                    case '*': {
                        if (c2 != '/') break;
                        inMultiLineComment = false;
                        ++delimIndex;
                        continue block8;
                    }
                }
            }
            if (inMultiLineComment || inSingleLineComment) continue;
            if (stop != null && this.source.charAt(delimIndex) == stop.charValue()) {
                return -1;
            }
            if (this.source.startsWith(untilDelim, delimIndex)) break;
        }
        if (delimIndex > this.source.length() - untilDelim.length()) {
            return -1;
        }
        int n = delimIndex;
        return n;
    }

    private Space whitespace() {
        int nextNonWhitespace = StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source);
        if (nextNonWhitespace == this.cursor) {
            return Space.EMPTY;
        }
        Space space = Space.format((String)this.source, (int)this.cursor, (int)nextNonWhitespace);
        this.cursor = nextNonWhitespace;
        return space;
    }

    private @Nullable String skip(@Nullable String token) {
        if (token == null) {
            return null;
        }
        if (this.source.startsWith(token, this.cursor)) {
            this.cursor += token.length();
            return token;
        }
        return null;
    }

    private void cursor(int n) {
        this.cursor = n;
    }

    private boolean hasFlag(ModifiersTree modifiers, long flag) {
        return this.hasFlag(((JCTree.JCModifiers)modifiers).flags, flag);
    }

    private boolean hasFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    private java.util.List<String> listFlags(long flags) {
        Map<String, Long> allFlags = Arrays.stream(Flags.class.getDeclaredFields()).filter(field -> {
            field.setAccessible(true);
            try {
                return field.get(null) instanceof Long && field.getName().matches("[A-Z_]+");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toMap(Field::getName, field -> {
            try {
                return (Long)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }));
        ArrayList<String> all = new ArrayList<String>(allFlags.size());
        for (Map.Entry<String, Long> flagNameAndCode : allFlags.entrySet()) {
            if ((flagNameAndCode.getValue() & flags) == 0L) continue;
            all.add(flagNameAndCode.getKey());
        }
        return all;
    }

    private ReloadableJava17ModifierResults sortedModifiersAndAnnotations(ModifiersTree modifiers, Map<Integer, JCTree.JCAnnotation> annotationPosTable) {
        ArrayList leadingAnnotations = new ArrayList();
        ArrayList sortedModifiers = new ArrayList();
        ArrayList<Object> currentAnnotations = new ArrayList<J.Annotation>(2);
        boolean afterFirstModifier = false;
        boolean inComment = false;
        boolean inMultilineComment = false;
        int afterLastModifierPosition = this.cursor;
        int lastAnnotationPosition = this.cursor;
        boolean noSpace = false;
        int keywordStartIdx = -1;
        for (int i = this.cursor; i < this.source.length(); ++i) {
            if (annotationPosTable.containsKey(i)) {
                JCTree.JCAnnotation jcAnnotation = annotationPosTable.get(i);
                if (ReloadableJava17ParserVisitor.isLombokGenerated(jcAnnotation.getAnnotationType())) continue;
                J.Annotation annotation = (J.Annotation)this.convert(jcAnnotation);
                if (afterFirstModifier) {
                    currentAnnotations.add(annotation);
                } else {
                    leadingAnnotations.add(annotation);
                }
                i = this.cursor - 1;
                lastAnnotationPosition = this.cursor;
                continue;
            }
            char c = this.source.charAt(i);
            if (c == '/' && this.source.length() > i + 1) {
                char next = this.source.charAt(i + 1);
                if (next == '*') {
                    inMultilineComment = true;
                } else if (next == '/') {
                    inComment = true;
                }
            }
            if (inMultilineComment && c == '/' && this.source.charAt(i - 1) == '*') {
                inMultilineComment = false;
                continue;
            }
            if (inComment && c == '\n' || c == '\r') {
                inComment = false;
                continue;
            }
            if (inMultilineComment || inComment) continue;
            if (Character.isWhitespace(c) || (noSpace = i + 1 < this.source.length() && this.source.charAt(i + 1) == '@')) {
                if (keywordStartIdx == -1) continue;
                Modifier matching = MODIFIER_BY_KEYWORD.get(this.source.substring(keywordStartIdx, noSpace ? i + 1 : i));
                keywordStartIdx = -1;
                if (matching == null) {
                    this.cursor = afterLastModifierPosition;
                    break;
                }
                sortedModifiers.add(this.mapModifier(matching, currentAnnotations));
                afterFirstModifier = true;
                currentAnnotations = new ArrayList(2);
                afterLastModifierPosition = this.cursor;
                continue;
            }
            if (keywordStartIdx != -1) continue;
            keywordStartIdx = i;
        }
        if (sortedModifiers.isEmpty()) {
            this.cursor = lastAnnotationPosition;
        }
        return new ReloadableJava17ModifierResults(leadingAnnotations.isEmpty() ? Collections.emptyList() : leadingAnnotations, sortedModifiers.isEmpty() ? Collections.emptyList() : sortedModifiers);
    }

    private J.Modifier mapModifier(Modifier mod, java.util.List<J.Annotation> annotations) {
        Space modFormat = this.whitespace();
        this.cursor += mod.name().length();
        return new J.Modifier(Tree.randomId(), modFormat, Markers.EMPTY, null, switch (mod) {
            case Modifier.DEFAULT -> J.Modifier.Type.Default;
            case Modifier.PUBLIC -> J.Modifier.Type.Public;
            case Modifier.PROTECTED -> J.Modifier.Type.Protected;
            case Modifier.PRIVATE -> J.Modifier.Type.Private;
            case Modifier.ABSTRACT -> J.Modifier.Type.Abstract;
            case Modifier.STATIC -> J.Modifier.Type.Static;
            case Modifier.FINAL -> J.Modifier.Type.Final;
            case Modifier.NATIVE -> J.Modifier.Type.Native;
            case Modifier.STRICTFP -> J.Modifier.Type.Strictfp;
            case Modifier.SYNCHRONIZED -> J.Modifier.Type.Synchronized;
            case Modifier.TRANSIENT -> J.Modifier.Type.Transient;
            case Modifier.VOLATILE -> J.Modifier.Type.Volatile;
            case Modifier.SEALED -> J.Modifier.Type.Sealed;
            case Modifier.NON_SEALED -> J.Modifier.Type.NonSealed;
            default -> throw new IllegalArgumentException("Unexpected modifier " + String.valueOf((Object)mod));
        }, annotations);
    }

    private java.util.List<J.Annotation> collectAnnotations(Map<Integer, JCTree.JCAnnotation> annotationPosTable) {
        int maxAnnotationPosition = 0;
        for (Integer pos : annotationPosTable.keySet()) {
            if (pos <= maxAnnotationPosition) continue;
            maxAnnotationPosition = pos;
        }
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>();
        boolean inComment = false;
        boolean inMultilineComment = false;
        for (int i = this.cursor; i <= maxAnnotationPosition && i < this.source.length(); ++i) {
            if (annotationPosTable.containsKey(i)) {
                JCTree.JCAnnotation jcAnnotation = annotationPosTable.get(i);
                if (ReloadableJava17ParserVisitor.isLombokGenerated(jcAnnotation)) continue;
                annotations.add((J.Annotation)this.convert(jcAnnotation));
                i = this.cursor - 1;
                continue;
            }
            char c = this.source.charAt(i);
            if (c == '/' && this.source.length() > i + 1) {
                char next = this.source.charAt(i + 1);
                if (next == '*') {
                    inMultilineComment = true;
                } else if (next == '/') {
                    inComment = true;
                }
            }
            if (inMultilineComment && c == '/' && i > 0 && this.source.charAt(i - 1) == '*') {
                inMultilineComment = false;
                continue;
            }
            if (inComment && c == '\n' || c == '\r') {
                inComment = false;
                continue;
            }
            if (!inMultilineComment && !inComment && !Character.isWhitespace(c)) break;
        }
        return annotations;
    }

    Space formatWithCommentTree(String prefix, JCTree tree, @Nullable DocCommentTree commentTree) {
        Space fmt = Space.format((String)prefix);
        if (commentTree != null) {
            Comment comment;
            int i;
            java.util.List comments = fmt.getComments();
            for (i = comments.size() - 1; !(i < 0 || (comment = (Comment)comments.get(i)).isMultiline() && ((TextComment)comment).getText().startsWith("*")); --i) {
            }
            AtomicReference<Javadoc.DocComment> javadoc = new AtomicReference<Javadoc.DocComment>();
            for (int j2 = 0; j2 < comments.size(); ++j2) {
                if (i != j2) continue;
                javadoc.set((Javadoc.DocComment)new ReloadableJava17JavadocVisitor(this.context, this.getCurrentPath(), this.typeMapping, "/*" + ((TextComment)comments.get(j2)).getText(), tree).scan(commentTree, new ArrayList(1)));
                break;
            }
            int javadocIndex = i;
            return fmt.withComments(ListUtils.map((java.util.List)fmt.getComments(), (j, c) -> j == javadocIndex ? ((Javadoc.DocComment)javadoc.get()).withSuffix(c.getSuffix()) : c));
        }
        return fmt;
    }

    private void addPossibleEmptyStatementsBeforeClosingBrace(java.util.List<JRightPadded<Statement>> converted) {
        while (true) {
            int closingBracePosition = this.positionOfNext("}", null);
            int semicolonPosition = this.positionOfNext(";", null);
            if (semicolonPosition <= -1 || semicolonPosition >= closingBracePosition) break;
            converted.add((JRightPadded<Statement>)new JRightPadded((Object)new J.Empty(Tree.randomId(), this.sourceBefore(";"), Markers.EMPTY), Space.EMPTY, Markers.EMPTY));
            this.cursor = semicolonPosition + 1;
        }
    }
}

