/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.nio.file.Paths;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.SearchResult;

public final class ChangePackage
extends Recipe {
    @Option(displayName="Old package name", description="The package name to replace.", example="com.yourorg.foo")
    private final String oldPackageName;
    @Option(displayName="New package name", description="New package name to replace the old package name with.", example="com.yourorg.bar")
    private final String newPackageName;
    @Option(displayName="Recursive", description="Recursively change subpackage names", required=false)
    private final @Nullable Boolean recursive;

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.oldPackageName, this.newPackageName);
    }

    public String getDisplayName() {
        return "Rename package name";
    }

    public String getDescription() {
        return "A recipe that will rename a package name in package statements, imports, and fully-qualified types.";
    }

    public Validated<Object> validate() {
        return Validated.none().and(Validated.notBlank((String)"oldPackageName", (String)this.oldPackageName)).and(Validated.required((String)"newPackageName", (Object)this.newPackageName));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaIsoVisitor<ExecutionContext> condition = new JavaIsoVisitor<ExecutionContext>(){

            public @Nullable J preVisit(J tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    String original;
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    if (cu.getPackageDeclaration() != null && (original = cu.getPackageDeclaration().getExpression().printTrimmed(this.getCursor()).replaceAll("\\s", "")).startsWith(ChangePackage.this.oldPackageName)) {
                        return (J)SearchResult.found((Tree)cu);
                    }
                    boolean recursive = Boolean.TRUE.equals(ChangePackage.this.recursive);
                    String recursivePackageNamePrefix = ChangePackage.this.oldPackageName + ".";
                    for (J.Import anImport : cu.getImports()) {
                        String importedPackage = anImport.getPackageName();
                        if (!importedPackage.equals(ChangePackage.this.oldPackageName) && (!recursive || !importedPackage.startsWith(recursivePackageNamePrefix))) continue;
                        return (J)SearchResult.found((Tree)cu);
                    }
                    for (JavaType type : cu.getTypesInUse().getTypesInUse()) {
                        String packageName;
                        if (!(type instanceof JavaType.FullyQualified) || !(packageName = ((JavaType.FullyQualified)type).getPackageName()).equals(ChangePackage.this.oldPackageName) && (!recursive || !packageName.startsWith(recursivePackageNamePrefix))) continue;
                        return (J)SearchResult.found((Tree)cu);
                    }
                    this.stopAfterPreVisit();
                }
                return (J)super.preVisit((Tree)tree, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)condition, (TreeVisitor)new ChangePackageVisitor());
    }

    @Generated
    public ChangePackage(String oldPackageName, String newPackageName, @Nullable Boolean recursive) {
        this.oldPackageName = oldPackageName;
        this.newPackageName = newPackageName;
        this.recursive = recursive;
    }

    @Generated
    public String getOldPackageName() {
        return this.oldPackageName;
    }

    @Generated
    public String getNewPackageName() {
        return this.newPackageName;
    }

    @Generated
    public @Nullable Boolean getRecursive() {
        return this.recursive;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePackage(oldPackageName=" + this.getOldPackageName() + ", newPackageName=" + this.getNewPackageName() + ", recursive=" + this.getRecursive() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePackage)) {
            return false;
        }
        ChangePackage other = (ChangePackage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$recursive = this.getRecursive();
        Boolean other$recursive = other.getRecursive();
        if (this$recursive == null ? other$recursive != null : !((Object)this$recursive).equals(other$recursive)) {
            return false;
        }
        String this$oldPackageName = this.getOldPackageName();
        String other$oldPackageName = other.getOldPackageName();
        if (this$oldPackageName == null ? other$oldPackageName != null : !this$oldPackageName.equals(other$oldPackageName)) {
            return false;
        }
        String this$newPackageName = this.getNewPackageName();
        String other$newPackageName = other.getNewPackageName();
        return !(this$newPackageName == null ? other$newPackageName != null : !this$newPackageName.equals(other$newPackageName));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangePackage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $recursive = this.getRecursive();
        result = result * 59 + ($recursive == null ? 43 : ((Object)$recursive).hashCode());
        String $oldPackageName = this.getOldPackageName();
        result = result * 59 + ($oldPackageName == null ? 43 : $oldPackageName.hashCode());
        String $newPackageName = this.getNewPackageName();
        result = result * 59 + ($newPackageName == null ? 43 : $newPackageName.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public ChangePackage withRecursive(@Nullable Boolean recursive) {
        return this.recursive == recursive ? this : new ChangePackage(this.oldPackageName, this.newPackageName, recursive);
    }

    private class ChangePackageVisitor
    extends JavaVisitor<ExecutionContext> {
        private static final String RENAME_TO_KEY = "renameTo";
        private static final String RENAME_FROM_KEY = "renameFrom";
        private final Map<JavaType, JavaType> oldNameToChangedType = new IdentityHashMap<JavaType, JavaType>();
        private final JavaType.Class newPackageType = JavaType.ShallowClass.build(ChangePackage.access$300(ChangePackage.this));

        private ChangePackageVisitor() {
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            Cursor parent;
            J f = super.visitFieldAccess(fieldAccess, ctx);
            if (!(!((J.FieldAccess)f).isFullyQualifiedClassReference(ChangePackage.this.oldPackageName) || (parent = this.getCursor().getParent()) == null || parent.getValue() instanceof J.FieldAccess && ((J.FieldAccess)parent.getValue()).isFullyQualifiedClassReference(ChangePackage.this.newPackageName))) {
                f = TypeTree.build(((JavaType.FullyQualified)this.newPackageType).getFullyQualifiedName()).withPrefix(f.getPrefix());
            }
            return f;
        }

        @Override
        public J visitPackage(J.Package pkg, ExecutionContext ctx) {
            String original = pkg.getExpression().printTrimmed(this.getCursor()).replaceAll("\\s", "");
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, RENAME_FROM_KEY, (Object)original);
            pkg = pkg.withAnnotations(ListUtils.map(pkg.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, ctx)));
            if (original.equals(ChangePackage.this.oldPackageName)) {
                this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, RENAME_TO_KEY, (Object)ChangePackage.this.newPackageName);
                if (!ChangePackage.this.newPackageName.isEmpty()) {
                    pkg = (J.Package)JavaTemplate.builder(ChangePackage.this.newPackageName).contextSensitive().build().apply(this.getCursor(), pkg.getCoordinates().replace(), new Object[0]);
                } else {
                    this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "UPDATE_PREFIX", (Object)true);
                    pkg = null;
                }
            } else if (this.isTargetRecursivePackageName(original)) {
                String changingTo = this.getNewPackageName(original);
                this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, RENAME_TO_KEY, (Object)changingTo);
                pkg = (J.Package)JavaTemplate.builder(changingTo).contextSensitive().build().apply(this.getCursor(), pkg.getCoordinates().replace(), new Object[0]);
            }
            return pkg;
        }

        @Override
        public J visitImport(J.Import _import, ExecutionContext ctx) {
            Boolean updatePrefix = (Boolean)this.getCursor().pollNearestMessage("UPDATE_PREFIX");
            if (updatePrefix != null && updatePrefix.booleanValue()) {
                _import = _import.withPrefix(Space.EMPTY);
            }
            return super.visitImport(_import, ctx);
        }

        @Override
        public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J c = super.visitClassDeclaration(classDecl, ctx);
            Boolean updatePrefix = (Boolean)this.getCursor().pollNearestMessage("UPDATE_PREFIX");
            if (updatePrefix != null && updatePrefix.booleanValue()) {
                c = c.withPrefix(Space.EMPTY);
            }
            return c;
        }

        @Override
        public @Nullable JavaType visitType(@Nullable JavaType javaType, ExecutionContext ctx) {
            return this.updateType(javaType);
        }

        public J postVisit(J tree, ExecutionContext ctx) {
            J j = (J)super.postVisit((Tree)tree, (Object)ctx);
            if (j instanceof J.MethodDeclaration) {
                J.MethodDeclaration m = (J.MethodDeclaration)j;
                JavaType.Method mt = this.updateType(m.getMethodType());
                return m.withMethodType(mt).withName(m.getName().withType(mt));
            }
            if (j instanceof J.MethodInvocation) {
                J.MethodInvocation m = (J.MethodInvocation)j;
                JavaType.Method mt = this.updateType(m.getMethodType());
                return m.withMethodType(mt).withName(m.getName().withType(mt));
            }
            if (j instanceof J.NewClass) {
                J.NewClass n = (J.NewClass)j;
                return n.withConstructorType(this.updateType(n.getConstructorType()));
            }
            if (j instanceof TypedTree) {
                return ((TypedTree)j).withType(this.updateType(((TypedTree)j).getType()));
            }
            if (j instanceof JavaSourceFile) {
                JavaSourceFile sf = (JavaSourceFile)j;
                String changingTo = (String)this.getCursor().getNearestMessage(RENAME_TO_KEY);
                if (changingTo != null) {
                    String path = sf.getSourcePath().toString().replace('\\', '/');
                    String changingFrom = (String)this.getCursor().getMessage(RENAME_FROM_KEY);
                    assert (changingFrom != null);
                    sf = (JavaSourceFile)sf.withSourcePath(Paths.get(path.replaceFirst(changingFrom.replace('.', '/'), changingTo.replace('.', '/')), new String[0]));
                    for (J.Import anImport : sf.getImports()) {
                        if (!anImport.getPackageName().equals(changingTo) || anImport.isStatic()) continue;
                        sf = (JavaSourceFile)new RemoveImport(anImport.getTypeName(), true).visitNonNull(sf, ctx, this.getCursor().getParentTreeCursor());
                    }
                }
                j = sf;
            }
            return j;
        }

        private @Nullable JavaType updateType(@Nullable JavaType oldType) {
            if (oldType == null || oldType instanceof JavaType.Unknown) {
                return oldType;
            }
            JavaType type = this.oldNameToChangedType.get(oldType);
            if (type != null) {
                return type;
            }
            if (oldType instanceof JavaType.Parameterized) {
                JavaType.Parameterized pt = (JavaType.Parameterized)oldType;
                if (this.isTargetFullyQualifiedType(pt = pt.withTypeParameters(ListUtils.map(pt.getTypeParameters(), tp -> {
                    JavaType.FullyQualified tpFq;
                    if (tp instanceof JavaType.FullyQualified && this.isTargetFullyQualifiedType(tpFq = (JavaType.FullyQualified)tp)) {
                        return this.updateType(tpFq);
                    }
                    return tp;
                })))) {
                    pt = pt.withType((JavaType.FullyQualified)this.updateType(pt.getType()));
                }
                this.oldNameToChangedType.put(oldType, pt);
                return pt;
            }
            if (oldType instanceof JavaType.FullyQualified) {
                JavaType.FullyQualified original = TypeUtils.asFullyQualified(oldType);
                if (this.isTargetFullyQualifiedType(original)) {
                    JavaType.FullyQualified fq = TypeUtils.asFullyQualified(JavaType.buildType(this.getNewPackageName(original.getPackageName()) + "." + original.getClassName()));
                    this.oldNameToChangedType.put(oldType, fq);
                    this.oldNameToChangedType.put(fq, fq);
                    return fq;
                }
            } else {
                if (oldType instanceof JavaType.GenericTypeVariable) {
                    JavaType.GenericTypeVariable gtv = (JavaType.GenericTypeVariable)oldType;
                    gtv = gtv.withBounds(ListUtils.map(gtv.getBounds(), b -> {
                        if (b instanceof JavaType.FullyQualified && this.isTargetFullyQualifiedType((JavaType.FullyQualified)b)) {
                            return this.updateType((JavaType)b);
                        }
                        return b;
                    }));
                    this.oldNameToChangedType.put(oldType, gtv);
                    this.oldNameToChangedType.put(gtv, gtv);
                    return gtv;
                }
                if (oldType instanceof JavaType.Variable) {
                    JavaType.Variable variable = (JavaType.Variable)oldType;
                    variable = variable.withOwner(this.updateType(variable.getOwner()));
                    variable = variable.withType(this.updateType(variable.getType()));
                    this.oldNameToChangedType.put(oldType, variable);
                    this.oldNameToChangedType.put(variable, variable);
                    return variable;
                }
                if (oldType instanceof JavaType.Array) {
                    JavaType.Array array = (JavaType.Array)oldType;
                    array = array.withElemType(this.updateType(array.getElemType()));
                    this.oldNameToChangedType.put(oldType, array);
                    this.oldNameToChangedType.put(array, array);
                    return array;
                }
            }
            return oldType;
        }

        private @Nullable JavaType.Method updateType(@Nullable JavaType.Method oldMethodType) {
            if (oldMethodType != null) {
                JavaType.Method method = (JavaType.Method)this.oldNameToChangedType.get(oldMethodType);
                if (method != null) {
                    return method;
                }
                method = oldMethodType;
                method = method.withDeclaringType((JavaType.FullyQualified)this.updateType(method.getDeclaringType())).withReturnType(this.updateType(method.getReturnType())).withParameterTypes(ListUtils.map(method.getParameterTypes(), this::updateType));
                this.oldNameToChangedType.put(oldMethodType, method);
                this.oldNameToChangedType.put(method, method);
                return method;
            }
            return null;
        }

        private String getNewPackageName(String packageName) {
            return (ChangePackage.this.recursive == null || ChangePackage.this.recursive != false) && !ChangePackage.this.newPackageName.endsWith(packageName.substring(ChangePackage.this.oldPackageName.length())) ? ChangePackage.this.newPackageName + packageName.substring(ChangePackage.this.oldPackageName.length()) : ChangePackage.this.newPackageName;
        }

        private boolean isTargetFullyQualifiedType(@Nullable JavaType.FullyQualified fq) {
            return fq != null && (fq.getPackageName().equals(ChangePackage.this.oldPackageName) && !fq.getClassName().isEmpty() || this.isTargetRecursivePackageName(fq.getPackageName()));
        }

        private boolean isTargetRecursivePackageName(String packageName) {
            return (ChangePackage.this.recursive == null || ChangePackage.this.recursive != false) && packageName.startsWith(ChangePackage.this.oldPackageName + ".") && !packageName.startsWith(ChangePackage.this.newPackageName);
        }
    }
}

