/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.coding;

import java.util.ArrayDeque;
import java.util.Deque;
import org.openrewrite.tools.checkstyle.FileStatefulCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

@FileStatefulCheck
public final class OneStatementPerLineCheck
extends AbstractCheck {
    public static final String MSG_KEY = "multiple.statements.line";
    private final Deque<Integer> countOfSemiInLambda = new ArrayDeque<Integer>();
    private int lastStatementEnd = -1;
    private int forStatementEnd = -1;
    private boolean inForHeader;
    private boolean isInLambda;
    private int lambdaStatementEnd = -1;
    private int lastVariableResourceStatementEnd = -1;
    private boolean treatTryResourcesAsStatement;

    public void setTreatTryResourcesAsStatement(boolean treatTryResourcesAsStatement) {
        this.treatTryResourcesAsStatement = treatTryResourcesAsStatement;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{45, 35, 37, 181};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.inForHeader = false;
        this.lastStatementEnd = -1;
        this.forStatementEnd = -1;
        this.isInLambda = false;
        this.lastVariableResourceStatementEnd = -1;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 45: {
                this.checkIfSemicolonIsInDifferentLineThanPrevious(ast);
                break;
            }
            case 37: {
                this.forStatementEnd = ast.getLineNo();
                break;
            }
            case 181: {
                this.isInLambda = true;
                this.countOfSemiInLambda.push(0);
                break;
            }
            default: {
                this.inForHeader = true;
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 45: {
                this.lastStatementEnd = ast.getLineNo();
                this.forStatementEnd = -1;
                this.lambdaStatementEnd = -1;
                break;
            }
            case 37: {
                this.inForHeader = false;
                break;
            }
            case 181: {
                this.countOfSemiInLambda.pop();
                if (this.countOfSemiInLambda.isEmpty()) {
                    this.isInLambda = false;
                }
                this.lambdaStatementEnd = ast.getLineNo();
                break;
            }
        }
    }

    private void checkIfSemicolonIsInDifferentLineThanPrevious(DetailAST ast) {
        boolean hasResourcesPrevSibling;
        DetailAST currentStatement = ast;
        boolean bl = hasResourcesPrevSibling = currentStatement.getPreviousSibling() != null && currentStatement.getPreviousSibling().getType() == 177;
        if (!hasResourcesPrevSibling && OneStatementPerLineCheck.isMultilineStatement(currentStatement)) {
            currentStatement = ast.getPreviousSibling();
        }
        if (this.isInLambda) {
            this.checkLambda(ast, currentStatement);
        } else if (OneStatementPerLineCheck.isResource(ast.getParent())) {
            this.checkResourceVariable(ast);
        } else if (!this.inForHeader && OneStatementPerLineCheck.isOnTheSameLine(currentStatement, this.lastStatementEnd, this.forStatementEnd, this.lambdaStatementEnd)) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private void checkLambda(DetailAST ast, DetailAST currentStatement) {
        int countOfSemiInCurrentLambda = this.countOfSemiInLambda.pop();
        this.countOfSemiInLambda.push(++countOfSemiInCurrentLambda);
        if (!this.inForHeader && countOfSemiInCurrentLambda > 1 && OneStatementPerLineCheck.isOnTheSameLine(currentStatement, this.lastStatementEnd, this.forStatementEnd, this.lambdaStatementEnd)) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private static boolean isResource(DetailAST ast) {
        return ast.getType() == 177 || ast.getType() == 176;
    }

    private void checkResourceVariable(DetailAST currentStatement) {
        if (this.treatTryResourcesAsStatement) {
            DetailAST nextNode = currentStatement.getNextSibling();
            if (currentStatement.getPreviousSibling().findFirstToken(80) != null) {
                this.lastVariableResourceStatementEnd = currentStatement.getLineNo();
            }
            if (nextNode.findFirstToken(80) != null && nextNode.getLineNo() == this.lastVariableResourceStatementEnd) {
                this.log(currentStatement, MSG_KEY, new Object[0]);
            }
        }
    }

    private static boolean isOnTheSameLine(DetailAST ast, int lastStatementEnd, int forStatementEnd, int lambdaStatementEnd) {
        return lastStatementEnd == ast.getLineNo() && forStatementEnd != ast.getLineNo() && lambdaStatementEnd != ast.getLineNo();
    }

    private static boolean isMultilineStatement(DetailAST ast) {
        DetailAST prevSibling;
        boolean multiline = ast.getPreviousSibling() == null ? false : !TokenUtil.areOnSameLine(prevSibling = ast.getPreviousSibling(), ast) && ast.getParent().getType() != 1;
        return multiline;
    }
}

