/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.internal.MavenXmlMapper;
import org.openrewrite.xml.XmlParser;

public class MavenMetadata {
    private static final XmlParser xmlParser = new XmlParser(){

        public boolean accept(Path path) {
            return super.accept(path) || path.toString().endsWith(".pom");
        }
    };
    public static final MavenMetadata EMPTY = new MavenMetadata(new Versioning(Collections.emptyList(), Collections.emptyList(), null));
    private final Versioning versioning;

    public MavenMetadata(Versioning versioning) {
        this.versioning = versioning;
    }

    public static MavenMetadata parse(InputStream document) {
        try {
            return (MavenMetadata)MavenXmlMapper.readMapper().readValue(document, MavenMetadata.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static @Nullable MavenMetadata parse(byte[] document) throws IOException {
        MavenMetadata metadata = (MavenMetadata)MavenXmlMapper.readMapper().readValue(document, MavenMetadata.class);
        if (metadata != null && metadata.getVersioning() != null && metadata.getVersioning().getVersions() == null) {
            return new MavenMetadata(new Versioning(Collections.emptyList(), metadata.getVersioning().getSnapshotVersions(), metadata.getVersioning().getSnapshot()));
        }
        return metadata;
    }

    @Generated
    public Versioning getVersioning() {
        return this.versioning;
    }

    public static class Versioning {
        private final List<String> versions;
        private final @Nullable List<SnapshotVersion> snapshotVersions;
        private final @Nullable Snapshot snapshot;

        public Versioning(@JacksonXmlElementWrapper(localName="versions") List<String> versions, @JacksonXmlElementWrapper(localName="snapshotVersions") @Nullable List<SnapshotVersion> snapshotVersions, @Nullable Snapshot snapshot) {
            this.versions = versions;
            this.snapshotVersions = snapshotVersions;
            this.snapshot = snapshot;
        }

        @Generated
        public List<String> getVersions() {
            return this.versions;
        }

        @Generated
        public @Nullable List<SnapshotVersion> getSnapshotVersions() {
            return this.snapshotVersions;
        }

        @Generated
        public @Nullable Snapshot getSnapshot() {
            return this.snapshot;
        }
    }

    public static final class Snapshot {
        private final String timestamp;
        private final String buildNumber;

        @Generated
        public Snapshot(String timestamp, String buildNumber) {
            this.timestamp = timestamp;
            this.buildNumber = buildNumber;
        }

        @Generated
        public String getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public String getBuildNumber() {
            return this.buildNumber;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Snapshot)) {
                return false;
            }
            Snapshot other = (Snapshot)o;
            String this$timestamp = this.getTimestamp();
            String other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
                return false;
            }
            String this$buildNumber = this.getBuildNumber();
            String other$buildNumber = other.getBuildNumber();
            return !(this$buildNumber == null ? other$buildNumber != null : !this$buildNumber.equals(other$buildNumber));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            String $buildNumber = this.getBuildNumber();
            result = result * 59 + ($buildNumber == null ? 43 : $buildNumber.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MavenMetadata.Snapshot(timestamp=" + this.getTimestamp() + ", buildNumber=" + this.getBuildNumber() + ")";
        }
    }

    public static final class SnapshotVersion {
        private final String extension;
        private final String value;
        private final String updated;

        @Generated
        public SnapshotVersion(String extension, String value, String updated) {
            this.extension = extension;
            this.value = value;
            this.updated = updated;
        }

        @Generated
        public String getExtension() {
            return this.extension;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public String getUpdated() {
            return this.updated;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SnapshotVersion)) {
                return false;
            }
            SnapshotVersion other = (SnapshotVersion)o;
            String this$extension = this.getExtension();
            String other$extension = other.getExtension();
            if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$updated = this.getUpdated();
            String other$updated = other.getUpdated();
            return !(this$updated == null ? other$updated != null : !this$updated.equals(other$updated));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $extension = this.getExtension();
            result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $updated = this.getUpdated();
            result = result * 59 + ($updated == null ? 43 : $updated.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MavenMetadata.SnapshotVersion(extension=" + this.getExtension() + ", value=" + this.getValue() + ", updated=" + this.getUpdated() + ")";
        }
    }
}

