/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.protobuf.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.protobuf.tree.Comment;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.protobuf.tree.ProtoRightPadded;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public class Space {
    public static final Space EMPTY = new Space("", Collections.emptyList());
    private final List<Comment> comments;
    private final @Nullable String whitespace;
    private static final Map<String, Space> flyweights = Collections.synchronizedMap(new WeakHashMap());
    private static final String[] spaces = new String[]{"\u00b7\u2081", "\u00b7\u2082", "\u00b7\u2083", "\u00b7\u2084", "\u00b7\u2085", "\u00b7\u2086", "\u00b7\u2087", "\u00b7\u2088", "\u00b7\u2089", "\u00b7\u208a"};
    private static final String[] tabs = new String[]{"-\u2081", "-\u2082", "-\u2083", "-\u2084", "-\u2085", "-\u2086", "-\u2087", "-\u2088", "-\u2089", "-\u208a"};

    private Space(@Nullable String whitespace, List<Comment> comments) {
        this.comments = comments;
        this.whitespace = whitespace == null || whitespace.isEmpty() ? null : whitespace;
    }

    @JsonCreator
    public static Space build(@Nullable String whitespace, List<Comment> comments) {
        if (comments.isEmpty()) {
            if (whitespace == null || whitespace.isEmpty()) {
                return EMPTY;
            }
            if (whitespace.length() <= 100) {
                return flyweights.computeIfAbsent(whitespace, k -> new Space(new String(whitespace), comments));
            }
        }
        return new Space(whitespace, comments);
    }

    public String getIndent() {
        if (!this.comments.isEmpty()) {
            return this.getWhitespaceIndent(this.comments.get(this.comments.size() - 1).getSuffix());
        }
        return this.getWhitespaceIndent(this.whitespace);
    }

    public String getLastWhitespace() {
        if (!this.comments.isEmpty()) {
            return this.comments.get(this.comments.size() - 1).getSuffix();
        }
        return this.whitespace == null ? "" : this.whitespace;
    }

    private String getWhitespaceIndent(@Nullable String whitespace) {
        if (whitespace == null) {
            return "";
        }
        int lastNewline = whitespace.lastIndexOf(10);
        if (lastNewline >= 0) {
            return whitespace.substring(lastNewline + 1);
        }
        if (lastNewline == whitespace.length() - 1) {
            return "";
        }
        return whitespace;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public String getWhitespace() {
        return this.whitespace == null ? "" : this.whitespace;
    }

    public boolean hasComment(String comment) {
        for (Comment c : this.comments) {
            if (!c.getText().equals(comment)) continue;
            return true;
        }
        return false;
    }

    public Space withComments(List<Comment> comments) {
        if (comments == this.comments) {
            return this;
        }
        if (comments.isEmpty() && (this.whitespace == null || this.whitespace.isEmpty())) {
            return EMPTY;
        }
        return Space.build(this.whitespace, comments);
    }

    public Space withWhitespace(String whitespace) {
        if (this.comments.isEmpty() && whitespace.isEmpty()) {
            return EMPTY;
        }
        if (whitespace.isEmpty() && this.whitespace == null || whitespace.equals(this.whitespace)) {
            return this;
        }
        return Space.build(whitespace, this.comments);
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public static Space firstPrefix(@Nullable List<? extends Proto> trees) {
        return trees == null || trees.isEmpty() ? EMPTY : trees.iterator().next().getPrefix();
    }

    public static Space format(String formatting) {
        char[] charArray;
        StringBuilder prefix = new StringBuilder();
        StringBuilder comment = new StringBuilder();
        ArrayList<Comment> comments = new ArrayList<Comment>();
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        char last = '\u0000';
        block5: for (char c : charArray = formatting.toCharArray()) {
            switch (c) {
                case '/': {
                    if (inSingleLineComment) {
                        comment.append(c);
                        break;
                    }
                    if (last == '/' && !inMultiLineComment) {
                        inSingleLineComment = true;
                        comment = new StringBuilder();
                        break;
                    }
                    if (last == '*' && inMultiLineComment && comment.length() > 0) {
                        inMultiLineComment = false;
                        comment.setLength(comment.length() - 1);
                        comments.add(new Comment(true, comment.toString(), prefix.toString(), Markers.EMPTY));
                        prefix = new StringBuilder();
                        comment = new StringBuilder();
                        continue block5;
                    }
                    comment.append(c);
                    break;
                }
                case '\n': 
                case '\r': {
                    if (inSingleLineComment) {
                        inSingleLineComment = false;
                        comments.add(new Comment(false, comment.toString(), prefix.toString(), Markers.EMPTY));
                        prefix = new StringBuilder();
                        comment = new StringBuilder();
                        prefix.append(c);
                        break;
                    }
                    if (!inMultiLineComment) {
                        prefix.append(c);
                        break;
                    }
                    comment.append(c);
                    break;
                }
                case '*': {
                    if (inSingleLineComment) {
                        comment.append(c);
                        break;
                    }
                    if (last == '/' && !inMultiLineComment) {
                        inMultiLineComment = true;
                        comment = new StringBuilder();
                        break;
                    }
                    comment.append(c);
                    break;
                }
                default: {
                    if (inSingleLineComment || inMultiLineComment) {
                        comment.append(c);
                        break;
                    }
                    prefix.append(c);
                }
            }
            last = c;
        }
        String whitespace = prefix.toString();
        if (!comments.isEmpty()) {
            for (int i = comments.size() - 1; i >= 0; --i) {
                Comment c = (Comment)comments.get(i);
                String next = c.getSuffix();
                comments.set(i, c.withSuffix(whitespace));
                whitespace = next;
            }
        }
        return Space.build(whitespace, comments);
    }

    public static <P extends Proto> List<ProtoRightPadded<P>> formatLastSuffix(@Nullable List<ProtoRightPadded<P>> trees, Space suffix) {
        if (trees == null) {
            return null;
        }
        if (!trees.isEmpty() && !trees.get(trees.size() - 1).getAfter().equals(suffix)) {
            ArrayList<ProtoRightPadded<P>> formattedTrees = new ArrayList<ProtoRightPadded<P>>(trees);
            formattedTrees.set(formattedTrees.size() - 1, ((ProtoRightPadded)formattedTrees.get(formattedTrees.size() - 1)).withAfter(suffix));
            return formattedTrees;
        }
        return trees;
    }

    public static <P extends Proto> List<P> formatFirstPrefix(List<P> trees, Space prefix) {
        if (!trees.isEmpty() && !((Proto)trees.get(0)).getPrefix().equals(prefix)) {
            ArrayList<P> formattedTrees = new ArrayList<P>(trees);
            formattedTrees.set(0, ((Proto)formattedTrees.get(0)).withPrefix(prefix));
            return formattedTrees;
        }
        return trees;
    }

    public String toString() {
        StringBuilder printedWs = new StringBuilder();
        int lastNewline = 0;
        if (this.whitespace != null) {
            char[] charArray = this.whitespace.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                char c = charArray[i];
                if (c == '\n') {
                    printedWs.append("\\n");
                    lastNewline = i + 1;
                    continue;
                }
                if (c == '\r') {
                    printedWs.append("\\r");
                    lastNewline = i + 1;
                    continue;
                }
                if (c == ' ') {
                    printedWs.append(spaces[(i - lastNewline) % 10]);
                    continue;
                }
                if (c != '\t') continue;
                printedWs.append(tabs[(i - lastNewline) % 10]);
            }
        }
        return "Space(comments=<" + (this.comments.size() == 1 ? "1 comment" : this.comments.size() + " comments") + ">, whitespace='" + printedWs + "')";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Space)) {
            return false;
        }
        Space other = (Space)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Comment> this$comments = this.getComments();
        List<Comment> other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !((Object)this$comments).equals(other$comments)) {
            return false;
        }
        String this$whitespace = this.getWhitespace();
        String other$whitespace = other.getWhitespace();
        return !(this$whitespace == null ? other$whitespace != null : !this$whitespace.equals(other$whitespace));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof Space;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Comment> $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : ((Object)$comments).hashCode());
        String $whitespace = this.getWhitespace();
        result = result * 59 + ($whitespace == null ? 43 : $whitespace.hashCode());
        return result;
    }
}

