/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.openrewrite.jgit.api.AddCommand;
import org.openrewrite.jgit.api.AddNoteCommand;
import org.openrewrite.jgit.api.ApplyCommand;
import org.openrewrite.jgit.api.ArchiveCommand;
import org.openrewrite.jgit.api.BlameCommand;
import org.openrewrite.jgit.api.CheckoutCommand;
import org.openrewrite.jgit.api.CherryPickCommand;
import org.openrewrite.jgit.api.CleanCommand;
import org.openrewrite.jgit.api.CloneCommand;
import org.openrewrite.jgit.api.CommitCommand;
import org.openrewrite.jgit.api.CreateBranchCommand;
import org.openrewrite.jgit.api.DeleteBranchCommand;
import org.openrewrite.jgit.api.DeleteTagCommand;
import org.openrewrite.jgit.api.DescribeCommand;
import org.openrewrite.jgit.api.DiffCommand;
import org.openrewrite.jgit.api.FetchCommand;
import org.openrewrite.jgit.api.GarbageCollectCommand;
import org.openrewrite.jgit.api.InitCommand;
import org.openrewrite.jgit.api.ListBranchCommand;
import org.openrewrite.jgit.api.ListNotesCommand;
import org.openrewrite.jgit.api.ListTagCommand;
import org.openrewrite.jgit.api.LogCommand;
import org.openrewrite.jgit.api.LsRemoteCommand;
import org.openrewrite.jgit.api.MergeCommand;
import org.openrewrite.jgit.api.NameRevCommand;
import org.openrewrite.jgit.api.PullCommand;
import org.openrewrite.jgit.api.PushCommand;
import org.openrewrite.jgit.api.RebaseCommand;
import org.openrewrite.jgit.api.ReflogCommand;
import org.openrewrite.jgit.api.RemoteAddCommand;
import org.openrewrite.jgit.api.RemoteListCommand;
import org.openrewrite.jgit.api.RemoteRemoveCommand;
import org.openrewrite.jgit.api.RemoteSetUrlCommand;
import org.openrewrite.jgit.api.RemoveNoteCommand;
import org.openrewrite.jgit.api.RenameBranchCommand;
import org.openrewrite.jgit.api.ResetCommand;
import org.openrewrite.jgit.api.RevertCommand;
import org.openrewrite.jgit.api.RmCommand;
import org.openrewrite.jgit.api.ShowNoteCommand;
import org.openrewrite.jgit.api.StashApplyCommand;
import org.openrewrite.jgit.api.StashCreateCommand;
import org.openrewrite.jgit.api.StashDropCommand;
import org.openrewrite.jgit.api.StashListCommand;
import org.openrewrite.jgit.api.StatusCommand;
import org.openrewrite.jgit.api.SubmoduleAddCommand;
import org.openrewrite.jgit.api.SubmoduleDeinitCommand;
import org.openrewrite.jgit.api.SubmoduleInitCommand;
import org.openrewrite.jgit.api.SubmoduleStatusCommand;
import org.openrewrite.jgit.api.SubmoduleSyncCommand;
import org.openrewrite.jgit.api.SubmoduleUpdateCommand;
import org.openrewrite.jgit.api.TagCommand;
import org.openrewrite.jgit.api.VerifySignatureCommand;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.lib.RepositoryBuilder;
import org.openrewrite.jgit.lib.RepositoryCache;
import org.openrewrite.jgit.lib.internal.WorkQueue;
import org.openrewrite.jgit.nls.NLS;
import org.openrewrite.jgit.util.FS;

public class Git
implements AutoCloseable {
    private final Repository repo;
    private final boolean closeRepo;

    public static Git open(File dir) throws IOException {
        return Git.open(dir, FS.DETECTED);
    }

    public static Git open(File dir, FS fs) throws IOException {
        RepositoryCache.FileKey key = RepositoryCache.FileKey.lenient(dir, fs);
        Object db = ((RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setFS(fs)).setGitDir(key.getFile())).setMustExist(true)).build();
        return new Git((Repository)db, true);
    }

    public static Git wrap(Repository repo) {
        return new Git(repo);
    }

    @Override
    public void close() {
        if (this.closeRepo) {
            this.repo.close();
        }
    }

    public static CloneCommand cloneRepository() {
        return new CloneCommand();
    }

    public static LsRemoteCommand lsRemoteRepository() {
        return new LsRemoteCommand(null);
    }

    public static InitCommand init() {
        return new InitCommand();
    }

    public static void shutdown() {
        WorkQueue.getExecutor().shutdownNow();
        NLS.clear();
    }

    public Git(Repository repo) {
        this(repo, false);
    }

    Git(Repository repo, boolean closeRepo) {
        this.repo = Objects.requireNonNull(repo);
        this.closeRepo = closeRepo;
    }

    public CommitCommand commit() {
        return new CommitCommand(this.repo);
    }

    public LogCommand log() {
        return new LogCommand(this.repo);
    }

    public MergeCommand merge() {
        return new MergeCommand(this.repo);
    }

    public PullCommand pull() {
        return new PullCommand(this.repo);
    }

    public CreateBranchCommand branchCreate() {
        return new CreateBranchCommand(this.repo);
    }

    public DeleteBranchCommand branchDelete() {
        return new DeleteBranchCommand(this.repo);
    }

    public ListBranchCommand branchList() {
        return new ListBranchCommand(this.repo);
    }

    public ListTagCommand tagList() {
        return new ListTagCommand(this.repo);
    }

    public RenameBranchCommand branchRename() {
        return new RenameBranchCommand(this.repo);
    }

    public AddCommand add() {
        return new AddCommand(this.repo);
    }

    public TagCommand tag() {
        return new TagCommand(this.repo);
    }

    public FetchCommand fetch() {
        return new FetchCommand(this.repo);
    }

    public PushCommand push() {
        return new PushCommand(this.repo);
    }

    public CherryPickCommand cherryPick() {
        return new CherryPickCommand(this.repo);
    }

    public RevertCommand revert() {
        return new RevertCommand(this.repo);
    }

    public RebaseCommand rebase() {
        return new RebaseCommand(this.repo);
    }

    public RmCommand rm() {
        return new RmCommand(this.repo);
    }

    public CheckoutCommand checkout() {
        return new CheckoutCommand(this.repo);
    }

    public ResetCommand reset() {
        return new ResetCommand(this.repo);
    }

    public StatusCommand status() {
        return new StatusCommand(this.repo);
    }

    public ArchiveCommand archive() {
        return new ArchiveCommand(this.repo);
    }

    public AddNoteCommand notesAdd() {
        return new AddNoteCommand(this.repo);
    }

    public RemoveNoteCommand notesRemove() {
        return new RemoveNoteCommand(this.repo);
    }

    public ListNotesCommand notesList() {
        return new ListNotesCommand(this.repo);
    }

    public ShowNoteCommand notesShow() {
        return new ShowNoteCommand(this.repo);
    }

    public LsRemoteCommand lsRemote() {
        return new LsRemoteCommand(this.repo);
    }

    public CleanCommand clean() {
        return new CleanCommand(this.repo);
    }

    public BlameCommand blame() {
        return new BlameCommand(this.repo);
    }

    public ReflogCommand reflog() {
        return new ReflogCommand(this.repo);
    }

    public DiffCommand diff() {
        return new DiffCommand(this.repo);
    }

    public DeleteTagCommand tagDelete() {
        return new DeleteTagCommand(this.repo);
    }

    public SubmoduleAddCommand submoduleAdd() {
        return new SubmoduleAddCommand(this.repo);
    }

    public SubmoduleInitCommand submoduleInit() {
        return new SubmoduleInitCommand(this.repo);
    }

    public SubmoduleDeinitCommand submoduleDeinit() {
        return new SubmoduleDeinitCommand(this.repo);
    }

    public SubmoduleStatusCommand submoduleStatus() {
        return new SubmoduleStatusCommand(this.repo);
    }

    public SubmoduleSyncCommand submoduleSync() {
        return new SubmoduleSyncCommand(this.repo);
    }

    public SubmoduleUpdateCommand submoduleUpdate() {
        return new SubmoduleUpdateCommand(this.repo);
    }

    public StashListCommand stashList() {
        return new StashListCommand(this.repo);
    }

    public StashCreateCommand stashCreate() {
        return new StashCreateCommand(this.repo);
    }

    public StashApplyCommand stashApply() {
        return new StashApplyCommand(this.repo);
    }

    public StashDropCommand stashDrop() {
        return new StashDropCommand(this.repo);
    }

    public ApplyCommand apply() {
        return new ApplyCommand(this.repo);
    }

    public GarbageCollectCommand gc() {
        return new GarbageCollectCommand(this.repo);
    }

    public NameRevCommand nameRev() {
        return new NameRevCommand(this.repo);
    }

    public DescribeCommand describe() {
        return new DescribeCommand(this.repo);
    }

    public RemoteListCommand remoteList() {
        return new RemoteListCommand(this.repo);
    }

    public RemoteAddCommand remoteAdd() {
        return new RemoteAddCommand(this.repo);
    }

    public RemoteRemoveCommand remoteRemove() {
        return new RemoteRemoveCommand(this.repo);
    }

    public RemoteSetUrlCommand remoteSetUrl() {
        return new RemoteSetUrlCommand(this.repo);
    }

    public VerifySignatureCommand verifySignature() {
        return new VerifySignatureCommand(this.repo);
    }

    public Repository getRepository() {
        return this.repo;
    }

    public String toString() {
        return "Git[" + this.repo + "]";
    }
}

