/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.index;

import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.saml.metadata.resolver.index.SimpleStringMetadataIndexKey;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimpleStringMetadataIndexKeyTest {
    @Test
    public void testConstructor() {
        SimpleStringMetadataIndexKey key = null;
        key = new SimpleStringMetadataIndexKey("foobar");
        Assert.assertEquals((String)key.getValue(), (String)"foobar");
        key = new SimpleStringMetadataIndexKey("  foobar  ");
        Assert.assertEquals((String)key.getValue(), (String)"foobar");
        key = new SimpleStringMetadataIndexKey("barney");
        Assert.assertNotEquals((Object)key.getValue(), (Object)"foobar");
        try {
            key = new SimpleStringMetadataIndexKey("  ");
            Assert.fail((String)"Constructor should have failed on empty input");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            key = new SimpleStringMetadataIndexKey(null);
            Assert.fail((String)"Constructor should have failed on null input");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testToString() {
        SimpleStringMetadataIndexKey key = new SimpleStringMetadataIndexKey("foobar");
        Assert.assertEquals((String)key.toString(), (String)"SimpleStringMetadataIndexKey{foobar}");
    }

    @Test
    public void testHashCodeAndEquals() {
        SimpleStringMetadataIndexKey key2 = null;
        SimpleStringMetadataIndexKey key1 = new SimpleStringMetadataIndexKey("foobar");
        key2 = new SimpleStringMetadataIndexKey("foobar");
        Assert.assertTrue((boolean)key1.equals((Object)key2));
        Assert.assertTrue((key1.hashCode() == key2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)key2.equals((Object)key1));
        Assert.assertTrue((boolean)key1.equals((Object)key1));
        Assert.assertFalse((boolean)key1.equals((Object)"foobar"));
        key2 = new SimpleStringMetadataIndexKey("barney");
        Assert.assertFalse((boolean)key1.equals((Object)key2));
        Assert.assertFalse((boolean)key2.equals((Object)key1));
    }
}

