/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.core.api.solver.DivertingClassLoader;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.phase.custom.CustomPhaseConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.phase.custom.NoChangeCustomPhaseCommand;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.util.KieContainerHelper;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;

public class PlannerBenchmarkFactoryTest {
    private static File benchmarkTestDir;
    private static File benchmarkOutputTestDir;

    @BeforeClass
    public static void setup() throws IOException {
        benchmarkTestDir = new File("target/test/benchmarkTest/");
        benchmarkTestDir.mkdirs();
        new File(benchmarkTestDir, "input.xml").createNewFile();
        benchmarkOutputTestDir = new File(benchmarkTestDir, "output/");
        benchmarkOutputTestDir.mkdir();
    }

    @Test
    public void createFromSolverConfigXmlResource() {
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.createFromSolverConfigXmlResource((String)"org/optaplanner/core/config/solver/testdataSolverConfig.xml");
        TestdataSolution solution = new TestdataSolution("s1");
        solution.setEntityList(Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3")));
        solution.setValueList(Arrays.asList(new TestdataValue("v1"), new TestdataValue("v2")));
        Assert.assertNotNull((Object)benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataSolution[]{solution}));
        benchmarkFactory = PlannerBenchmarkFactory.createFromSolverConfigXmlResource((String)"org/optaplanner/core/config/solver/testdataSolverConfig.xml", (File)benchmarkOutputTestDir);
        Assert.assertNotNull((Object)benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataSolution[]{solution}));
    }

    @Test
    public void createFromSolverConfigXmlResource_classLoader() {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.createFromSolverConfigXmlResource((String)"divertThroughClassLoader/org/optaplanner/core/api/solver/classloaderTestdataSolverConfig.xml", (ClassLoader)classLoader);
        TestdataSolution solution = new TestdataSolution("s1");
        solution.setEntityList(Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3")));
        solution.setValueList(Arrays.asList(new TestdataValue("v1"), new TestdataValue("v2")));
        Assert.assertNotNull((Object)benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataSolution[]{solution}));
        benchmarkFactory = PlannerBenchmarkFactory.createFromSolverConfigXmlResource((String)"divertThroughClassLoader/org/optaplanner/core/api/solver/classloaderTestdataSolverConfig.xml", (File)benchmarkOutputTestDir, (ClassLoader)classLoader);
        Assert.assertNotNull((Object)benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataSolution[]{solution}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void problemIsNotASolutionInstance() {
        SolverConfig solverConfig = PlannerTestUtils.buildSolverConfig(TestdataSolution.class, (Class[])new Class[]{TestdataEntity.class});
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)PlannerBenchmarkConfig.createFromSolverConfig((SolverConfig)solverConfig));
        benchmarkFactory.buildPlannerBenchmark((Object[])new String[]{"This is not a solution instance."});
    }

    @Test(expected=IllegalArgumentException.class)
    public void problemIsNull() {
        SolverConfig solverConfig = PlannerTestUtils.buildSolverConfig(TestdataSolution.class, (Class[])new Class[]{TestdataEntity.class});
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)PlannerBenchmarkConfig.createFromSolverConfig((SolverConfig)solverConfig));
        TestdataSolution solution = new TestdataSolution("s1");
        solution.setEntityList(Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3")));
        solution.setValueList(Arrays.asList(new TestdataValue("v1"), new TestdataValue("v2")));
        benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataSolution[]{solution, null});
    }

    @Test
    @Deprecated
    public void createFromSolverFactory() {
        SolverConfig solverConfig = PlannerTestUtils.buildSolverConfig(TestdataSolution.class, (Class[])new Class[]{TestdataEntity.class});
        SolverFactory solverFactory = SolverFactory.create((SolverConfig)solverConfig);
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.createFromSolverFactory((SolverFactory)solverFactory);
        TestdataSolution solution = new TestdataSolution("s1");
        solution.setEntityList(Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3")));
        solution.setValueList(Arrays.asList(new TestdataValue("v1"), new TestdataValue("v2")));
        PlannerBenchmark benchmark = benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataSolution[]{solution});
        benchmark.benchmark();
    }

    @Test
    public void createFromXmlResource() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"org/optaplanner/benchmark/api/testdataBenchmarkConfig.xml");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void createFromXmlResource_classLoader() {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"divertThroughClassLoader/org/optaplanner/benchmark/api/classloaderTestdataBenchmarkConfig.xml", (ClassLoader)classLoader);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromXmlResource_nonExisting() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"org/optaplanner/benchmark/api/nonExistingBenchmarkConfig.xml");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void createFromXmlResource_uninitializedBestSolution() {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)"org/optaplanner/benchmark/api/testdataBenchmarkConfig.xml");
        SolverBenchmarkConfig solverBenchmarkConfig = (SolverBenchmarkConfig)benchmarkConfig.getSolverBenchmarkConfigList().get(0);
        CustomPhaseConfig phaseConfig = new CustomPhaseConfig();
        phaseConfig.setCustomPhaseCommandClassList(Collections.singletonList(NoChangeCustomPhaseCommand.class));
        solverBenchmarkConfig.getSolverConfig().setPhaseConfigList(Collections.singletonList(phaseConfig));
        PlannerBenchmark plannerBenchmark = PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)benchmarkConfig).buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void createFromXmlResource_subSingleCount() {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)"org/optaplanner/benchmark/api/testdataBenchmarkConfig.xml");
        SolverBenchmarkConfig solverBenchmarkConfig = (SolverBenchmarkConfig)benchmarkConfig.getSolverBenchmarkConfigList().get(0);
        solverBenchmarkConfig.setSubSingleCount(Integer.valueOf(3));
        PlannerBenchmark plannerBenchmark = PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)benchmarkConfig).buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void createFromXmlFile() throws IOException {
        File file = new File(benchmarkTestDir, "testdataBenchmarkConfig.xml");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/optaplanner/benchmark/api/testdataBenchmarkConfig.xml");){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlFile((File)file);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void createFromXmlFile_classLoader() throws IOException {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        File file = new File(benchmarkTestDir, "classloaderTestdataBenchmarkConfig.xml");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/optaplanner/benchmark/api/classloaderTestdataBenchmarkConfig.xml");){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlFile((File)file, (ClassLoader)classLoader);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void createFromFreemarkerXmlResource() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)"org/optaplanner/benchmark/api/testdataBenchmarkConfigTemplate.xml.ftl");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void createFromFreemarkerXmlResource_classLoader() {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)"divertThroughClassLoader/org/optaplanner/benchmark/api/classloaderTestdataBenchmarkConfigTemplate.xml.ftl", (ClassLoader)classLoader);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromFreemarkerXmlResource_nonExisting() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)"org/optaplanner/benchmark/api/nonExistingBenchmarkConfigTemplate.xml.ftl");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void createFromFreemarkerXmlFile() throws IOException {
        File file = new File(benchmarkTestDir, "testdataBenchmarkConfigTemplate.xml.ftl");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/optaplanner/benchmark/api/testdataBenchmarkConfigTemplate.xml.ftl");){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlFile((File)file);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void createFromFreemarkerXmlFile_classLoader() throws IOException {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        File file = new File(benchmarkTestDir, "classloaderTestdataBenchmarkConfigTemplate.xml.ftl");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/optaplanner/benchmark/api/classloaderTestdataBenchmarkConfigTemplate.xml.ftl");){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlFile((File)file, (ClassLoader)classLoader);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void createFromReleaseId() throws IOException {
        ReleaseId releaseId = this.deployTestingKjar();
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromKieContainerXmlResource((ReleaseId)releaseId, (String)"testdata/kjar/benchmarkConfig.solver");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    @Test
    public void createFromKieContainer() throws IOException {
        ReleaseId releaseId = this.deployTestingKjar();
        KieContainer kieContainer = KieServices.Factory.get().newKieContainer(releaseId);
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromKieContainerXmlResource((KieContainer)kieContainer, (String)"testdata/kjar/benchmarkConfig.solver");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assert.assertNotNull((Object)plannerBenchmark);
        plannerBenchmark.benchmark();
    }

    private ReleaseId deployTestingKjar() throws IOException {
        KieContainerHelper kieContainerHelper = new KieContainerHelper();
        ReleaseId releaseId = kieContainerHelper.deployTestdataBenchmarkKjar("buildSolverWithReleaseId", "org/optaplanner/benchmark/api/kieContainerNamedKsessionKmodule.xml", "org/optaplanner/benchmark/api/testdataKieContainerBenchmarkConfig.xml");
        return releaseId;
    }
}

