/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.StatisticUtils;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;

public class StatisticUtilsTest {
    private static final double DELTA = 0.001;

    @Test
    public void singleDetermineStandardDeviationDoubles() {
        List<SubSingleBenchmarkResult> subSingleBenchmarkResultList = Arrays.asList(this.createSubSingleBenchmarkResult((Score)SimpleScore.of((int)0), 0));
        Assertions.assertThat((double[])StatisticUtils.determineStandardDeviationDoubles(subSingleBenchmarkResultList, (Score)SimpleScore.of((int)0), (int)subSingleBenchmarkResultList.size())).containsSequence(new double[]{0.0}, Offset.offset((Number)0.001));
    }

    @Test
    public void multipleDetermineStandardDeviationDoubles() {
        ArrayList<SubSingleBenchmarkResult> subSingleBenchmarkResultList = new ArrayList<SubSingleBenchmarkResult>(2);
        subSingleBenchmarkResultList.add(this.createSubSingleBenchmarkResult((Score)SimpleScore.of((int)-2), 0));
        subSingleBenchmarkResultList.add(this.createSubSingleBenchmarkResult((Score)SimpleScore.of((int)-4), 1));
        Assertions.assertThat((double[])StatisticUtils.determineStandardDeviationDoubles(subSingleBenchmarkResultList, (Score)SimpleScore.of((int)-3), (int)subSingleBenchmarkResultList.size())).containsSequence(new double[]{1.0}, Offset.offset((Number)0.001));
    }

    @Test
    public void largeDetermineStandardDeviationDoubles() {
        long[] subSingleBenchmarkScores = new long[]{-19289560268L, -19345935795L, -19715516752L, -19589259253L, -19390707618L, -19641410518L};
        ArrayList<SubSingleBenchmarkResult> subSingleBenchmarkResultList = new ArrayList<SubSingleBenchmarkResult>(6);
        SimpleLongScore averageScore = SimpleLongScore.of((long)0L);
        for (int i = 0; i < subSingleBenchmarkScores.length; ++i) {
            SimpleLongScore current = SimpleLongScore.of((long)subSingleBenchmarkScores[i]);
            subSingleBenchmarkResultList.add(this.createSubSingleBenchmarkResult((Score)current, i));
            averageScore = averageScore.add(current);
        }
        averageScore = averageScore.divide((double)subSingleBenchmarkScores.length);
        Assertions.assertThat((double[])StatisticUtils.determineStandardDeviationDoubles(subSingleBenchmarkResultList, (Score)averageScore, (int)subSingleBenchmarkResultList.size())).containsSequence(new double[]{1.60338212294E8}, Offset.offset((Number)0.001));
    }

    @Test
    public void getStandardDeviationString() {
        Assertions.assertThat((String)StatisticUtils.getStandardDeviationString(null)).isEqualTo(null);
        Assertions.assertThat((String)StatisticUtils.getStandardDeviationString((double[])new double[]{2.0})).isEqualTo("2.0");
        Assertions.assertThat((String)StatisticUtils.getStandardDeviationString((double[])new double[]{Math.sqrt(2.0)})).isEqualTo("1.41");
        Assertions.assertThat((String)StatisticUtils.getStandardDeviationString((double[])new double[]{1.60338212294E8})).isEqualTo("1.6E8");
        Assertions.assertThat((String)StatisticUtils.getStandardDeviationString((double[])new double[]{2.0E9})).isEqualTo("2.0E9");
        Assertions.assertThat((String)StatisticUtils.getStandardDeviationString((double[])new double[]{2.0E10})).isEqualTo("2.0E10");
    }

    private SubSingleBenchmarkResult createSubSingleBenchmarkResult(Score score, int index) {
        SubSingleBenchmarkResult subSingleBenchmarkResult = (SubSingleBenchmarkResult)Mockito.spy((Object)new SubSingleBenchmarkResult(null, index));
        Mockito.when((Object)subSingleBenchmarkResult.getAverageScore()).thenReturn((Object)score);
        Mockito.when((Object)subSingleBenchmarkResult.hasAllSuccess()).thenReturn((Object)true);
        return subSingleBenchmarkResult;
    }
}

