/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.ranking;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.optaplanner.benchmark.impl.ranking.AbstractSolverRankingComparatorTest;
import org.optaplanner.benchmark.impl.ranking.WorstScoreSolverRankingComparator;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.score.buildin.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

class WorstScoreSolverRankingComparatorTest
extends AbstractSolverRankingComparatorTest {
    private BenchmarkReport benchmarkReport;
    private WorstScoreSolverRankingComparator comparator;
    private SolverBenchmarkResult a;
    private SolverBenchmarkResult b;
    private List<SingleBenchmarkResult> aSingleBenchmarkResultList;
    private List<SingleBenchmarkResult> bSingleBenchmarkResultList;

    WorstScoreSolverRankingComparatorTest() {
    }

    @BeforeEach
    void setUp() {
        this.benchmarkReport = (BenchmarkReport)Mockito.mock(BenchmarkReport.class);
        this.comparator = new WorstScoreSolverRankingComparator();
        this.a = new SolverBenchmarkResult(null);
        this.a.setScoreDefinition((ScoreDefinition)new SimpleScoreDefinition());
        this.b = new SolverBenchmarkResult(null);
        this.b.setScoreDefinition((ScoreDefinition)new SimpleScoreDefinition());
        this.aSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
        this.bSingleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
    }

    @Test
    void normal() {
        this.addSingleBenchmark(this.a, this.aSingleBenchmarkResultList, -100, -30, -2001);
        this.addSingleBenchmark(this.a, this.aSingleBenchmarkResultList, -2001, -30, -2001);
        this.addSingleBenchmark(this.a, this.aSingleBenchmarkResultList, -30, -30, -2001);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.addSingleBenchmark(this.b, this.bSingleBenchmarkResultList, -900, -30, -2000);
        this.addSingleBenchmark(this.b, this.bSingleBenchmarkResultList, -2000, -30, -2000);
        this.addSingleBenchmark(this.b, this.bSingleBenchmarkResultList, -30, -30, -2000);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        PlannerAssert.assertCompareToOrder((Comparator)this.comparator, (Object[])new SolverBenchmarkResult[]{this.a, this.b});
    }

    @Test
    void worstIsEqual() {
        this.addSingleBenchmark(this.a, this.aSingleBenchmarkResultList, -101, -30, -2000);
        this.addSingleBenchmark(this.a, this.aSingleBenchmarkResultList, -2000, -30, -2000);
        this.addSingleBenchmark(this.a, this.aSingleBenchmarkResultList, -30, -30, -2000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.addSingleBenchmark(this.b, this.bSingleBenchmarkResultList, -100, -40, -2000);
        this.addSingleBenchmark(this.b, this.bSingleBenchmarkResultList, -2000, -40, -2000);
        this.addSingleBenchmark(this.b, this.bSingleBenchmarkResultList, -40, -40, -2000);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        PlannerAssert.assertCompareToOrder((Comparator)this.comparator, (Object[])new SolverBenchmarkResult[]{this.a, this.b});
    }

    @Test
    void differentScoreDefinitions() {
        this.addSingleBenchmark(this.a, this.aSingleBenchmarkResultList, -1000, -30, -1000);
        this.addSingleBenchmark(this.a, this.aSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.a, this.aSingleBenchmarkResultList, -30, -30, -1000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        this.addSingleBenchmarkWithHardSoftLongScore(this.b, this.bSingleBenchmarkResultList, 0L, -1000L, 0L, -50L, -10L, -1000L);
        this.addSingleBenchmarkWithHardSoftLongScore(this.b, this.bSingleBenchmarkResultList, 0L, -200L, 0L, -50L, -10L, -1000L);
        this.addSingleBenchmarkWithHardSoftLongScore(this.b, this.bSingleBenchmarkResultList, -7L, -50L, 0L, -50L, -10L, -1000L);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        PlannerAssert.assertCompareToOrder((Comparator)this.comparator, (Object[])new SolverBenchmarkResult[]{this.a, this.b});
    }

    @Test
    void uninitializedSingleBenchmarks() {
        SingleBenchmarkResult a0 = this.addSingleBenchmark(this.a, this.aSingleBenchmarkResultList, -1000, -30, -1000);
        this.addSingleBenchmark(this.a, this.aSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.a, this.aSingleBenchmarkResultList, -30, -30, -1000);
        this.a.setSingleBenchmarkResultList(this.aSingleBenchmarkResultList);
        this.a.accumulateResults(this.benchmarkReport);
        SingleBenchmarkResult b0 = this.addSingleBenchmark(this.b, this.bSingleBenchmarkResultList, -1000, -30, -1000);
        SingleBenchmarkResult b1 = this.addSingleBenchmark(this.b, this.bSingleBenchmarkResultList, -400, -30, -1000);
        this.addSingleBenchmark(this.b, this.bSingleBenchmarkResultList, -30, -30, -1000);
        this.b.setSingleBenchmarkResultList(this.bSingleBenchmarkResultList);
        this.b.accumulateResults(this.benchmarkReport);
        PlannerAssert.assertCompareToEquals((Comparator)this.comparator, (Object[])new SolverBenchmarkResult[]{this.a, this.b});
        a0.setAverageAndTotalScoreForTesting((Score)SimpleScore.ofUninitialized((int)-100, (int)-1000));
        b0.setAverageAndTotalScoreForTesting((Score)SimpleScore.ofUninitialized((int)-100, (int)-1000));
        b1.setAverageAndTotalScoreForTesting((Score)SimpleScore.ofUninitialized((int)-100, (int)400));
        this.a.accumulateResults(this.benchmarkReport);
        this.b.accumulateResults(this.benchmarkReport);
        PlannerAssert.assertCompareToOrder((Comparator)this.comparator, (Object[])new SolverBenchmarkResult[]{this.b, this.a});
        a0.setAverageAndTotalScoreForTesting((Score)SimpleScore.ofUninitialized((int)-101, (int)-1000));
        this.a.accumulateResults(this.benchmarkReport);
        PlannerAssert.assertCompareToOrder((Comparator)this.comparator, (Object[])new SolverBenchmarkResult[]{this.a, this.b});
        b0.setAverageAndTotalScoreForTesting((Score)SimpleScore.of((int)-1000));
        b1.setAverageAndTotalScoreForTesting((Score)SimpleScore.ofUninitialized((int)-100, (int)400));
        this.b.accumulateResults(this.benchmarkReport);
        PlannerAssert.assertCompareToOrder((Comparator)this.comparator, (Object[])new SolverBenchmarkResult[]{this.a, this.b});
    }
}

