/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.common;

import javax.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum SelectionOrder {
    INHERIT,
    ORIGINAL,
    SORTED,
    RANDOM,
    SHUFFLED,
    PROBABILISTIC;


    public static SelectionOrder resolve(SelectionOrder selectionOrder, SelectionOrder inheritedSelectionOrder) {
        if (selectionOrder == null || selectionOrder == INHERIT) {
            if (inheritedSelectionOrder == null) {
                throw new IllegalArgumentException("The inheritedSelectionOrder (" + inheritedSelectionOrder + ") cannot be null.");
            }
            return inheritedSelectionOrder;
        }
        return selectionOrder;
    }

    public static SelectionOrder fromRandomSelectionBoolean(boolean randomSelection) {
        return randomSelection ? RANDOM : ORIGINAL;
    }

    public boolean toRandomSelectionBoolean() {
        if (this == RANDOM) {
            return true;
        }
        if (this == ORIGINAL) {
            return false;
        }
        throw new IllegalStateException("The selectionOrder (" + this + ") cannot be casted to a randomSelectionBoolean.");
    }
}

