/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import org.optaplanner.core.impl.domain.solution.cloner.DeepCloningUtils;
import org.optaplanner.core.impl.domain.solution.cloner.FieldCloner;

final class ByteFieldCloner
implements FieldCloner {
    static final FieldCloner INSTANCE = new ByteFieldCloner();

    @Override
    public <C> void clone(DeepCloningUtils deepCloningUtils, Field field, Class<? extends C> instanceClass, C original, C clone, Consumer<Object> deferredValueConsumer) {
        byte originalValue = ByteFieldCloner.getFieldValue(original, field);
        ByteFieldCloner.setFieldValue(clone, field, originalValue);
    }

    private static byte getFieldValue(Object bean, Field field) {
        try {
            return field.getByte(bean);
        }
        catch (IllegalAccessException e) {
            throw FieldCloner.createExceptionOnRead(bean, field, e);
        }
    }

    private static void setFieldValue(Object bean, Field field, byte value) {
        try {
            field.setByte(bean, value);
        }
        catch (IllegalAccessException e) {
            throw FieldCloner.createExceptionOnWrite(bean, field, value, e);
        }
    }

    private ByteFieldCloner() {
    }
}

