/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.partitionedsearch;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.partitionedsearch.PartitionedSearchPhaseConfig;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.partitionedsearch.DefaultPartitionedSearchPhase;
import org.optaplanner.core.impl.partitionedsearch.PartitionedSearchPhase;
import org.optaplanner.core.impl.partitionedsearch.partitioner.SolutionPartitioner;
import org.optaplanner.core.impl.phase.AbstractPhaseFactory;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPartitionedSearchPhaseFactory<Solution_>
extends AbstractPhaseFactory<Solution_, PartitionedSearchPhaseConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPartitionedSearchPhaseFactory.class);

    public DefaultPartitionedSearchPhaseFactory(PartitionedSearchPhaseConfig phaseConfig) {
        super(phaseConfig);
    }

    @Override
    public PartitionedSearchPhase<Solution_> buildPhase(int phaseIndex, HeuristicConfigPolicy<Solution_> solverConfigPolicy, BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination<Solution_> solverTermination) {
        HeuristicConfigPolicy<Solution_> phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        ThreadFactory threadFactory = solverConfigPolicy.buildThreadFactory(ChildThreadType.PART_THREAD);
        Termination<Solution_> phaseTermination = this.buildPhaseTermination(phaseConfigPolicy, solverTermination);
        Integer resolvedActiveThreadCount = this.resolveActiveThreadCount(((PartitionedSearchPhaseConfig)this.phaseConfig).getRunnablePartThreadLimit());
        List<PhaseConfig> phaseConfigList_ = ((PartitionedSearchPhaseConfig)this.phaseConfig).getPhaseConfigList();
        if (ConfigUtils.isEmptyCollection(phaseConfigList_)) {
            phaseConfigList_ = Arrays.asList(new ConstructionHeuristicPhaseConfig(), new LocalSearchPhaseConfig());
        }
        DefaultPartitionedSearchPhase.Builder<Solution_> builder = new DefaultPartitionedSearchPhase.Builder<Solution_>(phaseIndex, solverConfigPolicy.getLogIndentation(), phaseTermination, this.buildSolutionPartitioner(), threadFactory, resolvedActiveThreadCount, phaseConfigList_, phaseConfigPolicy.createChildThreadConfigPolicy(ChildThreadType.PART_THREAD));
        EnvironmentMode environmentMode = phaseConfigPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            builder.setAssertStepScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            builder.setAssertExpectedStepScore(true);
            builder.setAssertShadowVariablesAreNotStaleAfterStep(true);
        }
        return builder.build();
    }

    private SolutionPartitioner<Solution_> buildSolutionPartitioner() {
        if (((PartitionedSearchPhaseConfig)this.phaseConfig).getSolutionPartitionerClass() != null) {
            SolutionPartitioner<?> solutionPartitioner = ConfigUtils.newInstance(this.phaseConfig, "solutionPartitionerClass", ((PartitionedSearchPhaseConfig)this.phaseConfig).getSolutionPartitionerClass());
            ConfigUtils.applyCustomProperties(solutionPartitioner, "solutionPartitionerClass", ((PartitionedSearchPhaseConfig)this.phaseConfig).getSolutionPartitionerCustomProperties(), "solutionPartitionerCustomProperties");
            return solutionPartitioner;
        }
        if (((PartitionedSearchPhaseConfig)this.phaseConfig).getSolutionPartitionerCustomProperties() != null) {
            throw new IllegalStateException("If there is no solutionPartitionerClass (" + ((PartitionedSearchPhaseConfig)this.phaseConfig).getSolutionPartitionerClass() + "), then there can be no solutionPartitionerCustomProperties (" + ((PartitionedSearchPhaseConfig)this.phaseConfig).getSolutionPartitionerCustomProperties() + ") either.");
        }
        throw new UnsupportedOperationException();
    }

    protected Integer resolveActiveThreadCount(String runnablePartThreadLimit) {
        Integer resolvedActiveThreadCount;
        boolean threadLimitNullOrAuto;
        int availableProcessorCount = this.getAvailableProcessors();
        boolean bl = threadLimitNullOrAuto = runnablePartThreadLimit == null || runnablePartThreadLimit.equals("AUTO");
        if (threadLimitNullOrAuto) {
            resolvedActiveThreadCount = Math.max(1, availableProcessorCount - 2);
        } else if (runnablePartThreadLimit.equals("UNLIMITED")) {
            resolvedActiveThreadCount = null;
        } else {
            resolvedActiveThreadCount = ConfigUtils.resolvePoolSize("runnablePartThreadLimit", runnablePartThreadLimit, "AUTO", "UNLIMITED");
            if (resolvedActiveThreadCount < 1) {
                throw new IllegalArgumentException("The runnablePartThreadLimit (" + runnablePartThreadLimit + ") resulted in a resolvedActiveThreadCount (" + resolvedActiveThreadCount + ") that is lower than 1.");
            }
            if (resolvedActiveThreadCount > availableProcessorCount) {
                LOGGER.debug("The resolvedActiveThreadCount ({}) is higher than the availableProcessorCount ({}), so the JVM will round-robin the CPU instead.", (Object)resolvedActiveThreadCount, (Object)availableProcessorCount);
            }
        }
        return resolvedActiveThreadCount;
    }

    protected int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }
}

