/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

@XmlType(propOrder={"solutionFileIOClass", "writeOutputSolutionEnabled", "inputSolutionFileList", "problemStatisticEnabled", "problemStatisticTypeList", "singleStatisticTypeList"})
public class ProblemBenchmarksConfig
extends AbstractConfig<ProblemBenchmarksConfig> {
    private Class<? extends SolutionFileIO<?>> solutionFileIOClass = null;
    private Boolean writeOutputSolutionEnabled = null;
    @XmlElement(name="inputSolutionFile")
    private List<File> inputSolutionFileList = null;
    private Boolean problemStatisticEnabled = null;
    @XmlElement(name="problemStatisticType")
    private List<ProblemStatisticType> problemStatisticTypeList = null;
    @XmlElement(name="singleStatisticType")
    private List<SingleStatisticType> singleStatisticTypeList = null;

    public Class<? extends SolutionFileIO<?>> getSolutionFileIOClass() {
        return this.solutionFileIOClass;
    }

    public void setSolutionFileIOClass(Class<? extends SolutionFileIO<?>> solutionFileIOClass) {
        this.solutionFileIOClass = solutionFileIOClass;
    }

    public Boolean getWriteOutputSolutionEnabled() {
        return this.writeOutputSolutionEnabled;
    }

    public void setWriteOutputSolutionEnabled(Boolean writeOutputSolutionEnabled) {
        this.writeOutputSolutionEnabled = writeOutputSolutionEnabled;
    }

    public List<File> getInputSolutionFileList() {
        return this.inputSolutionFileList;
    }

    public void setInputSolutionFileList(List<File> inputSolutionFileList) {
        this.inputSolutionFileList = inputSolutionFileList;
    }

    public Boolean getProblemStatisticEnabled() {
        return this.problemStatisticEnabled;
    }

    public void setProblemStatisticEnabled(Boolean problemStatisticEnabled) {
        this.problemStatisticEnabled = problemStatisticEnabled;
    }

    public List<ProblemStatisticType> getProblemStatisticTypeList() {
        return this.problemStatisticTypeList;
    }

    public void setProblemStatisticTypeList(List<ProblemStatisticType> problemStatisticTypeList) {
        this.problemStatisticTypeList = problemStatisticTypeList;
    }

    public List<SingleStatisticType> getSingleStatisticTypeList() {
        return this.singleStatisticTypeList;
    }

    public void setSingleStatisticTypeList(List<SingleStatisticType> singleStatisticTypeList) {
        this.singleStatisticTypeList = singleStatisticTypeList;
    }

    public List<ProblemStatisticType> determineProblemStatisticTypeList() {
        if (this.problemStatisticEnabled != null && !this.problemStatisticEnabled.booleanValue()) {
            return Collections.emptyList();
        }
        if (this.problemStatisticTypeList == null || this.problemStatisticTypeList.isEmpty()) {
            return ProblemStatisticType.defaultList();
        }
        return this.problemStatisticTypeList;
    }

    public List<SingleStatisticType> determineSingleStatisticTypeList() {
        return Objects.requireNonNullElse(this.singleStatisticTypeList, Collections.emptyList());
    }

    public ProblemBenchmarksConfig inherit(ProblemBenchmarksConfig inheritedConfig) {
        this.solutionFileIOClass = (Class)ConfigUtils.inheritOverwritableProperty(this.solutionFileIOClass, inheritedConfig.getSolutionFileIOClass());
        this.writeOutputSolutionEnabled = (Boolean)ConfigUtils.inheritOverwritableProperty((Object)this.writeOutputSolutionEnabled, (Object)inheritedConfig.getWriteOutputSolutionEnabled());
        this.inputSolutionFileList = ConfigUtils.inheritMergeableListProperty(this.inputSolutionFileList, inheritedConfig.getInputSolutionFileList());
        this.problemStatisticEnabled = (Boolean)ConfigUtils.inheritOverwritableProperty((Object)this.problemStatisticEnabled, (Object)inheritedConfig.getProblemStatisticEnabled());
        this.problemStatisticTypeList = ConfigUtils.inheritMergeableListProperty(this.problemStatisticTypeList, inheritedConfig.getProblemStatisticTypeList());
        this.singleStatisticTypeList = ConfigUtils.inheritMergeableListProperty(this.singleStatisticTypeList, inheritedConfig.getSingleStatisticTypeList());
        return this;
    }

    public ProblemBenchmarksConfig copyConfig() {
        return new ProblemBenchmarksConfig().inherit(this);
    }

    public void visitReferencedClasses(Consumer<Class<?>> classVisitor) {
        classVisitor.accept(this.solutionFileIOClass);
    }
}

