/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.swingui.realtime;

import java.util.ArrayList;
import java.util.function.LongFunction;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.api.solver.change.ProblemChangeDirector;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;

public class AddComputerProblemChange
implements ProblemChange<CloudBalance> {
    private final LongFunction<CloudComputer> generator;

    public AddComputerProblemChange(LongFunction<CloudComputer> generator) {
        this.generator = generator;
    }

    public void doChange(CloudBalance cloudBalance, ProblemChangeDirector problemChangeDirector) {
        long nextComputerId = 0L;
        for (CloudComputer otherComputer : cloudBalance.getComputerList()) {
            if (nextComputerId > otherComputer.getId()) continue;
            nextComputerId = otherComputer.getId() + 1L;
        }
        CloudComputer computer = this.generator.apply(nextComputerId);
        cloudBalance.setComputerList(new ArrayList<CloudComputer>(cloudBalance.getComputerList()));
        problemChangeDirector.addProblemFact((Object)computer, cloudBalance.getComputerList()::add);
    }
}

