/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.domain;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.jackson.JacksonUniqueIdGenerator;
import org.optaplanner.examples.common.swingui.components.Labeled;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;
import org.optaplanner.examples.nurserostering.domain.ShiftType;

@JsonIdentityInfo(generator=JacksonUniqueIdGenerator.class)
public class Shift
extends AbstractPersistable
implements Labeled {
    private ShiftDate shiftDate;
    private ShiftType shiftType;
    private int index;
    private int requiredEmployeeSize;

    public Shift() {
    }

    public Shift(long id) {
        super(id);
    }

    public Shift(long id, ShiftDate shiftDate, ShiftType shiftType, int index, int requiredEmployeeSize) {
        this(id);
        this.shiftDate = shiftDate;
        this.shiftType = shiftType;
        this.index = index;
        this.requiredEmployeeSize = requiredEmployeeSize;
    }

    public ShiftDate getShiftDate() {
        return this.shiftDate;
    }

    public void setShiftDate(ShiftDate shiftDate) {
        this.shiftDate = shiftDate;
    }

    public ShiftType getShiftType() {
        return this.shiftType;
    }

    public void setShiftType(ShiftType shiftType) {
        this.shiftType = shiftType;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getRequiredEmployeeSize() {
        return this.requiredEmployeeSize;
    }

    public void setRequiredEmployeeSize(int requiredEmployeeSize) {
        this.requiredEmployeeSize = requiredEmployeeSize;
    }

    @Override
    public String getLabel() {
        return this.shiftType.getLabel() + " of " + this.shiftDate.getLabel();
    }

    @Override
    public String toString() {
        return this.shiftDate + "/" + this.shiftType;
    }
}

